/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixItHint;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierBase;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyIntentionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.MisraProblemGroup;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyAnnotationApplierImpl
extends ClangTidyAnnotationApplierBase {
    @NotNull
    protected SuppressableProblemGroup createProblemGroup(@NotNull PsiFile file, @NotNull TextRange highlightRange, @NotNull String checkName, @NotNull ClangTidyInspectionBase inspection) {
        boolean canSuppressByInlineComment;
        boolean canDisable = inspection.canBeDisabledByClangTidyCheckName(file.getVirtualFile(), file.getProject());
        boolean bl = canSuppressByInlineComment = !(inspection instanceof OurClangTidyInspection);
        if (ClangTidyInspectionBase.isMisraInspection((String)checkName)) {
            return new MisraProblemGroup(file, highlightRange, checkName, canDisable, inspection.getShortName());
        }
        if (checkName.startsWith("-Wclazy")) {
            return new ClazyProblemGroup(checkName, canDisable, inspection.getShortName());
        }
        return new ClangTidyProblemGroup(file, highlightRange, checkName, canDisable, canSuppressByInlineComment, inspection.getShortName());
    }

    @Nullable
    protected TextRange getRangeToHighlight(@NotNull PsiFile file, @NotNull ClangTidyDiagnostic diagnostic, @NotNull ClangTidyInspectionBase sourceInspection) {
        boolean isMisraInspection = sourceInspection instanceof MisraInspection;
        PsiElement elementToAnnotate = ClangTidyAnnotationApplierImpl.getElementToAnnotate(file, diagnostic.getFileOffset(), isMisraInspection);
        return elementToAnnotate != null ? ClangTidyAnnotationApplierImpl.getRangeToHighlight(elementToAnnotate, isMisraInspection, diagnostic.getRanges()) : null;
    }

    protected boolean isSuppressed(@NotNull PsiFile file, int offset, @NotNull String suppressName) {
        OCFile ocFile = OCLanguageUtils.asOCFile((PsiFile)file);
        return ocFile != null && OCPragmaSuppressionUtils.getDiagnosticMode((OCFile)ocFile, (int)offset, (String)suppressName) == OCPragma.Mode.IGNORE;
    }

    @NotNull
    protected List<IntentionAction> createQuickFixes(@NotNull PsiFile file, @NotNull @NlsSafe String diagnosticMessage, @NotNull ClangTidyDiagnostic diagnostic, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull ClangUrlConverter urlConverter) {
        String quickFixMessage;
        List replacements = diagnostic.getReplacements();
        ClionFixItHint clionFix = diagnostic.getClionFix();
        String diagnosticName = diagnostic.getDiagnosticName();
        String string = quickFixMessage = sourceInspection.getQuickFixMessage() != null ? sourceInspection.getQuickFixMessage() : diagnosticMessage;
        if (clionFix != null) {
            return ClangQuickFixFactoryKt.getClangQuickFixes(clionFix, OCResolveContext.forPsi((PsiElement)file), (PsiElement)file, urlConverter);
        }
        if (replacements.isEmpty()) {
            return Collections.singletonList(new EmptyIntentionAction(sourceInspection.getDisplayName()));
        }
        return Collections.singletonList(new ClangTidyIntentionAction(quickFixMessage, diagnosticName, replacements));
    }

    protected boolean shouldIgnoreForFile(@NotNull PsiFile file) {
        return OCLanguageUtils.asOCFile((PsiFile)file) == null;
    }

    @Nullable
    public static PsiElement getElementToAnnotate(@NotNull PsiFile file, int offset, boolean useExactRange) {
        PsiElement element;
        PsiElement psiElement = element = file.getTextLength() > offset ? file.findElementAt(offset) : file.getLastChild();
        if (element instanceof PsiComment || useExactRange) {
            return element;
        }
        if (!OCElementUtil.isElementSignificant((PsiElement)element)) {
            element = OCElementUtil.getPrevSignificantSibling((PsiElement)element);
        }
        if (element == null) {
            return null;
        }
        if (ClangTidyAnnotationApplierImpl.isMakeSenseToHighlight(element.getNode().getElementType())) {
            return element;
        }
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class}) != null) {
            return element;
        }
        OCElement context = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCStatement.class, OCExpression.class, OCTypeElement.class, OCDeclarator.class, OCDeclaration.class, OCStructLike.class});
        assert (!(context instanceof PsiFile));
        assert (!(element instanceof PsiFile));
        return context != null ? context : element;
    }

    private static boolean isMakeSenseToHighlight(@NotNull IElementType elementType) {
        if (elementType == OCTokenTypes.LBRACE || elementType == OCTokenTypes.RBRACE || elementType == OCTokenTypes.COMMA) {
            return true;
        }
        if (!OCTokenTypes.KEYWORDS.contains(elementType) || OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(elementType)) {
            return false;
        }
        HashSet keywordsToIgnore = ContainerUtil.newHashSet((Object[])new IElementType[]{OCTokenTypes.OPERATOR_CPP_KEYWORD, OCTokenTypes.VIRTUAL_CPP_KEYWORD, OCTokenTypes.EXPLICIT_CPP_KEYWORD, OCTokenTypes.INLINE_KEYWORD, OCTokenTypes.EXTERN_KEYWORD, OCTokenTypes.REGISTER_KEYWORD, OCTokenTypes.STATIC_KEYWORD, OCTokenTypes.CONST_KEYWORD, OCTokenTypes.VOLATILE_KEYWORD});
        return !keywordsToIgnore.contains(elementType);
    }

    @NotNull
    private static TextRange getRangeToHighlight(@NotNull PsiElement element) {
        List declarators;
        PsiElement identifier;
        OCElementType keyword = null;
        if (element instanceof OCStatementWithExpression) {
            keyword = ((OCStatementWithExpression)element).getKeywordType();
        } else if (element instanceof OCIfStatement) {
            keyword = OCTokenTypes.IF_KEYWORD;
        } else if (element instanceof OCCppNamespace) {
            keyword = OCTokenTypes.NAMESPACE_CPP_KEYWORD;
        }
        if (keyword != null) {
            OCElementType keywordToSearch = keyword;
            Optional<ASTNode> keywordElement = Arrays.stream(element.getNode().getChildren(null)).filter(child -> child.getElementType() == keywordToSearch).findFirst();
            if (keywordElement.isPresent()) {
                return keywordElement.get().getTextRange();
            }
        }
        if (element instanceof OCStructLike && (identifier = ((OCStructLike)element).getNameIdentifier()) != null) {
            return OCElementUtil.getRangeWithMacros((PsiElement)identifier);
        }
        if (element instanceof OCDeclaration && (declarators = ((OCDeclaration)element).getDeclarators()).size() == 1 && ((OCDeclarator)declarators.get(0)).getName() != "<unnamed>") {
            element = (PsiElement)declarators.get(0);
        }
        if (element instanceof OCDeclarator && (identifier = ((OCDeclarator)element).getNameIdentifier()) != null) {
            return OCElementUtil.getRangeWithMacros((PsiElement)identifier);
        }
        if (element instanceof LeafPsiElement && element.getText().equals("typename") && element.getParent() instanceof OCTypeElement) {
            return element.getParent().getTextRange();
        }
        return OCElementUtil.getRangeWithMacros((PsiElement)element);
    }

    @NotNull
    private static TextRange getRangeToHighlight(@NotNull PsiElement elementToAnnotate, boolean isMisraInspection, @NotNull List<ClangTidyRange> additionalRanges) {
        if (isMisraInspection && additionalRanges.size() == 1) {
            ClangTidyRange range = additionalRanges.get(0);
            return new TextRange(range.getFileOffset(), range.getFileOffset() + Math.max(range.getLength(), 1));
        }
        return ClangTidyAnnotationApplierImpl.getRangeToHighlight(elementToAnnotate);
    }
}

