/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigation;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigation.ClangLineMarkerInfo;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangLineMarkerProvider
implements LineMarkerProvider {
    private static final boolean ourLineMarkersEnabled = Registry.is((String)"clion.clang.clangd.index.on");

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (!ourLineMarkersEnabled) {
            return null;
        }
        return ClangLineMarkerProvider.getClionMarkerFor(element, true);
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (!ourLineMarkersEnabled) {
            return;
        }
        for (PsiElement psiElement : elements) {
            ClangLineMarkerInfo marker = ClangLineMarkerProvider.getClionMarkerFor(psiElement, false);
            if (marker == null) continue;
            result2.add(marker);
        }
    }

    @Nullable
    private static ClangLineMarkerInfo getClionMarkerFor(@NotNull PsiElement element, boolean fastMarker) {
        List<ClionLineMarker> allMarkers;
        ClionLineMarker marker;
        Document document;
        if (OCElementUtil.isPartOfMacroSubstitution((PsiElement)element)) {
            return null;
        }
        PsiNameIdentifierOwner owner = OCLineMarkerProvider.getElementFromNameIdentifier((PsiElement)element);
        if (owner == null) {
            return null;
        }
        PsiElement nameIdentifier = owner.getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        if (owner instanceof OCDeclarator && owner.getParent() instanceof OCFunctionDeclaration) {
            owner = owner.getParent();
        }
        if ((document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile())) == null) {
            return null;
        }
        TextRange range = null;
        List<SymbolKind> kinds = null;
        if (owner instanceof OCFunctionDefinition) {
            OCBlockStatement body = ((OCFunctionDefinition)owner).getBody();
            range = body != null ? new TextRange(owner.getTextRange().getStartOffset(), body.getTextRange().getStartOffset()) : owner.getTextRange();
            kinds = Arrays.asList(SymbolKind.Function, SymbolKind.Method, SymbolKind.Constructor);
        } else if (owner instanceof OCFunctionDeclaration) {
            range = owner.getTextRange();
            kinds = Arrays.asList(SymbolKind.Function, SymbolKind.Method, SymbolKind.Constructor);
        } else if (owner instanceof OCStruct) {
            range = owner.getTextRange();
            kinds = Arrays.asList(SymbolKind.Class, SymbolKind.Struct);
        }
        if (range != null && (marker = ClangLineMarkerProvider.findBestMarker(document, range, allMarkers = ClangLineMarkerProvider.getAllClionMarkers(owner.getProject(), owner.getContainingFile().getVirtualFile(), document, fastMarker), kinds)) != null) {
            return new ClangLineMarkerInfo(nameIdentifier, marker);
        }
        return null;
    }

    @Nullable
    private static List<ClionLineMarker> getAllClionMarkers(@NotNull Project project, @NotNull VirtualFile vf, @NotNull Document doc, boolean fastMarkers) {
        boolean startOffset = false;
        int endOffset = doc.getImmutableCharSequence().length();
        Ref markers = Ref.create();
        ClangResultConsumer resultConsumer = result2 -> {
            try {
                markers.set((Object)((List)result2.waitForResult()));
            }
            catch (ExecutionException ex) {
                CidrLogService.LOG.warn((Throwable)ex);
            }
        };
        ClangLanguageService service = ClangLanguageServiceProvider.getOrStart((Project)project);
        if (fastMarkers) {
            service.getFastLineMarkers(vf, 0, endOffset, resultConsumer);
        } else {
            service.getSlowLineMarkers(vf, 0, endOffset, resultConsumer);
        }
        return (List)markers.get();
    }

    @Nullable
    private static ClionLineMarker findBestMarker(@NotNull Document document, @NotNull TextRange range, @Nullable List<ClionLineMarker> markers, @NotNull List<SymbolKind> kinds) {
        if (markers == null) {
            return null;
        }
        EnumSet<SymbolKind> kindSet = EnumSet.copyOf(kinds);
        Range structRange = ClangLanguageServiceUtils.offsets2Range((Document)document, (int)range.getStartOffset(), (int)range.getEndOffset());
        Position startPos = structRange.getStart();
        for (ClionLineMarker marker : markers) {
            if (!kindSet.contains(marker.getSource().getKind()) || marker.getTargets().isEmpty()) continue;
            Position markerStartPos = marker.getSource().getLocation().getRange().getStart();
            if (startPos.getLine() != markerStartPos.getLine()) continue;
            return marker;
        }
        return null;
    }

    @Nullable
    private static PsiElement getNameElementForMarker(@Nullable PsiElement element) {
        PsiElement name = OCLineMarkerProvider.getIdElement((PsiElement)element);
        if (name != null) {
            PsiElement nameFromMacro = ClangLineMarkerProvider.getNameElementForMacroRange(OCElementUtil.getRangeInMacroCall((PsiElement)name));
            return nameFromMacro != null ? nameFromMacro : name;
        }
        return element;
    }

    @Nullable
    private static PsiElement getNameElementForMacroRange(@Nullable OCMacroRange range) {
        if (range == null) {
            return null;
        }
        OCReferenceElement ref = range.getMacroCall().getMacroReferenceElement();
        if (ref == null) {
            return null;
        }
        return ref.getNameIdentifier();
    }
}

