/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangFileFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGlobalCompletionCacheParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCSourceGliderService;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\nH\u0014J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/AdvancedClangIdeFacadeImpl;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeImpl;", "descriptor", "", "(Ljava/lang/String;)V", "getDFAOptions", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangDFAConfigParams;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileFacade", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangFileFacade;", "document", "Lcom/intellij/openapi/editor/Document;", "getGlobalCompletionCacheParams", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionGlobalCompletionCacheParams;", "getOCPsiFile", "Lcom/jetbrains/cidr/lang/psi/OCPsiFile;", "getResolveInfoForFile", "Lcom/jetbrains/cidr/lang/daemon/clang/ClangUtils$ResolveInfo;", "vf", "getUnusedIncludesInspectionMode", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/UnusedIncludesInspectionMode;", "ocFile", "intellij.c.clangdBridge"})
public class AdvancedClangIdeFacadeImpl
extends ClangIdeFacadeImpl {
    public AdvancedClangIdeFacadeImpl(@NotNull String descriptor) {
        super(descriptor);
    }

    @NotNull
    public ClangFileFacade getFileFacade(@NotNull VirtualFile file, @NotNull Document document) {
        return new AdvancedClangFileFacadeImpl(file, document);
    }

    @Nullable
    protected ClangUtils.ResolveInfo getResolveInfoForFile(@NotNull Project project, @NotNull VirtualFile vf) {
        OCPsiFile ocFile = this.getOCPsiFile(project, vf);
        if (ocFile != null) {
            return ClangIdeFacadeUtil.Companion.getInstance().getResolveInfoForFile(project, ocFile, vf);
        }
        return super.getResolveInfoForFile(project, vf);
    }

    @Nullable
    public UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(@NotNull Project project, @NotNull VirtualFile file) {
        OCPsiFile ocFile = this.getOCPsiFile(project, file);
        if (ocFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("Failed to get OCPsiFile for file " + file.getPath()));
            return null;
        }
        return this.getUnusedIncludesInspectionMode(ocFile);
    }

    @Nullable
    public ClionClangDFAConfigParams getDFAOptions(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        Optional dfaConfigParams = (Optional)project.getUserData(ClangIdeFacadeImpl.CLANG_DFA_CONFIG);
        if (dfaConfigParams != null) {
            return dfaConfigParams.isEmpty() ? null : (ClionClangDFAConfigParams)dfaConfigParams.get();
        }
        return psiFile != null && OCInspectionUtil.isClangdDFAEnabled((PsiElement)((PsiElement)psiFile)) ? new ClionClangDFAConfigParams(OCSourceGliderService.isGlobalMode((PsiFile)psiFile)) : null;
    }

    @NotNull
    public ClionGlobalCompletionCacheParams getGlobalCompletionCacheParams(@NotNull Project project, @NotNull VirtualFile file) {
        ClangdSettings settings = ClangdSettings.getInstance((Project)project);
        return new ClionGlobalCompletionCacheParams(settings.getGlobalCompletionCacheEnabled());
    }

    private final OCPsiFile getOCPsiFile(Project project, VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("Failed to get PSI file for file: " + file.getPath()));
            return null;
        }
        OCPsiFile ocFile = OCLanguageUtils.asOCPsiFile((PsiFile)psiFile);
        if (ocFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("PSI file is not OCPsiFile: " + file.getPath()));
            return null;
        }
        return ocFile;
    }

    private final UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(OCPsiFile ocFile) {
        Class<OCUnusedIncludeDirectiveInspection> inspectionClass = OCUnusedIncludeDirectiveInspection.class;
        if (!OCInspectionUtil.isInspectionEnabled((Project)ocFile.getProject(), inspectionClass)) {
            return UnusedIncludesInspectionMode.Off;
        }
        if (Intrinsics.areEqual(inspectionClass, OCUnusedIncludeDirectiveInspection.class)) {
            InspectionProfile inspectionProfile;
            InspectionToolWrapper tool;
            HighlightDisplayKey key;
            String shortName;
            String string = shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
            Object object = key = string != null ? HighlightDisplayKey.find((String)string) : null;
            if (key != null && (tool = (inspectionProfile = (InspectionProfile)InspectionProjectProfileManager.getInstance((Project)ocFile.getProject()).getCurrentProfile()).getInspectionTool(key.toString(), ocFile.getProject())) != null && tool.getTool() instanceof OCUnusedIncludeDirectiveInspection) {
                UnusedIncludesInspectionMode unusedIncludesInspectionMode;
                InspectionProfileEntry inspectionProfileEntry = tool.getTool();
                Intrinsics.checkNotNull((Object)inspectionProfileEntry, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection");
                OCUnusedIncludeDirectiveInspection inspection = (OCUnusedIncludeDirectiveInspection)inspectionProfileEntry;
                if (!inspection.showInHeaders && ocFile.isHeader()) {
                    unusedIncludesInspectionMode = UnusedIncludesInspectionMode.Off;
                } else {
                    switch (WhenMappings.$EnumSwitchMapping$0[inspection.strategy.ordinal()]) {
                        case 1: {
                            unusedIncludesInspectionMode = UnusedIncludesInspectionMode.RemoveCompletelyUnused;
                            break;
                        }
                        case 2: {
                            unusedIncludesInspectionMode = UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
                            break;
                        }
                        case 3: {
                            unusedIncludesInspectionMode = UnusedIncludesInspectionMode.RemoveNotRequired;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                return unusedIncludesInspectionMode;
            }
        }
        return UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OCUnusedIncludeDirectiveInspection.EliminateStrategy.values().length];
            try {
                nArray[OCUnusedIncludeDirectiveInspection.EliminateStrategy.RemoveCompletelyUnused.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCUnusedIncludeDirectiveInspection.EliminateStrategy.RemoveNotDirectlyUsed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCUnusedIncludeDirectiveInspection.EliminateStrategy.RemoveNotRequired.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

