/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.documentation;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.documentation.ClangDocumentationProviderKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClionHoverInfo;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCSourceGliderService;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDFAAggregationValue;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDfaResultProvider;
import com.jetbrains.cidr.lang.documentation.CidrDocumentationProvider;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/documentation/ClangDocumentationProvider;", "Lcom/jetbrains/cidr/lang/documentation/CidrDocumentationProvider;", "()V", "getEvaluatedExpressionInfo", "", "Lorg/jetbrains/annotations/Nls;", "element", "Lcom/intellij/psi/PsiElement;", "getValuesFromDFA", "Lcom/jetbrains/cidr/lang/dfa/contextSensitive/valueProvider/OCDFAAggregationValue;", "isDfaDocEnabled", "", "intellij.c.clangdBridge"})
public final class ClangDocumentationProvider
extends CidrDocumentationProvider {
    private final boolean isDfaDocEnabled() {
        return OCSourceGliderService.isCollectResultForQuickDoc();
    }

    @Nullable
    protected String getEvaluatedExpressionInfo(@NotNull PsiElement element) {
        Project project = element.getProject();
        if (!ClangUtils.isClangdOn((Project)project)) {
            return null;
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Ref ref = Ref.create();
        service.getHoverInfo(virtualFile2, element.getTextOffset(), arg_0 -> ClangDocumentationProvider.getEvaluatedExpressionInfo$lambda$0(ref, arg_0));
        OCDFAAggregationValue possibleValuesDFA = this.getValuesFromDFA(element);
        ClionHoverInfo hoverInfo = (ClionHoverInfo)ref.get();
        return hoverInfo == null && possibleValuesDFA == null ? null : ClangDocumentationProviderKt.access$formatHoverInfo(hoverInfo, possibleValuesDFA);
    }

    private final OCDFAAggregationValue getValuesFromDFA(PsiElement element) {
        if (!this.isDfaDocEnabled()) {
            return null;
        }
        boolean $i$f$service = false;
        Class<OCDfaResultProvider> serviceClass$iv = OCDfaResultProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        OCDfaResultProvider dfaService = (OCDfaResultProvider)object;
        return dfaService.loadValues(element.getTextRange(), element.getContainingFile());
    }

    private static final void getEvaluatedExpressionInfo$lambda$0(Ref $ref, ClangResult it) {
        $ref.set(it.waitForResult());
    }
}

