/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import java.util.Locale;

public enum ClangPostfixTemplateFlags {
    None(0L),
    FreeFunction(1L),
    If(2L),
    For(4L),
    Switch(8L),
    Do(16L),
    While(32L),
    Return(64L),
    ReinterpretCast(128L),
    StaticCast(256L),
    DynamicCast(512L),
    ConstCast(1024L),
    Begin(2048L),
    CBegin(4096L),
    RBegin(8192L),
    CRBegin(16384L),
    Forward(32768L),
    Ref(65536L),
    CRef(131072L),
    Move(262144L),
    New(524288L),
    MakeShared(0x100000L),
    MakeUnique(0x200000L),
    Else(0x400000L),
    Not(0x800000L),
    Fori(0x1000000L),
    Formut(0x2000000L),
    CoReturn(0x4000000L),
    CoYield(0x8000000L),
    CoAwait(0x10000000L),
    AlgorithmFunction(0x20000000L);

    private final long value;

    private ClangPostfixTemplateFlags(long value) {
        this.value = value;
    }

    public static ClangPostfixTemplateFlags fromString(String str) {
        return switch (str.toLowerCase(Locale.ROOT)) {
            case "freefunction" -> FreeFunction;
            case "if" -> If;
            case "for" -> For;
            case "switch" -> Switch;
            case "do" -> Do;
            case "while" -> While;
            case "return" -> Return;
            case "reinterpret_cast" -> ReinterpretCast;
            case "static_cast" -> StaticCast;
            case "dynamic_cast" -> DynamicCast;
            case "const_cast" -> ConstCast;
            case "begin..end" -> Begin;
            case "cbegin..cend" -> CBegin;
            case "rbegin..rend" -> RBegin;
            case "crbegin..crend" -> CRBegin;
            case "forward" -> Forward;
            case "ref" -> Ref;
            case "cref" -> CRef;
            case "move" -> Move;
            case "new" -> New;
            case "make_shared" -> MakeShared;
            case "make_unique" -> MakeUnique;
            case "else" -> Else;
            case "not" -> Not;
            case "fori" -> Fori;
            case "formut" -> Formut;
            case "co_return" -> CoReturn;
            case "co_await" -> CoAwait;
            case "co_yield" -> CoYield;
            case "algorithmfunction" -> AlgorithmFunction;
            default -> None;
        };
    }

    public long getValue() {
        return this.value;
    }
}

