/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridgeInterface;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorSlowPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.OurClangTidyInspectionsViaClangdAnnotatorPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ObfuscatorImpl;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ClangdBridgeImpl
implements ClangdBridgeInterface {
    public boolean isClangdOnlyMode() {
        return false;
    }

    public void registerAnnotatorPassFactories(@NotNull TextEditorHighlightingPassRegistrar registrar, int reparsingPassId, int clangErrorsPassId) {
        new ClangErrorsAnnotatorSlowPassFactory(registrar, clangErrorsPassId);
        new OurClangTidyInspectionsViaClangdAnnotatorPassFactory(registrar, reparsingPassId);
    }

    @NotNull
    public List<FileExtensionPair> getFileExtensions(@NotNull Project project) {
        CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
        return ((OCFileExtensionsSettings)settings.getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
    }

    public boolean isSupported(@NotNull VirtualFile vf) {
        return OCLanguageUtils.isSupported((VirtualFile)vf);
    }

    public boolean isSourceFile(@NotNull VirtualFile vf) {
        return !vf.isDirectory() && OCFileTypeHelpers.sourceExtensions().contains(vf.getExtension());
    }

    public boolean isHeaderFile(@NotNull VirtualFile vf) {
        return !vf.isDirectory() && OCFileTypeHelpers.headerExtensions().contains(vf.getExtension());
    }

    public boolean getParameterHints(@NotNull Project project) {
        return HintUtilsKt.isParameterHintsEnabledForLanguage((Language)OCLanguageUtils.getConfigLanguage()) || InlayHintsSettings.instance().hintsEnabled(OCLanguageUtils.getConfigLanguage());
    }

    public void setParameterHints(@NotNull Project project, boolean enabled) {
        HintUtilsKt.setShowParameterHintsForLanguage((boolean)enabled, (Language)OCLanguageUtils.getConfigLanguage());
        InlayHintsSettings.instance().setHintsEnabledForLanguage(OCLanguageUtils.getConfigLanguage(), enabled);
    }

    @NotNull
    public Class<? extends OCInspectionBase> getClazyInspection() {
        return ClazyInspection.class;
    }

    @NotNull
    public Class<? extends OCInspectionBase> getUnusedIncludesInspection() {
        return OCUnusedIncludeDirectiveInspection.class;
    }

    public boolean isInProjectSourcesOrLibraries(@NotNull Project project, @NotNull VirtualFile vf) {
        return OCSearchScope.isInProjectSourcesOrLibraries((Project)project, (VirtualFile)vf);
    }

    @NotNull
    public List<SuppressIntentionAction> createSuppressActions(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String warningName) {
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("clang", warningName);
        OCFile ocFile = OCLanguageUtils.asOCFile((PsiFile)file);
        if (ocFile == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(new OCSuppressClangForFile((PsiFile)ocFile, range, suppressionGroup), new OCSuppressClangForCallable((PsiFile)ocFile, range, suppressionGroup), new OCSuppressClangForStatement((PsiFile)ocFile, range, suppressionGroup));
    }

    @NotNull
    public ClangIdeFacade createClangIdeFacade(@NotNull @NonNls String descriptor, boolean forIndexer) {
        return forIndexer ? new ClangIndexerIdeFacadeImpl(descriptor) : new AdvancedClangIdeFacadeImpl(descriptor);
    }

    @NotNull
    public Obfuscator createObfuscator() {
        return new ObfuscatorImpl();
    }
}

