/*
 * Decompiled with CFR 0.152.
 */
package externalApp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalAppUtil {
    public static <T> T sendXmlRequest(@NotNull String methodName, int port, Object ... parameters) {
        try {
            XmlRpcClientLite client = new XmlRpcClientLite("127.0.0.1", port);
            Vector<Object> params = new Vector<Object>(Arrays.asList(parameters));
            return (T)client.execute(methodName, params);
        }
        catch (IOException | XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @NotNull
    public static String adjustNullTo(@Nullable String s) {
        return s == null ? "-" : "+" + s;
    }

    @Nullable
    public static String adjustNullFrom(@NotNull String s) {
        return s.charAt(0) == '-' ? null : s.substring(1);
    }

    @NotNull
    public static String getEnv(@NotNull String env) {
        String value = System.getenv(env);
        if (value == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        return value;
    }

    public static int getEnvInt(@NotNull String env) {
        return Integer.parseInt(ExternalAppUtil.getEnv(env));
    }
}

