/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionEditor;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class TerminalSessionEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        return file instanceof TerminalSessionVirtualFileImpl;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN) != null) {
            return new TerminalSessionEditor(project, (TerminalSessionVirtualFileImpl)file);
        }
        TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)file;
        JBTerminalWidget widget = terminalFile.getTerminalWidget();
        String workingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory(widget, file.getName());
        Disposable tempDisposable = Disposer.newDisposable();
        JBTerminalWidget newWidget = new LocalTerminalDirectRunner(project).createTerminalWidget(tempDisposable, workingDirectory, true);
        TerminalSessionVirtualFileImpl newSessionVirtualFile = new TerminalSessionVirtualFileImpl(terminalFile.getName(), newWidget, terminalFile.getSettingsProvider());
        TerminalSessionEditor editor = new TerminalSessionEditor(project, newSessionVirtualFile);
        Disposer.dispose((Disposable)tempDisposable);
        return editor;
    }

    @NotNull
    public String getEditorTypeId() {
        return "terminal-session-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

