/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.jediterm.terminal.ui.TerminalWidgetListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public final class TerminalSessionEditor
extends UserDataHolderBase
implements FileEditor {
    private static final Logger LOG = Logger.getInstance(TerminalSessionEditor.class);
    private final Project myProject;
    private final TerminalSessionVirtualFileImpl myFile;
    private final TerminalWidgetListener myListener;
    private final Disposable myWidgetParentDisposable = Disposer.newDisposable((String)"terminal widget parent");

    public TerminalSessionEditor(final Project project, final @NotNull TerminalSessionVirtualFileImpl terminalFile) {
        this.myProject = project;
        this.myFile = terminalFile;
        terminalFile.getTerminalWidget().moveDisposable(this.myWidgetParentDisposable);
        this.myListener = widget -> ApplicationManager.getApplication().invokeLater(() -> FileEditorManagerEx.getInstanceEx((Project)this.myProject).closeFile((VirtualFile)this.myFile), this.myProject.getDisposed());
        this.myFile.getTerminalWidget().addListener(this.myListener);
        terminalFile.getTerminalWidget().getTerminalTitle().addTitleListener(new TerminalTitleListener(){

            public void onTitleChanged(@NotNull TerminalTitle terminalTitle) {
                try {
                    terminalFile.rename(null, terminalTitle.buildTitle());
                }
                catch (IOException exception) {
                    throw new RuntimeException("Cannot rename");
                }
                FileEditorManager.getInstance((Project)project).updateFilePresentation((VirtualFile)terminalFile);
            }
        }, (Disposable)this);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myFile.getTerminalWidget();
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myFile.getTerminalWidget();
    }

    @NotNull
    public String getName() {
        return this.myFile.getName();
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    public void dispose() {
        this.myFile.getTerminalWidget().removeListener(this.myListener);
        if (Boolean.TRUE.equals(this.myFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
            ApplicationManager.getApplication().invokeLater(() -> {
                boolean disposedBefore = Disposer.isDisposed((Disposable)this.myFile.getTerminalWidget());
                Disposer.dispose((Disposable)this.myWidgetParentDisposable);
                boolean disposedAfter = Disposer.isDisposed((Disposable)this.myFile.getTerminalWidget());
                if (disposedBefore != disposedAfter) {
                    LOG.error(JBTerminalWidget.class.getSimpleName() + " parent disposable hasn't been changed (disposed before: " + disposedBefore + ", disposed after: " + disposedAfter + ")");
                }
            });
        } else {
            Disposer.dispose((Disposable)this.myWidgetParentDisposable);
        }
    }
}

