/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalCommandHistoryManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

@State(name="TerminalArrangementManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public class TerminalArrangementManager
implements PersistentStateComponent<TerminalArrangementState> {
    private final TerminalWorkingDirectoryManager myWorkingDirectoryManager;
    private final Project myProject;
    private ToolWindow myTerminalToolWindow;
    private TerminalArrangementState myState;

    public TerminalArrangementManager(@NotNull Project project) {
        this.myProject = project;
        this.myWorkingDirectoryManager = new TerminalWorkingDirectoryManager();
    }

    public void setToolWindow(@NotNull ToolWindow terminalToolWindow) {
        this.myTerminalToolWindow = terminalToolWindow;
        this.myWorkingDirectoryManager.init(terminalToolWindow);
    }

    @Nullable
    public TerminalArrangementState getState() {
        if (!TerminalArrangementManager.isAvailable() || this.myTerminalToolWindow == null) {
            return null;
        }
        TerminalArrangementState state = this.calcArrangementState(this.myTerminalToolWindow);
        TerminalCommandHistoryManager.getInstance().retainCommandHistoryFiles(TerminalArrangementManager.getCommandHistoryFileNames(state), this.myProject);
        return state;
    }

    public void loadState(@NotNull TerminalArrangementState state) {
        if (TerminalArrangementManager.isAvailable()) {
            this.myState = state;
        }
    }

    @NotNull
    private static List<String> getCommandHistoryFileNames(@NotNull TerminalArrangementState state) {
        return ContainerUtil.mapNotNull(state.myTabStates, tabState -> tabState.myCommandHistoryFileName);
    }

    @Nullable
    public TerminalArrangementState getArrangementState() {
        return this.myState;
    }

    @NotNull
    private TerminalArrangementState calcArrangementState(@NotNull ToolWindow terminalToolWindow) {
        TerminalArrangementState arrangementState = new TerminalArrangementState();
        ContentManager contentManager = terminalToolWindow.getContentManager();
        for (Content content : contentManager.getContents()) {
            JBTerminalWidget terminalWidget;
            AbstractTerminalRunner<?> runner = TerminalView.getRunnerByContent(content);
            if (runner == null || !runner.isTerminalSessionPersistent() || (terminalWidget = TerminalView.getWidgetByContent(content)) == null) continue;
            TerminalTabState tabState = new TerminalTabState();
            tabState.myTabName = content.getTabName();
            tabState.myIsUserDefinedTabTitle = tabState.myTabName.equals(terminalWidget.getTerminalTitle().getUserDefinedTitle());
            tabState.myWorkingDirectory = this.myWorkingDirectoryManager.getWorkingDirectory(content);
            tabState.myCommandHistoryFileName = TerminalCommandHistoryManager.getFilename(ShellTerminalWidget.getCommandHistoryFilePath(terminalWidget));
            arrangementState.myTabStates.add(tabState);
        }
        Content selectedContent = contentManager.getSelectedContent();
        arrangementState.mySelectedTabIndex = selectedContent == null ? -1 : contentManager.getIndexOfContent(selectedContent);
        return arrangementState;
    }

    public void assignCommandHistoryFile(@NotNull JBTerminalWidget terminalWidget, @Nullable TerminalTabState tabState) {
        if (TerminalArrangementManager.isAvailable() && terminalWidget instanceof ShellTerminalWidget) {
            Path historyFile = TerminalCommandHistoryManager.getInstance().getOrCreateCommandHistoryFile(tabState != null ? tabState.myCommandHistoryFileName : null, this.myProject);
            String historyFilePath = historyFile != null ? historyFile.toAbsolutePath().toString() : null;
            ((ShellTerminalWidget)terminalWidget).setCommandHistoryFilePath(historyFilePath);
        }
    }

    @NotNull
    public static TerminalArrangementManager getInstance(@NotNull Project project) {
        return (TerminalArrangementManager)project.getService(TerminalArrangementManager.class);
    }

    static boolean isAvailable() {
        return Registry.is((String)"terminal.persistent.tabs");
    }
}

