/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.jediterm.terminal.ProcessTtyConnector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalTabCloseListenerKt;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.TerminalView;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000eH\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalTabCloseListener;", "Lcom/intellij/execution/ui/BaseContentCloseListener;", "content", "Lcom/intellij/ui/content/Content;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/ui/content/Content;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getContent", "()Lcom/intellij/ui/content/Content;", "getProject", "()Lcom/intellij/openapi/project/Project;", "canClose", "", "closeQuery", "projectClosing", "disposeContent", "", "Companion", "intellij.terminal"})
public final class TerminalTabCloseListener
extends BaseContentCloseListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Content content;
    @NotNull
    private final Project project;

    public TerminalTabCloseListener(@NotNull Content content, @NotNull Project project, @NotNull Disposable parentDisposable) {
        super(content, project, parentDisposable);
        this.content = content;
        this.project = project;
    }

    @NotNull
    public final Content getContent() {
        return this.content;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    protected void disposeContent(@NotNull Content content) {
    }

    protected boolean closeQuery(@NotNull Content content, boolean projectClosing) {
        NopProcessHandler nopProcessHandler;
        if (projectClosing) {
            return true;
        }
        if (Intrinsics.areEqual((Object)content.getUserData(TerminalTabCloseListenerKt.access$getSILENT$p()), (Object)true)) {
            return true;
        }
        JBTerminalWidget widget = TerminalView.getWidgetByContent(content);
        if (widget == null || !widget.isSessionRunning()) {
            return true;
        }
        ProcessTtyConnector connector = ShellTerminalWidget.getProcessTtyConnector(widget.getTtyConnector());
        try {
            if (connector != null && !TerminalUtil.hasRunningCommands(connector)) {
                return true;
            }
        }
        catch (Exception e) {
            TerminalTabCloseListenerKt.access$getLOG$p().error((Throwable)e);
        }
        NopProcessHandler $this$closeQuery_u24lambda_u240 = nopProcessHandler = new NopProcessHandler();
        boolean bl = false;
        $this$closeQuery_u24lambda_u240.startNotify();
        NopProcessHandler proxy = nopProcessHandler;
        proxy.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)true);
        GeneralSettings.ProcessCloseConfirmation result = TerminateRemoteProcessDialog.show((Project)this.project, (String)("Terminal " + content.getDisplayName()), (ProcessHandler)((ProcessHandler)proxy));
        return result != null;
    }

    public boolean canClose(@NotNull Project project) {
        return project == this.project && this.closeQuery(this.content, true);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalTabCloseListener$Companion;", "", "()V", "executeContentOperationSilently", "", "content", "Lcom/intellij/ui/content/Content;", "runnable", "Lkotlin/Function0;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void executeContentOperationSilently(@NotNull Content content, @NotNull Function0<Unit> runnable) {
            content.putUserData(TerminalTabCloseListenerKt.access$getSILENT$p(), (Object)true);
            try {
                runnable.invoke();
            }
            finally {
                content.putUserData(TerminalTabCloseListenerKt.access$getSILENT$p(), null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

