/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalLineIntervalHighlighting;
import com.jediterm.terminal.model.TerminalModelListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalCommandHandlerCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsConfigurable;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

public final class TerminalShellCommandHandlerHelper {
    private static final Logger LOG = Logger.getInstance(TerminalShellCommandHandlerHelper.class);
    @NonNls
    private static final String FEATURE_ID = "terminal.shell.command.handling";
    private static final int TYPING_THRESHOLD_MS = 200;
    private static Experiments ourExperiments;
    private final ShellTerminalWidget myWidget;
    private final Alarm myAlarm;
    private volatile String myWorkingDirectory;
    private volatile Boolean myHasRunningCommands;
    private PropertiesComponent myPropertiesComponent;
    private final AtomicLong myLastKeyPressedMillis = new AtomicLong();
    private TerminalLineIntervalHighlighting myCommandHighlighting;
    private Disposable myNotificationDisposable;

    TerminalShellCommandHandlerHelper(@NotNull ShellTerminalWidget widget) {
        this.myWidget = widget;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)widget);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myWidget).subscribe(TerminalCommandHandlerCustomizer.Companion.getTERMINAL_COMMAND_HANDLER_TOPIC(), () -> this.scheduleCommandHighlighting());
        TerminalModelListener listener = () -> {
            if (System.currentTimeMillis() - this.myLastKeyPressedMillis.get() < 200L) {
                this.scheduleCommandHighlighting();
            }
        };
        widget.getTerminalTextBuffer().addModelListener(listener);
        Disposer.register((Disposable)this.myWidget, () -> widget.getTerminalTextBuffer().removeModelListener(listener));
    }

    public void processKeyPressed(KeyEvent e) {
        if (TerminalShellCommandHandlerHelper.isFeatureEnabled()) {
            this.myLastKeyPressedMillis.set(System.currentTimeMillis());
            if (e.getKeyCode() == 27 && e.getModifiersEx() == 0 && this.hideNotification()) {
                e.consume();
            }
        }
    }

    private void scheduleCommandHighlighting() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.highlightMatchedCommand(this.myWidget.getProject()), 0);
    }

    public static boolean isFeatureEnabled() {
        Experiments experiments = ourExperiments;
        if (experiments == null) {
            ourExperiments = experiments = (Experiments)ReadAction.compute(() -> ApplicationManager.getApplication().isDisposed() ? null : Experiments.getInstance());
        }
        return experiments != null && experiments.isFeatureEnabled(FEATURE_ID);
    }

    private void highlightMatchedCommand(@NotNull Project project) {
        if (!this.isEnabledForProject()) {
            this.setCommandHighlighting(null);
            return;
        }
        String command = this.myWidget.getTypedShellCommand().trim();
        TerminalLineIntervalHighlighting commandHighlighting = this.highlightCommandIfMatched(project, command);
        this.setCommandHighlighting(commandHighlighting);
        ApplicationManager.getApplication().invokeLater(() -> this.showOrHideNotification(commandHighlighting), ModalityState.stateForComponent((Component)this.myWidget.getTerminalPanel()));
    }

    private synchronized void setCommandHighlighting(@Nullable TerminalLineIntervalHighlighting commandHighlighting) {
        TerminalLineIntervalHighlighting oldHighlighting = this.myCommandHighlighting;
        if (oldHighlighting != null) {
            oldHighlighting.dispose();
            this.myWidget.getTerminalPanel().repaint();
        }
        this.myCommandHighlighting = commandHighlighting;
    }

    private boolean hideNotification() {
        boolean shown;
        boolean bl = shown = this.myNotificationDisposable != null && !Disposer.isDisposed((Disposable)this.myNotificationDisposable);
        if (shown) {
            Disposer.dispose((Disposable)this.myNotificationDisposable);
        }
        this.myNotificationDisposable = null;
        return shown;
    }

    private void showOrHideNotification(@Nullable TerminalLineIntervalHighlighting commandHighlighting) {
        if (commandHighlighting == null || commandHighlighting.isDisposed()) {
            this.hideNotification();
            return;
        }
        if (this.myNotificationDisposable != null && !Disposer.isDisposed((Disposable)this.myNotificationDisposable)) {
            return;
        }
        Disposable notificationDisposable = Disposer.newDisposable((Disposable)this.myWidget.getTerminalPanel(), (String)"terminal.smart_command_execution");
        String content = TerminalBundle.message("smart_command_execution.notification.text", KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getRunAction()), KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getDebugAction()));
        GotItTooltip tooltip = new GotItTooltip("terminal.smart_command_execution", content, notificationDisposable).withHeader(TerminalBundle.message("smart_command_execution.notification.title", new Object[0])).withLink(TerminalBundle.message("smart_command_execution.notification.configure_link.text", new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(this.myWidget.getProject(), TerminalOptionsConfigurable.class)).withPosition(Balloon.Position.below);
        if (!tooltip.canShow()) {
            Disposer.dispose((Disposable)notificationDisposable);
            return;
        }
        tooltip.show((JComponent)this.myWidget.getTerminalPanel(), (component, balloon) -> {
            Rectangle bounds = this.myWidget.processTerminalBuffer(buffer -> this.myWidget.getTerminalPanel().getBounds(commandHighlighting));
            if (bounds != null) {
                int shiftY = 0;
                if (balloon instanceof BalloonImpl && BalloonImpl.getAbstractPositionFor((Balloon.Position)Balloon.Position.below) == ((BalloonImpl)balloon).getPosition()) {
                    shiftY = bounds.height;
                }
                return new Point(bounds.x + bounds.width / 2, bounds.y + shiftY);
            }
            Disposer.dispose((Disposable)notificationDisposable);
            return new Point(0, 0);
        });
        this.myNotificationDisposable = notificationDisposable;
    }

    private boolean isEnabledForProject() {
        return this.getPropertiesComponent().getBoolean("terminalCustomCommandExecutionTurnOff", true);
    }

    @NotNull
    private PropertiesComponent getPropertiesComponent() {
        PropertiesComponent propertiesComponent = this.myPropertiesComponent;
        if (propertiesComponent == null) {
            this.myPropertiesComponent = propertiesComponent = (PropertiesComponent)ReadAction.compute(() -> PropertiesComponent.getInstance());
        }
        return propertiesComponent;
    }

    @Nullable
    private String getWorkingDirectory() {
        String workingDirectory = this.myWorkingDirectory;
        if (workingDirectory == null) {
            this.myWorkingDirectory = workingDirectory = StringUtil.notNullize((String)TerminalWorkingDirectoryManager.getWorkingDirectory(this.myWidget, null));
        }
        return StringUtil.nullize((String)workingDirectory);
    }

    private boolean hasRunningCommands() {
        Boolean hasRunningCommands = this.myHasRunningCommands;
        if (hasRunningCommands == null) {
            this.myHasRunningCommands = hasRunningCommands = Boolean.valueOf(this.myWidget.hasRunningCommands());
        }
        return hasRunningCommands;
    }

    @Nullable
    private TerminalLineIntervalHighlighting highlightCommandIfMatched(@NotNull Project project, @NotNull String command) {
        if (command.isEmpty()) {
            return null;
        }
        if (!TerminalShellCommandHandler.Companion.matches(project, this.getWorkingDirectory(), !this.hasRunningCommands(), command)) {
            return null;
        }
        return this.myWidget.processTerminalBuffer(textBuffer -> {
            int cursorLine = this.myWidget.getLineNumberAtCursor();
            if (cursorLine < 0 || cursorLine >= textBuffer.getHeight()) {
                return null;
            }
            String lineText = textBuffer.getLine(cursorLine).getText();
            int commandStartInd = lineText.lastIndexOf(command);
            if (commandStartInd < 0) {
                return null;
            }
            TextStyle textStyle = TerminalShellCommandHandlerHelper.getSmartCommandExecutionStyle();
            if (textStyle == null) {
                return null;
            }
            return this.myWidget.highlightLineInterval(cursorLine, commandStartInd, command.length(), textStyle);
        });
    }

    @Nullable
    private static TextStyle getSmartCommandExecutionStyle() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(JBTerminalSystemSettingsProviderBase.COMMAND_TO_RUN_USING_IDE_KEY);
        if (attributes == null) {
            return null;
        }
        return new TextStyle(TerminalColor.awt((Color)attributes.getForegroundColor()), TerminalColor.awt((Color)attributes.getBackgroundColor()));
    }

    public boolean processEnterKeyPressed(@NotNull KeyEvent keyPressed) {
        boolean localSession;
        boolean hasRunningCommands;
        if (!TerminalShellCommandHandlerHelper.isFeatureEnabled() || !this.isEnabledForProject()) {
            this.onShellCommandExecuted();
            return false;
        }
        this.myLastKeyPressedMillis.set(System.currentTimeMillis());
        String command = this.myWidget.getTypedShellCommand().trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug("typed shell command to execute: " + command);
        }
        this.myAlarm.cancelAllRequests();
        Project project = this.myWidget.getProject();
        String workingDirectory = this.getWorkingDirectory();
        Executor executor = TerminalShellCommandHandlerHelper.matchedExecutor(keyPressed);
        if (executor != null) {
            hasRunningCommands = this.hasRunningCommands();
        } else {
            Boolean hasRunningCommandsLocal = this.myHasRunningCommands;
            if (hasRunningCommandsLocal == null) {
                this.onShellCommandExecuted();
                return false;
            }
            hasRunningCommands = hasRunningCommandsLocal;
        }
        boolean bl = localSession = !hasRunningCommands;
        if (!TerminalShellCommandHandler.Companion.matches(project, workingDirectory, localSession, command)) {
            this.onShellCommandExecuted();
            return false;
        }
        TerminalShellCommandHandler handler = TerminalShellCommandHandler.Companion.getEP().getExtensionList().stream().filter(it -> it.matches(project, workingDirectory, localSession, command)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find matching command handler."));
        if (executor == null) {
            this.onShellCommandExecuted();
            TerminalUsageTriggerCollector.Companion.triggerSmartCommand(project, workingDirectory, localSession, command, handler, false);
            return false;
        }
        TerminalUsageTriggerCollector.Companion.triggerSmartCommand(project, workingDirectory, localSession, command, handler, true);
        TerminalShellCommandHandler.Companion.executeShellCommandHandler(this.myWidget.getProject(), this.getWorkingDirectory(), !this.hasRunningCommands(), command, executor);
        this.clearTypedCommand(command);
        return true;
    }

    private void onShellCommandExecuted() {
        this.myWorkingDirectory = null;
        this.myHasRunningCommands = null;
    }

    private void clearTypedCommand(@NotNull String command) {
        TtyConnector connector = this.myWidget.getTtyConnector();
        byte[] array = new byte[command.length()];
        Arrays.fill(array, (byte)8);
        try {
            connector.write(array);
        }
        catch (IOException e) {
            LOG.info("Cannot clear shell command " + command, (Throwable)e);
        }
    }

    @Nullable
    static Executor matchedExecutor(@NotNull KeyEvent e) {
        if (TerminalShellCommandHandlerHelper.matchAction(e, TerminalShellCommandHandlerHelper.getRunAction())) {
            return DefaultRunExecutor.getRunExecutorInstance();
        }
        if (TerminalShellCommandHandlerHelper.matchAction(e, TerminalShellCommandHandlerHelper.getDebugAction())) {
            return ExecutorRegistry.getInstance().getExecutorById("Debug");
        }
        return null;
    }

    private static boolean matchAction(@NotNull KeyEvent e, @NotNull AnAction action) {
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        return ContainerUtil.exists((Object[])action.getShortcutSet().getShortcuts(), sc -> sc.isKeyboard() && sc.startsWith((Shortcut)eventShortcut));
    }

    @NotNull
    private static AnAction getRunAction() {
        return Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Run"));
    }

    @NotNull
    private static AnAction getDebugAction() {
        return Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Debug"));
    }
}

