/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalSettingsPanel;

public final class TerminalOptionsConfigurable
implements SearchableConfigurable,
Disposable {
    private static final String TERMINAL_SETTINGS_HELP_REFERENCE = "reference.settings.terminal";
    private TerminalSettingsPanel myPanel;
    private final Project myProject;
    private final TerminalOptionsProvider myOptionsProvider;
    private final TerminalProjectOptionsProvider myProjectOptionsProvider;

    public TerminalOptionsConfigurable(@NotNull Project project) {
        this.myProject = project;
        this.myOptionsProvider = TerminalOptionsProvider.getInstance();
        this.myProjectOptionsProvider = TerminalProjectOptionsProvider.getInstance(project);
    }

    @NotNull
    public String getId() {
        return "terminal";
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.TerminalOptionsConfigurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return TERMINAL_SETTINGS_HELP_REFERENCE;
    }

    public JComponent createComponent() {
        this.myPanel = new TerminalSettingsPanel();
        return this.myPanel.createPanel(this.myProject, this.myOptionsProvider, this.myProjectOptionsProvider);
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        this.myPanel = null;
    }
}

