/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalSplitAction;
import com.intellij.terminal.actions.TerminalActionUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalLineIntervalHighlighting;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ProxyTtyConnector;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalShellCommandHandlerHelper;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.TerminalView;

public class ShellTerminalWidget
extends JBTerminalWidget {
    private static final Logger LOG = Logger.getInstance(ShellTerminalWidget.class);
    private static final long VFS_REFRESH_DELAY_MS = 500L;
    private boolean myEscapePressed = false;
    private String myCommandHistoryFilePath;
    private final Prompt myPrompt = new Prompt();
    private final Queue<String> myPendingCommandsToExecute = new LinkedList<String>();
    private final Queue<Consumer<TtyConnector>> myPendingActionsToExecute = new LinkedList<Consumer<TtyConnector>>();
    private final TerminalShellCommandHandlerHelper myShellCommandHandlerHelper = new TerminalShellCommandHandlerHelper(this);
    private final Alarm myVfsRefreshAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private final TerminalModelListener myVfsRefreshModelListener = () -> {
        this.myVfsRefreshAlarm.cancelAllRequests();
        this.myVfsRefreshAlarm.addRequest(this::refreshVfsIfPromptIsShown, 500L);
    };
    private volatile String myPrevPromptWhenCommandStarted;

    public ShellTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull Disposable parent) {
        super(project, settingsProvider, parent);
        this.getTerminalPanel().addPreKeyEventHandler(e -> {
            String prompt;
            if (e.getID() != 401) {
                return;
            }
            if (e.getKeyCode() == 27) {
                this.myEscapePressed = true;
            }
            this.handleAnyKeyPressed();
            if (!(e.isConsumed() || e.getKeyCode() != 10 || (prompt = this.myPrompt.myPrompt).isEmpty() || this.getTypedShellCommand().isEmpty())) {
                this.myVfsRefreshAlarm.cancelAllRequests();
                this.getTerminalTextBuffer().removeModelListener(this.myVfsRefreshModelListener);
                this.myPrevPromptWhenCommandStarted = prompt;
                if (!this.getTerminalTextBuffer().isUsingAlternateBuffer()) {
                    this.getTerminalTextBuffer().addModelListener(this.myVfsRefreshModelListener);
                }
            }
            if (e.getKeyCode() == 10 || TerminalShellCommandHandlerHelper.matchedExecutor(e) != null) {
                TerminalUsageTriggerCollector.Companion.triggerCommandExecuted(project);
                if (this.myShellCommandHandlerHelper.processEnterKeyPressed((KeyEvent)e)) {
                    e.consume();
                }
                if (!e.isConsumed()) {
                    this.handleEnterPressed();
                    this.myEscapePressed = false;
                }
            } else {
                this.myShellCommandHandlerHelper.processKeyPressed((KeyEvent)e);
            }
        });
        Disposer.register((Disposable)this, () -> this.getTerminalTextBuffer().removeModelListener(this.myVfsRefreshModelListener));
    }

    private void refreshVfsIfPromptIsShown() {
        String promptWhenCommandStarted = this.myPrevPromptWhenCommandStarted;
        if (promptWhenCommandStarted != null) {
            this.processTerminalBuffer(terminalTextBuffer -> {
                TerminalLine line = this.myPrompt.getLineAtCursor((TerminalTextBuffer)terminalTextBuffer);
                String lineStr = line.getText();
                if (lineStr.startsWith(promptWhenCommandStarted)) {
                    SaveAndSyncHandler.getInstance().scheduleRefresh();
                    this.myPrevPromptWhenCommandStarted = null;
                    this.myVfsRefreshAlarm.cancelAllRequests();
                    this.getTerminalTextBuffer().removeModelListener(this.myVfsRefreshModelListener);
                }
                return null;
            });
        }
    }

    public void handleEnterPressed() {
        this.myPrompt.reset();
    }

    public void handleAnyKeyPressed() {
        this.myPrompt.onKeyPressed();
    }

    public void setCommandHistoryFilePath(@Nullable String commandHistoryFilePath) {
        this.myCommandHistoryFilePath = commandHistoryFilePath;
    }

    @Nullable
    public static String getCommandHistoryFilePath(@Nullable JBTerminalWidget terminalWidget) {
        return terminalWidget instanceof ShellTerminalWidget ? ((ShellTerminalWidget)terminalWidget).myCommandHistoryFilePath : null;
    }

    @NotNull
    public String getTypedShellCommand() {
        return this.myPrompt.getTypedShellCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T processTerminalBuffer(@NotNull Function<TerminalTextBuffer, T> processor) {
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        textBuffer.lock();
        try {
            T t = processor.apply(textBuffer);
            return t;
        }
        finally {
            textBuffer.unlock();
        }
    }

    int getLineNumberAtCursor() {
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        Terminal terminal = this.getTerminal();
        return Math.max(0, Math.min(terminal.getCursorY() - 1, textBuffer.getHeight() - 1));
    }

    public void executeCommand(@NotNull String shellCommand) throws IOException {
        String typedCommand = this.getTypedShellCommand();
        if (!typedCommand.isEmpty()) {
            throw new IOException("Cannot execute command when another command is typed: " + typedCommand);
        }
        TtyConnector connector = this.getTtyConnector();
        if (connector != null) {
            this.doExecuteCommand(shellCommand, connector);
        } else {
            this.myPendingCommandsToExecute.add(shellCommand);
        }
    }

    public void executeWithTtyConnector(@NotNull Consumer<TtyConnector> consumer) {
        TtyConnector connector = this.getTtyConnector();
        if (connector != null) {
            consumer.consume((Object)connector);
        } else {
            this.myPendingActionsToExecute.add(consumer);
        }
    }

    @Nls
    @Nullable
    public String getDefaultSessionName() {
        ProcessTtyConnector connector = this.getProcessTtyConnector();
        if (connector instanceof PtyProcessTtyConnector) {
            return TerminalOptionsProvider.getInstance().getTabName();
        }
        return super.getDefaultSessionName();
    }

    public void setTtyConnector(@NotNull TtyConnector ttyConnector) {
        Consumer<TtyConnector> consumer;
        String command;
        super.setTtyConnector(ttyConnector);
        while ((command = this.myPendingCommandsToExecute.poll()) != null) {
            try {
                this.doExecuteCommand(command, ttyConnector);
            }
            catch (IOException e) {
                LOG.warn("Cannot execute " + command, (Throwable)e);
            }
        }
        while ((consumer = this.myPendingActionsToExecute.poll()) != null) {
            consumer.consume((Object)ttyConnector);
        }
    }

    private void doExecuteCommand(@NotNull String shellCommand, @NotNull TtyConnector connector) throws IOException {
        StringBuilder result = new StringBuilder();
        if (this.myEscapePressed) {
            result.append('\b');
        }
        String enterCode = new String(this.getTerminalStarter().getCode(10, 0), StandardCharsets.UTF_8);
        result.append(shellCommand).append(enterCode);
        connector.write(result.toString());
    }

    public boolean hasRunningCommands() throws IllegalStateException {
        TtyConnector connector = this.getTtyConnector();
        if (connector == null) {
            return false;
        }
        ProcessTtyConnector processTtyConnector = ShellTerminalWidget.getProcessTtyConnector(connector);
        if (processTtyConnector != null) {
            return TerminalUtil.hasRunningCommands(processTtyConnector);
        }
        throw new IllegalStateException("Cannot determine if there are running processes for " + connector.getClass());
    }

    public List<TerminalAction> getActions() {
        ArrayList<TerminalAction> actions = new ArrayList<TerminalAction>(super.getActions());
        if (TerminalView.isInTerminalToolWindow(this)) {
            ContainerUtil.addIfNotNull(actions, (Object)TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (String)"Terminal.RenameSession", (boolean)true));
        }
        JBTerminalWidgetListener listener = this.getListener();
        JBTerminalSystemSettingsProviderBase settingsProvider = this.getSettingsProvider();
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getNewSessionActionPresentation(), l -> {
            l.onNewSession();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getCloseSessionActionPresentation(), l -> {
            l.onSessionClosed();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalSplitAction.create((boolean)true, (JBTerminalWidgetListener)this.getListener()).withMnemonicKey(Integer.valueOf(86)).separatorBefore(true));
        actions.add(TerminalSplitAction.create((boolean)false, (JBTerminalWidgetListener)this.getListener()).withMnemonicKey(Integer.valueOf(72)));
        if (listener != null && listener.isGotoNextSplitTerminalAvailable()) {
            actions.add(settingsProvider.getGotoNextSplitTerminalAction(listener, true));
            actions.add(settingsProvider.getGotoNextSplitTerminalAction(listener, false));
        }
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getPreviousTabActionPresentation(), l -> {
            l.onPreviousTabSelected();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getNextTabActionPresentation(), l -> {
            l.onNextTabSelected();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getMoveTabRightActionPresentation(), l -> {
            l.moveTabRight();
            return true;
        }).withMnemonicKey(Integer.valueOf(82)).withEnabledSupplier(() -> listener != null && listener.canMoveTabRight()));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getMoveTabLeftActionPresentation(), l -> {
            l.moveTabLeft();
            return true;
        }).withMnemonicKey(Integer.valueOf(76)).withEnabledSupplier(() -> listener != null && listener.canMoveTabLeft()));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getShowTabsActionPresentation(), l -> {
            l.showTabs();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        return actions;
    }

    @Nullable
    public TerminalLineIntervalHighlighting highlightLineInterval(int lineNumber, int intervalStartOffset, int intervalLength, @NotNull TextStyle style) {
        TerminalLine line = this.getTerminalTextBuffer().getLine(lineNumber);
        if (line == null) {
            LOG.error("No line found");
            return null;
        }
        TerminalLineIntervalHighlighting highlighting = line.addCustomHighlighting(intervalStartOffset, intervalLength, style);
        this.getTerminalPanel().repaint();
        return highlighting;
    }

    @Nullable
    public ProcessTtyConnector getProcessTtyConnector() {
        return ShellTerminalWidget.getProcessTtyConnector(this.getTtyConnector());
    }

    @Nullable
    public static ProcessTtyConnector getProcessTtyConnector(@Nullable TtyConnector connector) {
        if (connector instanceof ProcessTtyConnector) {
            return (ProcessTtyConnector)connector;
        }
        if (connector instanceof ProxyTtyConnector) {
            return ShellTerminalWidget.getProcessTtyConnector(((ProxyTtyConnector)connector).getConnector());
        }
        return null;
    }

    private final class Prompt {
        @NotNull
        private volatile String myPrompt = "";
        private final AtomicInteger myTypings = new AtomicInteger(0);
        private TerminalLine myTerminalLine;
        private int myMaxCursorX = -1;

        private Prompt() {
        }

        private void reset() {
            this.myTypings.set(0);
            this.myTerminalLine = null;
            this.myMaxCursorX = -1;
        }

        private void onKeyPressed() {
            TerminalLine terminalLine = ShellTerminalWidget.this.processTerminalBuffer(this::getLineAtCursor);
            if (terminalLine != this.myTerminalLine) {
                this.myTypings.set(0);
                this.myTerminalLine = terminalLine;
                this.myMaxCursorX = -1;
            }
            String prompt = this.getLineTextUpToCursor(terminalLine);
            if (this.myTypings.get() == 0) {
                this.myPrompt = prompt;
                this.myTerminalLine = terminalLine;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Guessed shell prompt: " + this.myPrompt);
                }
            } else if (prompt.startsWith(this.myPrompt)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Guessed prompt confirmed by typing# " + (this.myTypings.get() + 1));
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prompt rejected by typing#" + (this.myTypings.get() + 1) + ", new prompt: " + prompt);
                }
                this.myPrompt = prompt;
                this.myTypings.set(1);
            }
            this.myTypings.incrementAndGet();
        }

        @NotNull
        private String getTypedShellCommand() {
            if (this.myTypings.get() == 0) {
                return "";
            }
            TerminalLine terminalLine = ShellTerminalWidget.this.processTerminalBuffer(this::getLineAtCursor);
            if (terminalLine != this.myTerminalLine) {
                return "";
            }
            String lineTextUpToCursor = this.getLineTextUpToCursor(terminalLine);
            if (lineTextUpToCursor.startsWith(this.myPrompt)) {
                return lineTextUpToCursor.substring(this.myPrompt.length());
            }
            return "";
        }

        @NotNull
        private TerminalLine getLineAtCursor(@NotNull TerminalTextBuffer textBuffer) {
            return textBuffer.getLine(ShellTerminalWidget.this.getLineNumberAtCursor());
        }

        @NotNull
        private String getLineTextUpToCursor(@Nullable TerminalLine line) {
            if (line == null) {
                return "";
            }
            return ShellTerminalWidget.this.processTerminalBuffer(textBuffer -> {
                int maxCursorX;
                int cursorX = ShellTerminalWidget.this.getTerminal().getCursorX() - 1;
                String lineStr = line.getText();
                for (maxCursorX = Math.max(this.myMaxCursorX, cursorX); maxCursorX < lineStr.length() && !Character.isWhitespace(lineStr.charAt(maxCursorX)); ++maxCursorX) {
                }
                this.myMaxCursorX = maxCursorX;
                return lineStr.substring(0, Math.min(maxCursorX, lineStr.length()));
            });
        }
    }
}

