/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalTypeAheadSettings;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

public class JBTerminalSystemSettingsProvider
extends JBTerminalSystemSettingsProviderBase {
    public boolean shouldCloseTabOnLogout(TtyConnector ttyConnector) {
        return TerminalOptionsProvider.getInstance().getCloseSessionOnLogout();
    }

    public boolean audibleBell() {
        return TerminalOptionsProvider.getInstance().getAudibleBell();
    }

    public boolean enableMouseReporting() {
        return TerminalOptionsProvider.getInstance().getMouseReporting();
    }

    public boolean copyOnSelect() {
        return TerminalOptionsProvider.getInstance().getCopyOnSelection();
    }

    public boolean pasteOnMiddleMouseClick() {
        return TerminalOptionsProvider.getInstance().getPasteOnMiddleMouseButton();
    }

    public boolean forceActionOnMouseReporting() {
        return true;
    }

    public boolean overrideIdeShortcuts() {
        return TerminalOptionsProvider.getInstance().getOverrideIdeShortcuts();
    }

    public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode() {
        return TerminalOptionsProvider.getInstance().getHighlightHyperlinks() ? HyperlinkStyle.HighlightMode.ALWAYS : HyperlinkStyle.HighlightMode.HOVER;
    }

    public boolean altSendsEscape() {
        return !SystemInfo.isMac || TerminalOptionsProvider.getInstance().getUseOptionAsMetaKey();
    }

    @NotNull
    public TerminalTypeAheadSettings getTypeAheadSettings() {
        return new TerminalTypeAheadSettings(AdvancedSettings.getBoolean((String)"terminal.type.ahead"), TimeUnit.MILLISECONDS.toNanos(AdvancedSettings.getInt((String)"terminal.type.ahead.latency.threshold")), TerminalTypeAheadSettings.DEFAULT.getTypeAheadStyle());
    }
}

