/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profiler;

import com.android.tools.profiler.asm.ClassVisitor;
import com.android.tools.profiler.asm.MethodVisitor;
import com.android.tools.profiler.asm.Opcodes;

final class OkHttpAdapter
extends ClassVisitor
implements Opcodes {
    private static final String OKHTTP2_CLIENT_CLASS = "com/squareup/okhttp/OkHttpClient";
    private static final String OKHTTP2_WRAPPER = "com/android/tools/profiler/support/network/okhttp/OkHttp2Wrapper";
    private static final String OKHTTP3_BUILDER_CLASS = "okhttp3/OkHttpClient$Builder";
    private static final String OKHTTP3_WRAPPER = "com/android/tools/profiler/support/network/okhttp/OkHttp3Wrapper";

    OkHttpAdapter(ClassVisitor classVisitor) {
        super(458752, classVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return mv != null ? new MethodAdapter(mv) : null;
    }

    private static final class MethodAdapter
    extends MethodVisitor
    implements Opcodes {
        public MethodAdapter(MethodVisitor mv) {
            super(458752, mv);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (owner.equals(OkHttpAdapter.OKHTTP3_BUILDER_CLASS) && MethodAdapter.isConstructor(opcode, name, desc) && !itf) {
                super.visitInsn(89);
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                this.invoke(OkHttpAdapter.OKHTTP3_WRAPPER, "addInterceptorToBuilder", "(Ljava/lang/Object;)V");
            } else if (owner.equals(OkHttpAdapter.OKHTTP2_CLIENT_CLASS) && MethodAdapter.isConstructor(opcode, name, desc) && !itf) {
                super.visitInsn(89);
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                this.invoke(OkHttpAdapter.OKHTTP2_WRAPPER, "addInterceptorToClient", "(Ljava/lang/Object;)V");
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        private static boolean isConstructor(int opcode, String name, String desc) {
            return opcode == 183 && name.equals("<init>") && desc.equals("()V");
        }

        private void invoke(String wrapper, String method, String desc) {
            super.visitMethodInsn(184, wrapper, method, desc, false);
        }
    }
}

