/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter;

import java.io.Serializable;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Supplier;

@ApiStatus.Internal
public final class Suppliers {
    public static <T> Supplier<T> of(T instance) {
        return new SupplierOfInstance(instance);
    }

    public static <T> Supplier<T> wrap(@NotNull Supplier<? extends T> supplier) {
        try {
            return Suppliers.of(supplier.get());
        }
        catch (UnsupportedMethodException methodException) {
            return new UnsupportedMethodExceptionSupplier(methodException);
        }
    }

    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        private final T instance;

        private SupplierOfInstance(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public boolean equals(Object obj) {
            return obj instanceof SupplierOfInstance && this.instance.equals(((SupplierOfInstance)obj).instance);
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        public String toString() {
            return "Suppliers.ofInstance(" + this.instance + ")";
        }
    }

    private static class UnsupportedMethodExceptionSupplier<T>
    implements Supplier<T>,
    Serializable {
        private final UnsupportedMethodException myException;

        private UnsupportedMethodExceptionSupplier(UnsupportedMethodException exception) {
            this.myException = new UnsupportedMethodException(exception.getMessage());
        }

        @Override
        public T get() {
            throw this.myException;
        }
    }
}

