/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ServiceLoader;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.DefaultSerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationServiceNotFoundException;
import org.jetbrains.plugins.gradle.tooling.util.ClassMap;

public final class ToolingSerializer {
    private final DefaultSerializationService myDefaultSerializationService;
    private final ClassMap<SerializationService<?>> mySerializationServices;
    @Nullable
    private final ClassLoader myModelBuildersClassLoader;

    public ToolingSerializer() {
        this(null);
    }

    public ToolingSerializer(@Nullable ClassLoader modelBuildersClassLoader) {
        this.myModelBuildersClassLoader = modelBuildersClassLoader;
        this.myDefaultSerializationService = new DefaultSerializationService();
        this.mySerializationServices = new ClassMap();
        ClassLoader clientOwnedDaemonPayloadLoader = this.getClass().getClassLoader();
        if (modelBuildersClassLoader != null) {
            try {
                Class<?> serializationServiceClass = modelBuildersClassLoader.loadClass(SerializationService.class.getName());
                for (final Object serializationService : ServiceLoader.load(serializationServiceClass, modelBuildersClassLoader)) {
                    SerializationService proxyService = (SerializationService)Proxy.newProxyInstance(SerializationService.class.getClassLoader(), new Class[]{SerializationService.class}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Method m = serializationService.getClass().getMethod(method.getName(), method.getParameterTypes());
                            return m.invoke(serializationService, args);
                        }
                    });
                    try {
                        this.register(proxyService);
                    }
                    catch (Throwable throwable) {}
                }
                ToolingSerializer.addModelBuildersClassLoaderUrlsToTapiClientClassloader(modelBuildersClassLoader, clientOwnedDaemonPayloadLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (SerializationService serializerService : ServiceLoader.load(SerializationService.class, clientOwnedDaemonPayloadLoader)) {
            this.register(serializerService);
        }
    }

    public byte[] write(@NotNull Object object) throws IOException, SerializationServiceNotFoundException {
        Object unpackedObject;
        Class<?> unpackedObjectClass;
        if (this.myModelBuildersClassLoader != null && this.myModelBuildersClassLoader == (unpackedObjectClass = (unpackedObject = ToolingSerializer.maybeUnpack(object)).getClass()).getClassLoader()) {
            return this.getService(unpackedObjectClass, true).write(unpackedObject, unpackedObjectClass);
        }
        Class<?> modelClazz = object.getClass();
        return this.getService(modelClazz, false).write(object, modelClazz);
    }

    @Nullable
    public <T> T read(@NotNull byte[] object, @NotNull Class<T> modelClazz) throws IOException, SerializationServiceNotFoundException {
        assert (this.myModelBuildersClassLoader == null);
        return this.getService(modelClazz, true).read(object, modelClazz);
    }

    @NotNull
    private <T> SerializationService<T> getService(@NotNull Class<T> modelClazz, boolean useDefaultSerializer) throws SerializationServiceNotFoundException {
        SerializationService<?> service = this.mySerializationServices.get(modelClazz);
        if (service != null) {
            return service;
        }
        if (useDefaultSerializer) {
            return this.myDefaultSerializationService;
        }
        throw new SerializationServiceNotFoundException(modelClazz);
    }

    @NotNull
    private static Object maybeUnpack(@NotNull Object object) {
        try {
            return new ProtocolToModelAdapter().unpack(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return object;
        }
    }

    private void register(@NotNull SerializationService<?> serializerService) {
        this.mySerializationServices.put(serializerService.getModelClass(), serializerService);
    }

    private static void addModelBuildersClassLoaderUrlsToTapiClientClassloader(@NotNull ClassLoader modelBuildersClassLoader, @NotNull ClassLoader clientOwnedDaemonPayloadLoader) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method addURLMethod = ToolingSerializer.findMethodIncludingSuperclasses(clientOwnedDaemonPayloadLoader.getClass(), "addURL", URL.class);
        if (addURLMethod != null) {
            URL[] modelBuildersClassLoaderUrls;
            addURLMethod.setAccessible(true);
            for (URL url : modelBuildersClassLoaderUrls = (URL[])modelBuildersClassLoader.getClass().getMethod("getURLs", new Class[0]).invoke((Object)modelBuildersClassLoader, new Object[0])) {
                addURLMethod.invoke((Object)clientOwnedDaemonPayloadLoader, url);
            }
        }
    }

    @Nullable
    private static Method findMethodIncludingSuperclasses(Class<?> clazz, String name, Class<?> ... parameterType) {
        try {
            return clazz.getDeclaredMethod(name, parameterType);
        }
        catch (NoSuchMethodException var5) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                return ToolingSerializer.findMethodIncludingSuperclasses(superclass, name, parameterType);
            }
            return null;
        }
    }
}

