/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class Message {
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myText;
    @Nullable
    private final String myGroup;
    @NotNull
    private final Kind myKind;
    @Nullable
    FilePosition myFilePosition;

    public Message(@NotNull String title, @NotNull String text, @Nullable String group, @NotNull Kind kind, @Nullable FilePosition filePosition) {
        this.myTitle = title;
        this.myText = text;
        this.myGroup = group;
        this.myKind = kind;
        this.myFilePosition = filePosition;
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    @NotNull
    public Kind getKind() {
        return this.myKind;
    }

    @Nullable
    public FilePosition getFilePosition() {
        return this.myFilePosition;
    }

    public static enum Kind {
        ERROR,
        WARNING,
        INFO;

    }

    public static class FilePosition {
        @NotNull
        private final String myFilePath;
        private final int myLine;
        private final int myColumn;

        public FilePosition(@NotNull String filePath, int line, int column) {
            this.myFilePath = filePath;
            this.myLine = line;
            this.myColumn = column;
        }

        @NotNull
        public String getFilePath() {
            return this.myFilePath;
        }

        public int getLine() {
            return this.myLine;
        }

        public int getColumn() {
            return this.myColumn;
        }
    }
}

