/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.coverage;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.listeners.java.CoverageListener;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaTargetDependentParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.coverage.CoverageConfigurable;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.CoverageFragment;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageJavaRunConfigurationExtension
extends RunConfigurationExtension {
    private JavaTargetDependentParameters myTargetDependentParameters;

    public void attachToProcess(final @NotNull RunConfigurationBase configuration, final @NotNull ProcessHandler handler, final RunnerSettings runnerSettings) {
        if (this.myTargetDependentParameters == null || this.myTargetDependentParameters.getTargetEnvironment() == null) {
            CoverageDataManager.getInstance((Project)configuration.getProject()).attachToProcess(handler, configuration, runnerSettings);
            return;
        }
        if (runnerSettings instanceof CoverageRunnerData) {
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    new Task.Backgroundable(configuration.getProject(), JavaCoverageBundle.message("download.coverage.report.from.target.progress.title", new Object[0])){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(@NotNull ProgressIndicator indicator) {
                            JavaCoverageEnabledConfiguration coverageConfiguration = (JavaCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)configuration);
                            try {
                                coverageConfiguration.downloadReport(CoverageJavaRunConfigurationExtension.this.myTargetDependentParameters.getTargetEnvironment(), indicator);
                            }
                            catch (Exception ignored) {
                                Notifications.Bus.notify((Notification)new Notification("Coverage", CoverageBundle.message((String)"coverage.error.collecting.data", (Object[])new Object[0]), JavaCoverageBundle.message("download.coverage.report.from.target.failed", new Object[0]), NotificationType.ERROR));
                                return;
                            }
                            finally {
                                CoverageJavaRunConfigurationExtension.this.myTargetDependentParameters = null;
                            }
                            CoverageDataManager.getInstance((Project)configuration.getProject()).processGatheredCoverage(configuration, runnerSettings);
                        }
                    }.queue();
                    handler.removeProcessListener((ProcessListener)this);
                }
            });
        }
    }

    @Nullable
    public SettingsEditor createEditor(@NotNull RunConfigurationBase configuration) {
        return new CoverageConfigurable(configuration);
    }

    protected <P extends RunConfigurationBase<?>> List<SettingsEditor<P>> createFragments(@NotNull P configuration) {
        return Collections.singletonList(new CoverageFragment(configuration));
    }

    public String getEditorTitle() {
        return CoverageEngine.getEditorTitle();
    }

    @NotNull
    public String getSerializationId() {
        return "coverage";
    }

    public void updateJavaParameters(@NotNull RunConfigurationBase configuration, @NotNull JavaParameters params, RunnerSettings runnerSettings) {
        if (!this.isApplicableFor(configuration)) {
            return;
        }
        JavaCoverageEnabledConfiguration coverageConfig = JavaCoverageEnabledConfiguration.getFrom(configuration);
        coverageConfig.setCurrentCoverageSuite(null);
        CoverageRunner coverageRunner = coverageConfig.getCoverageRunner();
        if (runnerSettings instanceof CoverageRunnerData && coverageRunner != null) {
            Project project = configuration.getProject();
            CoverageDataManager coverageDataManager = CoverageDataManager.getInstance((Project)project);
            ApplicationManager.getApplication().invokeLater(() -> coverageConfig.setCurrentCoverageSuite(coverageDataManager.addCoverageSuite((CoverageEnabledConfiguration)coverageConfig)), ModalityState.NON_MODAL, project.getDisposed());
            this.appendCoverageArgument(configuration, params, coverageConfig);
            Sdk jdk = params.getJdk();
            if (jdk != null && JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_7) && coverageRunner instanceof JavaCoverageRunner && !((JavaCoverageRunner)coverageRunner).isJdk7Compatible()) {
                Notifications.Bus.notify((Notification)new Notification("Coverage", JavaCoverageBundle.message("coverage.instrumentation.jdk7.compatibility", new Object[0]), JavaCoverageBundle.message("coverage.instrumentation.jdk7.compatibility.veryfy.error.warning", coverageRunner.getPresentableName()), NotificationType.WARNING));
            }
        }
    }

    private void appendCoverageArgument(@NotNull RunConfigurationBase configuration, @NotNull JavaParameters params, JavaCoverageEnabledConfiguration coverageConfig) {
        boolean runsUnderNonLocalTarget;
        JavaParameters coverageParams = new JavaParameters();
        coverageConfig.appendCoverageArgument(configuration, (SimpleJavaParameters)coverageParams);
        boolean bl = runsUnderNonLocalTarget = configuration instanceof TargetEnvironmentAwareRunProfile && ((TargetEnvironmentAwareRunProfile)configuration).needPrepareTarget();
        if (!runsUnderNonLocalTarget) {
            params.getVMParametersList().addAll(coverageParams.getTargetDependentParameters().toLocalParameters());
            this.myTargetDependentParameters = null;
        } else {
            coverageParams.getTargetDependentParameters().asTargetParameters().forEach(params.getTargetDependentParameters().asTargetParameters()::add);
            this.myTargetDependentParameters = params.getTargetDependentParameters();
        }
    }

    public void readExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (!this.isApplicableFor(runConfiguration)) {
            return;
        }
        JavaCoverageEnabledConfiguration.getFrom(runConfiguration).readExternal(element);
    }

    public void writeExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) {
        if (!this.isApplicableFor(runConfiguration)) {
            return;
        }
        JavaCoverageEnabledConfiguration.getFrom(runConfiguration).writeExternal(element);
    }

    public void extendCreatedConfiguration(@NotNull RunConfigurationBase runJavaConfiguration, @NotNull Location location) {
        JavaCoverageEnabledConfiguration coverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getFrom(runJavaConfiguration);
        assert (coverageEnabledConfiguration != null);
        if (runJavaConfiguration instanceof CommonJavaRunConfigurationParameters) {
            coverageEnabledConfiguration.setUpCoverageFilters(((CommonJavaRunConfigurationParameters)runJavaConfiguration).getRunClass(), ((CommonJavaRunConfigurationParameters)runJavaConfiguration).getPackage());
        }
    }

    public void cleanUserData(RunConfigurationBase runConfiguration) {
        runConfiguration.putCopyableUserData(CoverageEnabledConfiguration.COVERAGE_KEY, null);
    }

    public RefactoringElementListener wrapElementListener(PsiElement element, RunConfigurationBase configuration, RefactoringElementListener listener) {
        block5: {
            Object[] filters;
            ClassFilter[] patterns;
            Project project;
            block6: {
                String packageName;
                String qualifiedName;
                block7: {
                    if (!this.isApplicableFor(configuration)) {
                        return listener;
                    }
                    JavaCoverageEnabledConfiguration coverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getFrom(configuration);
                    if (coverageEnabledConfiguration == null) break block5;
                    project = configuration.getProject();
                    patterns = coverageEnabledConfiguration.getCoveragePatterns();
                    filters = CoverageJavaRunConfigurationExtension.getFilters(coverageEnabledConfiguration);
                    if (patterns == null) break block5;
                    assert (filters != null);
                    if (!(element instanceof PsiClass)) break block6;
                    qualifiedName = ((PsiClass)element).getQualifiedName();
                    int idx = ArrayUtil.find((Object[])filters, (Object)qualifiedName);
                    if (idx <= -1) break block7;
                    MyClassAccessor accessor = new MyClassAccessor(project, patterns, idx, (String[])filters);
                    RefactoringElementListener classListener = RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)accessor);
                    if (classListener == null) break block5;
                    listener = CoverageJavaRunConfigurationExtension.appendListener(listener, classListener);
                    break block5;
                }
                if (qualifiedName == null || StringUtil.isEmpty((String)(packageName = StringUtil.getPackageName((String)qualifiedName)))) break block5;
                for (int i = 0; i < filters.length; ++i) {
                    Object filter = filters[i];
                    if (!((String)filter).equals(packageName + ".*")) continue;
                    listener = CoverageJavaRunConfigurationExtension.appendListener(listener, (RefactoringElementListener)new RefactoringListeners.RefactorPackageByClass((RefactoringListeners.Accessor)new MyClassAccessor(project, patterns, i, (String[])filters)));
                    break block5;
                }
                break block5;
            }
            if (element instanceof PsiPackage) {
                String qualifiedName = ((PsiPackage)element).getQualifiedName();
                int filtersLength = filters.length;
                for (int i = 0; i < filtersLength; ++i) {
                    RefactoringElementListener packageListener;
                    if (!((String)filters[i]).startsWith(qualifiedName + ".") || (packageListener = ((String)filters[i]).endsWith("*") ? RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), (RefactoringListeners.Accessor)new MyPackageAccessor(project, patterns, i, (String[])filters)) : RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)new MyClassAccessor(project, patterns, i, (String[])filters))) == null) continue;
                    listener = CoverageJavaRunConfigurationExtension.appendListener(listener, packageListener);
                }
            }
        }
        return listener;
    }

    private static String @Nullable [] getFilters(JavaCoverageEnabledConfiguration coverageEnabledConfiguration) {
        ClassFilter[] patterns = coverageEnabledConfiguration.getCoveragePatterns();
        if (patterns != null) {
            ArrayList<String> filters = new ArrayList<String>();
            for (ClassFilter classFilter : patterns) {
                filters.add(classFilter.getPattern());
            }
            return ArrayUtilRt.toStringArray(filters);
        }
        return null;
    }

    private static RefactoringElementListener appendListener(RefactoringElementListener listener, RefactoringElementListener classOrPackageListener) {
        if (listener == null) {
            listener = new RefactoringElementListenerComposite();
        } else if (!(listener instanceof RefactoringElementListenerComposite)) {
            RefactoringElementListenerComposite composite = new RefactoringElementListenerComposite();
            composite.addListener(listener);
            listener = composite;
        }
        ((RefactoringElementListenerComposite)listener).addListener(classOrPackageListener);
        return listener;
    }

    public boolean isListenerDisabled(RunConfigurationBase configuration, Object listener, RunnerSettings runnerSettings) {
        if (listener instanceof CoverageListener) {
            if (!(runnerSettings instanceof CoverageRunnerData)) {
                return true;
            }
            CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)configuration);
            return !(coverageEnabledConfiguration.getCoverageRunner() instanceof IDEACoverageRunner) || !coverageEnabledConfiguration.isTrackPerTestCoverage() || coverageEnabledConfiguration.isSampling();
        }
        return false;
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase configuration) {
        return CoverageEnabledConfiguration.isApplicableTo((RunConfigurationBase)configuration);
    }

    private static final class MyClassAccessor
    extends MyAccessor
    implements RefactoringListeners.Accessor<PsiClass> {
        private MyClassAccessor(Project project, ClassFilter[] patterns, int idx, String[] filters) {
            super(project, patterns, idx, filters);
        }

        public PsiClass getPsiElement() {
            return JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.getName(), GlobalSearchScope.allScope((Project)this.getProject()));
        }

        public void setPsiElement(PsiClass psiElement) {
            this.setName(psiElement.getQualifiedName());
        }
    }

    private static final class MyPackageAccessor
    extends MyAccessor
    implements RefactoringListeners.Accessor<PsiPackage> {
        private MyPackageAccessor(Project project, ClassFilter[] patterns, int idx, String[] filters) {
            super(project, patterns, idx, filters);
        }

        @Override
        public void setName(String qualifiedName) {
            super.setName(qualifiedName + ".*");
        }

        public PsiPackage getPsiElement() {
            String name = this.getName();
            return JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(name.substring(0, name.length() - ".*".length()));
        }

        public void setPsiElement(PsiPackage psiElement) {
            this.setName(psiElement.getQualifiedName());
        }
    }

    private static class MyAccessor {
        private final Project myProject;
        private final ClassFilter[] myPatterns;
        private final int myIdx;
        private final String[] myFilters;

        private MyAccessor(Project project, ClassFilter[] patterns, int idx, String[] filters) {
            this.myProject = project;
            this.myPatterns = patterns;
            this.myIdx = idx;
            this.myFilters = filters;
        }

        public void setName(String qName) {
            this.myPatterns[this.myIdx] = new ClassFilter(qName);
        }

        public String getName() {
            return this.myFilters[this.myIdx];
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

