/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageClassFilterEditor;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.util.JreVersionDetector;
import com.intellij.icons.AllIcons;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverageConfigurable
extends SettingsEditor<RunConfigurationBase> {
    private static final Logger LOG = Logger.getInstance(CoverageConfigurable.class);
    private final JreVersionDetector myVersionDetector = new JreVersionDetector();
    Project myProject;
    private CoverageClassFilterEditor myClassFilterEditor;
    private CoverageClassFilterEditor myExcludeClassFilterEditor;
    private JLabel myCoverageNotSupportedLabel;
    private JComboBox<CoverageRunnerItem> myCoverageRunnerCb;
    private JPanel myRunnerPanel;
    private JCheckBox myTrackPerTestCoverageCb;
    private JCheckBox myTrackTestSourcesCb;
    private JRadioButton myTracingRb;
    private JRadioButton mySamplingRb;
    private final RunConfigurationBase myConfig;

    public CoverageConfigurable(RunConfigurationBase config) {
        this.myConfig = config;
        this.myProject = config.getProject();
    }

    protected void resetEditorFrom(@NotNull RunConfigurationBase runConfiguration) {
        boolean isJre50 = runConfiguration instanceof CommonJavaRunConfigurationParameters && this.myVersionDetector.isJre50Configured((CommonJavaRunConfigurationParameters)runConfiguration) ? true : (runConfiguration instanceof ModuleBasedConfiguration ? this.myVersionDetector.isModuleJre50Configured((ModuleBasedConfiguration)runConfiguration) : true);
        this.myCoverageNotSupportedLabel.setVisible(!isJre50);
        JavaCoverageEnabledConfiguration configuration = (JavaCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        CoverageRunner runner = configuration.getCoverageRunner();
        if (runner != null) {
            this.myCoverageRunnerCb.setSelectedItem(new CoverageRunnerItem(runner));
        } else {
            String runnerId = configuration.getRunnerId();
            if (runnerId != null) {
                CoverageRunnerItem runnerItem = new CoverageRunnerItem(runnerId);
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCoverageRunnerCb.getModel();
                if (model.getIndexOf(runnerItem) == -1) {
                    model.addElement(runnerItem);
                }
                this.myCoverageRunnerCb.setSelectedItem(runnerItem);
            } else {
                this.myCoverageRunnerCb.setSelectedIndex(0);
            }
            runner = ((CoverageRunnerItem)this.myCoverageRunnerCb.getSelectedItem()).getRunner();
        }
        UIUtil.setEnabled((Component)this.myRunnerPanel, (boolean)isJre50, (boolean)true);
        this.myClassFilterEditor.setFilters(CoverageConfigurable.getCoveragePatterns(configuration, true));
        this.myExcludeClassFilterEditor.setFilters(CoverageConfigurable.getCoveragePatterns(configuration, false));
        boolean isCoverageByTestApplicable = runner != null && runner.isCoverageByTestApplicable();
        this.myTracingRb.setEnabled(this.myTracingRb.isEnabled() && isCoverageByTestApplicable);
        this.mySamplingRb.setSelected(configuration.isSampling() || !isCoverageByTestApplicable);
        this.myTracingRb.setSelected(!this.mySamplingRb.isSelected());
        this.myTrackPerTestCoverageCb.setSelected(configuration.isTrackPerTestCoverage());
        this.myTrackPerTestCoverageCb.setEnabled(this.myTracingRb.isEnabled() && this.myTracingRb.isSelected() && this.canHavePerTestCoverage());
        this.myTrackTestSourcesCb.setSelected(configuration.isTrackTestFolders());
    }

    static ClassFilter[] getCoveragePatterns(@NotNull JavaCoverageEnabledConfiguration configuration, boolean include) {
        return (ClassFilter[])Arrays.stream((ClassFilter[])ObjectUtils.chooseNotNull((Object)configuration.getCoveragePatterns(), (Object)ClassFilter.EMPTY_ARRAY)).filter(classFilter -> classFilter.INCLUDE == include).toArray(ClassFilter[]::new);
    }

    private boolean canHavePerTestCoverage() {
        return CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)this.myConfig).canHavePerTestCoverage();
    }

    protected void applyEditorTo(@NotNull RunConfigurationBase runConfiguration) {
        Object[] oldCoveragePatterns;
        JavaCoverageEnabledConfiguration configuration = (JavaCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        Object[] newCoveragePatterns = (ClassFilter[])ArrayUtil.mergeArrays((Object[])this.myClassFilterEditor.getFilters(), (Object[])this.myExcludeClassFilterEditor.getFilters());
        if (newCoveragePatterns.length != (oldCoveragePatterns = (ClassFilter[])ObjectUtils.chooseNotNull((Object)configuration.getCoveragePatterns(), (Object)ClassFilter.EMPTY_ARRAY)).length || !ContainerUtil.newHashSet((Object[])newCoveragePatterns).equals(ContainerUtil.newHashSet((Object[])oldCoveragePatterns))) {
            configuration.setCoveragePatterns((ClassFilter[])newCoveragePatterns);
        }
        configuration.setCoverageRunner(this.getSelectedRunner());
        configuration.setTrackPerTestCoverage(this.myTrackPerTestCoverageCb.isSelected());
        configuration.setSampling(this.mySamplingRb.isSelected());
        configuration.setTrackTestFolders(this.myTrackTestSourcesCb.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel result = new JPanel(new GridBagLayout());
        DefaultComboBoxModel<CoverageRunnerItem> runnersModel = new DefaultComboBoxModel<CoverageRunnerItem>();
        this.myCoverageRunnerCb = new JComboBox(runnersModel);
        JavaCoverageEnabledConfiguration javaCoverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getFrom(this.myConfig);
        LOG.assertTrue(javaCoverageEnabledConfiguration != null);
        JavaCoverageEngine provider = JavaCoverageEngine.getInstance();
        for (CoverageRunner runner : CoverageRunner.EP_NAME.getExtensionList()) {
            if (!runner.acceptsCoverageEngine((CoverageEngine)provider)) continue;
            runnersModel.addElement(new CoverageRunnerItem(runner));
        }
        this.myCoverageRunnerCb.setRenderer((ListCellRenderer<CoverageRunnerItem>)SimpleListCellRenderer.create((String)"", CoverageRunnerItem::getPresentableName));
        this.myCoverageRunnerCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageRunner runner = CoverageConfigurable.this.getSelectedRunner();
                CoverageConfigurable.this.enableTracingPanel(runner != null && runner.isCoverageByTestApplicable());
                CoverageConfigurable.this.myTrackPerTestCoverageCb.setEnabled(CoverageConfigurable.this.myTracingRb.isSelected() && CoverageConfigurable.this.canHavePerTestCoverage() && runner != null && runner.isCoverageByTestApplicable());
            }
        });
        this.myRunnerPanel = new JPanel(new GridBagLayout());
        this.myRunnerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.myRunnerPanel.add((Component)new JLabel(JavaCoverageBundle.message("run.configuration.choose.coverage.runner", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.insetsRight((int)10), 0, 0));
        this.myRunnerPanel.add(this.myCoverageRunnerCb, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        JPanel cPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.mySamplingRb = new JRadioButton(JavaCoverageBundle.message("run.configuration.coverage.sampling", new Object[0]));
        cPanel.add(this.mySamplingRb);
        this.myTracingRb = new JRadioButton(JavaCoverageBundle.message("run.configuration.coverage.tracing", new Object[0]));
        cPanel.add(this.myTracingRb);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mySamplingRb);
        group.add(this.myTracingRb);
        ActionListener samplingListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageRunner runner = CoverageConfigurable.this.getSelectedRunner();
                CoverageConfigurable.this.myTrackPerTestCoverageCb.setEnabled(CoverageConfigurable.this.canHavePerTestCoverage() && CoverageConfigurable.this.myTracingRb.isSelected() && runner != null && runner.isCoverageByTestApplicable());
            }
        };
        this.mySamplingRb.addActionListener(samplingListener);
        this.myTracingRb.addActionListener(samplingListener);
        this.myTrackPerTestCoverageCb = new JCheckBox(JavaCoverageBundle.message("run.configuration.track.per.test.coverage", new Object[0]));
        JBPanel tracingPanel = JBUI.Panels.simplePanel((Component)this.myTrackPerTestCoverageCb).withBorder((Border)JBUI.Borders.emptyLeft((int)15));
        cPanel.add((Component)tracingPanel);
        this.myRunnerPanel.add((Component)cPanel, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0);
        result.add((Component)this.myRunnerPanel, gc);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints bagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBInsets.emptyInsets(), 0, 0);
        panel.add((Component)new TitledSeparator(JavaCoverageBundle.message("record.coverage.filters.title", new Object[0])), bagConstraints);
        this.myClassFilterEditor = new CoverageClassFilterEditor(this.myProject);
        panel.add((Component)((Object)this.myClassFilterEditor), bagConstraints);
        panel.add((Component)new TitledSeparator(JavaCoverageBundle.message("exclude.coverage.filters.title", new Object[0])), bagConstraints);
        this.myExcludeClassFilterEditor = new CoverageClassFilterEditor(this.myProject){

            @NotNull
            protected ClassFilter createFilter(String pattern) {
                ClassFilter filter = super.createFilter(pattern);
                filter.setInclude(false);
                return filter;
            }
        };
        panel.add((Component)((Object)this.myExcludeClassFilterEditor), bagConstraints);
        bagConstraints.weighty = 0.0;
        this.myTrackTestSourcesCb = new JCheckBox(JavaCoverageBundle.message("run.configuration.enable.coverage.in.test.folders", new Object[0]));
        panel.add((Component)this.myTrackTestSourcesCb, bagConstraints);
        gc.weighty = 1.0;
        gc.fill = 1;
        result.add((Component)panel, gc);
        this.myCoverageNotSupportedLabel = new JLabel(JavaCoverageBundle.message("code.coverage.is.not.supported", new Object[0]));
        this.myCoverageNotSupportedLabel.setIcon(AllIcons.General.WarningDialog);
        result.add((Component)this.myCoverageNotSupportedLabel, gc);
        return result;
    }

    @Nullable
    private CoverageRunner getSelectedRunner() {
        CoverageRunnerItem runnerItem = (CoverageRunnerItem)this.myCoverageRunnerCb.getSelectedItem();
        if (runnerItem == null) {
            LOG.debug("Available runners: " + this.myCoverageRunnerCb.getModel().getSize());
        }
        return runnerItem != null ? runnerItem.getRunner() : null;
    }

    private void enableTracingPanel(boolean enabled) {
        this.myTracingRb.setEnabled(enabled);
        if (!enabled) {
            this.mySamplingRb.setSelected(true);
        }
    }

    private static final class CoverageRunnerItem {
        private CoverageRunner myRunner;
        @NotNull
        private final String myRunnerId;

        private CoverageRunnerItem(@NotNull CoverageRunner runner) {
            this.myRunner = runner;
            this.myRunnerId = runner.getId();
        }

        private CoverageRunnerItem(String runnerId) {
            this.myRunnerId = runnerId;
        }

        public CoverageRunner getRunner() {
            return this.myRunner;
        }

        public String getRunnerId() {
            return this.myRunnerId;
        }

        public String getPresentableName() {
            return this.myRunner != null ? this.myRunner.getPresentableName() : this.myRunnerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoverageRunnerItem that = (CoverageRunnerItem)o;
            return this.myRunnerId.equals(that.myRunnerId);
        }

        public int hashCode() {
            return this.myRunnerId.hashCode();
        }
    }
}

