/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeInsight.AnnotationsPanel;
import com.intellij.coverage.CoverageOptions;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiClass;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ArrayUtil;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class JavaCoverageOptions
extends CoverageOptions {
    private final Project myProject;
    private final JavaCoverageOptionsProvider myCoverageOptionsProvider;
    private JavaCoverageOptionsEditor myEditor;

    JavaCoverageOptions(@NotNull Project project) {
        this.myProject = project;
        this.myCoverageOptionsProvider = JavaCoverageOptionsProvider.getInstance(project);
    }

    public JComponent createComponent() {
        this.myEditor = new JavaCoverageOptionsEditor(this.myProject, this.myCoverageOptionsProvider);
        return this.myEditor.getComponent();
    }

    public boolean isModified() {
        return this.myEditor.isModified(this.myCoverageOptionsProvider);
    }

    public void apply() {
        this.myEditor.apply(this.myCoverageOptionsProvider);
    }

    public void reset() {
        this.myEditor.reset(this.myCoverageOptionsProvider);
    }

    public void disposeUIResources() {
        this.myEditor = null;
    }

    private static class JavaCoverageOptionsEditor {
        private final JPanel myPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        private final JCheckBox myImplicitCheckBox = new JCheckBox(JavaCoverageBundle.message("settings.coverage.java.ignore.implicitly.declared.default.constructors", new Object[0]), true);
        private final JCheckBox myEmptyCheckBox = new JCheckBox(JavaCoverageBundle.message("settings.coverage.java.ignore.empty.private.constructors.of.utility.classes", new Object[0]), true);
        private final AnnotationsPanel myExcludeAnnotationsPanel;

        JavaCoverageOptionsEditor(Project project, JavaCoverageOptionsProvider coverageOptionsProvider) {
            this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaCoverageBundle.message("settings.coverage.java.java.coverage", new Object[0])));
            this.myPanel.add(this.myImplicitCheckBox);
            this.myPanel.add(this.myEmptyCheckBox);
            this.myExcludeAnnotationsPanel = new AnnotationsPanel(project, "Exclude", "", coverageOptionsProvider.getExcludeAnnotationPatterns(), JavaCoverageOptionsProvider.getDefaultExcludeAnnotationPatterns(), Collections.emptySet(), false, false){

                protected boolean isAnnotationAccepted(PsiClass annotation) {
                    return annotation.getContainingClass() == null;
                }
            };
            this.myPanel.add(Box.createVerticalStrut(5));
            this.myPanel.add(this.myExcludeAnnotationsPanel.getComponent());
        }

        public JPanel getComponent() {
            return this.myPanel;
        }

        public boolean isModified(JavaCoverageOptionsProvider provider) {
            return this.myImplicitCheckBox.isSelected() != provider.ignoreImplicitConstructors() || this.myEmptyCheckBox.isSelected() != provider.ignoreEmptyPrivateConstructors() || !Arrays.equals(this.myExcludeAnnotationsPanel.getAnnotations(), ArrayUtil.toStringArray(provider.getExcludeAnnotationPatterns()));
        }

        public void apply(JavaCoverageOptionsProvider provider) {
            provider.setIgnoreImplicitConstructors(this.myImplicitCheckBox.isSelected());
            provider.setIgnoreEmptyPrivateConstructors(this.myEmptyCheckBox.isSelected());
            provider.setExcludeAnnotationPatterns(Arrays.asList(this.myExcludeAnnotationsPanel.getAnnotations()));
        }

        public void reset(JavaCoverageOptionsProvider provider) {
            this.myImplicitCheckBox.setSelected(provider.ignoreImplicitConstructors());
            this.myEmptyCheckBox.setSelected(provider.ignoreEmptyPrivateConstructors());
            this.myExcludeAnnotationsPanel.resetAnnotations(provider.getExcludeAnnotationPatterns());
        }
    }
}

