/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SourceLineCounterUtil;
import com.intellij.coverage.listeners.java.CoverageListener;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.JavaCoverageViewExtension;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.target.RunTargetsEnabled;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.impl.source.tree.java.PsiSwitchStatementImpl;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.task.ProjectTaskManager;
import com.intellij.testIntegration.TestFramework;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import jetbrains.coverage.report.ReportGenerationFailedException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JavaCoverageEngine
extends CoverageEngine {
    private static final Logger LOG = Logger.getInstance((String)JavaCoverageEngine.class.getName());

    public static JavaCoverageEngine getInstance() {
        return (JavaCoverageEngine)((Object)EP_NAME.findExtensionOrFail(JavaCoverageEngine.class));
    }

    public boolean isApplicableTo(@NotNull RunConfigurationBase conf) {
        if (conf instanceof CommonJavaRunConfigurationParameters) {
            return true;
        }
        if (RunTargetsEnabled.get() && conf instanceof TargetEnvironmentAwareRunProfile && JavaCoverageEngine.willRunOnTarget((TargetEnvironmentAwareRunProfile)conf)) {
            return false;
        }
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.isApplicableTo(conf)) continue;
            return true;
        }
        return false;
    }

    private static boolean willRunOnTarget(@NotNull TargetEnvironmentAwareRunProfile configuration) {
        Project project = ((RunConfigurationBase)configuration).getProject();
        return TargetEnvironmentConfigurations.getEffectiveTargetName((TargetEnvironmentAwareRunProfile)configuration, (Project)project) != null || JavaCoverageEngine.isProjectUnderWsl(project);
    }

    private static boolean isProjectUnderWsl(@NotNull Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk == null) {
            return false;
        }
        String projectSdkHomePath = projectSdk.getHomePath();
        return projectSdkHomePath != null && WslPath.isWslUncPath((String)projectSdkHomePath);
    }

    public boolean canHavePerTestCoverage(@NotNull RunConfigurationBase conf) {
        return !(conf instanceof ApplicationConfiguration) && conf instanceof CommonJavaRunConfigurationParameters;
    }

    public Set<String> getTestsForLine(Project project, String classFQName, int lineNumber) {
        return JavaCoverageEngine.extractTracedTests(project, classFQName, lineNumber);
    }

    public boolean wasTestDataCollected(Project project) {
        File[] files = JavaCoverageEngine.getTraceFiles(project);
        return files != null && files.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> extractTracedTests(Project project, String classFQName, int lineNumber) {
        File[] traceFiles;
        HashSet<String> tests = new HashSet<String>();
        for (File traceFile : traceFiles = JavaCoverageEngine.getTraceFiles(project)) {
            FilterInputStream in = null;
            try {
                in = new DataInputStream(new FileInputStream(traceFile));
                JavaCoverageEngine.extractTests(traceFile, (DataInputStream)in, tests, classFQName, lineNumber);
            }
            catch (Exception ex) {
                LOG.error(traceFile.getName(), (Throwable)ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                }
            }
        }
        return tests;
    }

    private static void extractTests(File traceFile, DataInputStream in, Set<? super String> tests, String classFQName, int lineNumber) throws IOException {
        long traceSize = in.readInt();
        int i = 0;
        while ((long)i < traceSize) {
            String className = in.readUTF();
            int linesSize = in.readInt();
            for (int l = 0; l < linesSize; ++l) {
                int line = in.readInt();
                if (!Comparing.strEqual((String)className, (String)classFQName) || lineNumber != line) continue;
                tests.add(FileUtilRt.getNameWithoutExtension((String)traceFile.getName()));
                return;
            }
            ++i;
        }
    }

    private static File @Nullable [] getTraceFiles(Project project) {
        CoverageSuitesBundle currentSuite = CoverageDataManager.getInstance((Project)project).getCurrentSuitesBundle();
        if (currentSuite == null) {
            return null;
        }
        ArrayList files = new ArrayList();
        for (CoverageSuite coverageSuite : currentSuite.getSuites()) {
            File tracesDir = JavaCoverageEngine.getTracesDirectory(coverageSuite);
            File[] suiteFiles = tracesDir.listFiles();
            if (suiteFiles == null) continue;
            Collections.addAll(files, suiteFiles);
        }
        return files.isEmpty() ? null : files.toArray(new File[0]);
    }

    private static File getTracesDirectory(CoverageSuite coverageSuite) {
        String filePath = coverageSuite.getCoverageDataFileName();
        String dirName = FileUtilRt.getNameWithoutExtension((String)new File(filePath).getName());
        File parentDir = new File(filePath).getParentFile();
        return new File(parentDir, dirName);
    }

    public void collectTestLines(List<String> sanitizedTestNames, CoverageSuite suite, Map<String, Set<Integer>> executionTrace) {
        File tracesDir = JavaCoverageEngine.getTracesDirectory(suite);
        for (String testName : sanitizedTestNames) {
            File file = new File(tracesDir, testName + ".tr");
            if (!file.exists()) continue;
            try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
                int traceSize = in.readInt();
                for (int i = 0; i < traceSize; ++i) {
                    String className = in.readUTF();
                    int linesSize = in.readInt();
                    Set lines = executionTrace.computeIfAbsent(className, k -> new HashSet());
                    for (int l = 0; l < linesSize; ++l) {
                        lines.add(in.readInt());
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void deleteAssociatedTraces(CoverageSuite suite) {
        File tracesDirectory;
        if (suite.isTracingEnabled() && (tracesDirectory = JavaCoverageEngine.getTracesDirectory(suite)).exists()) {
            FileUtil.delete((File)tracesDirectory);
        }
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase conf) {
        return new JavaCoverageEnabledConfiguration(conf, this);
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        return this.createSuite(covRunner, name, coverageDataFileProvider, filters, null, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, project);
    }

    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (config instanceof JavaCoverageEnabledConfiguration) {
            JavaCoverageEnabledConfiguration javaConfig = (JavaCoverageEnabledConfiguration)config;
            return this.createSuite(covRunner, name, coverageDataFileProvider, javaConfig.getPatterns(), javaConfig.getExcludePatterns(), new Date().getTime(), javaConfig.isTrackPerTestCoverage() && !javaConfig.isSampling(), !javaConfig.isSampling(), javaConfig.isTrackTestFolders(), config.getConfiguration().getProject());
        }
        return null;
    }

    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        return new JavaCoverageSuite(this);
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(@NotNull Project project) {
        return JavaCoverageAnnotator.getInstance(project);
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
        return module != null;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Project project = psiFile.getProject();
        if (!suite.isTrackTestFolders() && ((Boolean)ReadAction.compute(() -> TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project))).booleanValue()) {
            return false;
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (psiFile instanceof PsiClassOwner && javaSuite.isPackageFiltered((String)ReadAction.compute(() -> ((PsiClassOwner)psiFile).getPackageName()))) {
                return true;
            }
            List<PsiClass> classes = javaSuite.getCurrentSuiteClasses(project);
            for (PsiClass aClass : classes) {
                PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiClass)aClass).getContainingFile());
                if (!psiFile.equals(containingFile)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
        if (compilerModuleExtension == null) {
            return false;
        }
        @Nullable File outputpath = JavaCoverageEngine.getOutputpath(compilerModuleExtension);
        @Nullable File testOutputpath = JavaCoverageEngine.getTestOutputpath(compilerModuleExtension);
        if (JavaCoverageEngine.isModuleOutputNeededAndisMissing(module, JavaSourceRootType.SOURCE, outputpath) || suite.isTrackTestFolders() && JavaCoverageEngine.isModuleOutputNeededAndisMissing(module, JavaSourceRootType.TEST_SOURCE, testOutputpath)) {
            Project project = module.getProject();
            if (suite.isModuleChecked(module)) {
                return false;
            }
            suite.checkModule(module);
            LOG.debug("Going to ask to rebuild project. Module output was [" + outputpath + "] for url [" + compilerModuleExtension.getCompilerOutputUrl() + "]\nTest output was [" + testOutputpath + "] for url [" + compilerModuleExtension.getCompilerOutputUrlForTests() + "] and  suite.isTrackTestFolders() is " + suite.isTrackTestFolders(), new Throwable("trace"));
            Runnable runnable = () -> {
                int choice = Messages.showOkCancelDialog((Project)project, (String)JavaCoverageBundle.message("project.class.files.are.out.of.date", new Object[0]), (String)JavaCoverageBundle.message("project.is.out.of.date", new Object[0]), (String)JavaCoverageBundle.message("coverage.recompile", new Object[0]), (String)JavaCoverageBundle.message("coverage.hide.report", new Object[0]), (Icon)Messages.getWarningIcon());
                if (choice == 0) {
                    ProjectTaskManager taskManager = ProjectTaskManager.getInstance((Project)project);
                    Promise promise = taskManager.buildAllModules();
                    promise.onSuccess(result -> ApplicationManager.getApplication().invokeLater(() -> CoverageDataManager.getInstance((Project)project).chooseSuitesBundle(suite), o -> project.isDisposed()));
                } else if (!project.isDisposed()) {
                    CoverageDataManager.getInstance((Project)project).chooseSuitesBundle(null);
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable);
            return true;
        }
        return false;
    }

    @Nullable
    private static File getOutputpath(CompilerModuleExtension compilerModuleExtension) {
        @Nullable String outputpathUrl = compilerModuleExtension.getCompilerOutputUrl();
        @Nullable File outputpath = outputpathUrl != null ? new File(VfsUtilCore.urlToPath((String)outputpathUrl)) : null;
        return outputpath;
    }

    @Nullable
    private static File getTestOutputpath(CompilerModuleExtension compilerModuleExtension) {
        @Nullable String outputpathUrl = compilerModuleExtension.getCompilerOutputUrlForTests();
        @Nullable File outputpath = outputpathUrl != null ? new File(VfsUtilCore.urlToPath((String)outputpathUrl)) : null;
        return outputpath;
    }

    private static boolean isModuleOutputNeeded(Module module, JavaSourceRootType rootType) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)module.getProject());
        return ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType).stream().anyMatch(vFile -> !compilerManager.isExcludedFromCompilation(vFile));
    }

    private static boolean isModuleOutputNeededAndisMissing(Module module, JavaSourceRootType rootType, @Nullable File outputPath) {
        return (outputPath == null || !outputPath.exists()) && JavaCoverageEngine.isModuleOutputNeeded(module, rootType);
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        byte[] content;
        try {
            content = FileUtil.loadFileBytes((File)classFile);
        }
        catch (IOException e) {
            return null;
        }
        ArrayList<Integer> uncoveredLines = new ArrayList<Integer>();
        try {
            SourceLineCounterUtil.collectSrcLinesForUntouchedFiles(uncoveredLines, content, !suite.isTracingEnabled(), suite.getProject());
        }
        catch (Exception e) {
            LOG.error("Fail to process class from: " + classFile.getPath(), (Throwable)e);
        }
        return uncoveredLines;
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (!javaSuite.isClassFiltered(qualifiedName) && !javaSuite.isPackageFiltered(JavaCoverageEngine.getPackageName(sourceFile))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        String packageFQName = JavaCoverageEngine.getPackageName(sourceFile);
        return StringUtil.getQualifiedName((String)packageFQName, (String)FileUtilRt.getNameWithoutExtension((String)outputFile.getName()));
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        PsiClass[] classes = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)sourceFile).getClasses());
        HashSet<String> qNames = new HashSet<String>();
        for (JavaCoverageEngineExtension nameExtension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!((Boolean)ReadAction.compute(() -> nameExtension.suggestQualifiedName(sourceFile, classes, qNames))).booleanValue()) continue;
            return qNames;
        }
        for (PsiClass aClass : classes) {
            String qName = (String)ReadAction.compute(() -> aClass.getQualifiedName());
            if (qName == null) continue;
            qNames.add(qName);
        }
        return qNames;
    }

    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite) {
        PsiClass[] classes;
        File vDir;
        if (module == null) {
            return Collections.emptySet();
        }
        HashSet<File> classFiles = new HashSet<File>();
        @Nullable File outputpath = JavaCoverageEngine.getOutputpath(CompilerModuleExtension.getInstance((Module)module));
        @Nullable File testOutputpath = JavaCoverageEngine.getTestOutputpath(CompilerModuleExtension.getInstance((Module)module));
        @Nullable VirtualFile outputpathVirtualFile = JavaCoverageEngine.fileToVirtualFileWithRefresh(outputpath);
        @Nullable VirtualFile testOutputpathVirtualFile = JavaCoverageEngine.fileToVirtualFileWithRefresh(testOutputpath);
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.collectOutputFiles(srcFile, outputpathVirtualFile, testOutputpathVirtualFile, suite, classFiles)) continue;
            return classFiles;
        }
        String packageFQName = JavaCoverageEngine.getPackageName(srcFile);
        String packageVmName = packageFQName.replace('.', '/');
        ArrayList children = new ArrayList();
        File file = outputpath == null ? null : (vDir = !packageVmName.isEmpty() ? new File(outputpath, packageVmName) : outputpath);
        if (vDir != null && vDir.exists()) {
            Collections.addAll(children, vDir.listFiles());
        }
        if (suite.isTrackTestFolders()) {
            File testDir;
            File file2 = testOutputpath == null ? null : (testDir = !packageVmName.isEmpty() ? new File(testOutputpath, packageVmName) : testOutputpath);
            if (testDir != null && testDir.exists()) {
                Collections.addAll(children, testDir.listFiles());
            }
        }
        for (PsiClass psiClass : classes = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)srcFile).getClasses())) {
            String className = (String)ReadAction.compute(() -> psiClass.getName());
            for (File child : children) {
                String childName;
                if (!FileUtilRt.extensionEquals((String)child.getName(), (String)JavaClassFileType.INSTANCE.getDefaultExtension()) || !(childName = FileUtilRt.getNameWithoutExtension((String)child.getName())).equals(className) && (!childName.startsWith(className) || childName.charAt(className.length()) != '$')) continue;
                classFiles.add(child);
            }
        }
        return classFiles;
    }

    @Nullable
    private static VirtualFile fileToVirtualFileWithRefresh(@Nullable File file) {
        if (file == null) {
            return null;
        }
        return (VirtualFile)WriteAction.computeAndWait(() -> VfsUtil.findFileByIoFile((File)file, (boolean)true));
    }

    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        StringBuilder buf = new StringBuilder();
        buf.append(CoverageBundle.message((String)"hits.title", (Object[])new Object[]{""}));
        if (lineData == null) {
            buf.append(0);
            return buf.toString();
        }
        buf.append(lineData.getHits()).append("\n");
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            String report = extension.generateBriefReport(editor, psiFile, lineNumber, startOffset, endOffset, lineData);
            if (report == null) continue;
            buf.append(report);
            return report;
        }
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        Project project = editor.getProject();
        for (int offset = startOffset; offset < endOffset; ++offset) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), PsiStatement.class);
            PsiExpression condition = null;
            if (parent instanceof PsiIfStatement) {
                condition = ((PsiIfStatement)parent).getCondition();
            } else if (parent instanceof PsiSwitchStatement) {
                condition = ((PsiSwitchStatement)parent).getExpression();
            } else if (parent instanceof PsiConditionalLoopStatement) {
                condition = ((PsiConditionalLoopStatement)parent).getCondition();
            } else if (parent instanceof PsiForeachStatement) {
                condition = ((PsiForeachStatement)parent).getIteratedValue();
            } else if (parent instanceof PsiAssertStatement) {
                condition = ((PsiAssertStatement)parent).getAssertCondition();
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)psiFile.findElementAt(offset), (boolean)false)) continue;
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance((Project)project).getControlFlow(parent, (ControlFlowPolicy)AllVariablesControlFlowPolicy.getInstance());
                for (Instruction instruction : controlFlow.getInstructions()) {
                    PsiExpression psiExpression;
                    if (!(instruction instanceof ConditionalBranchingInstruction) || expressions.contains(psiExpression = ((ConditionalBranchingInstruction)instruction).expression)) continue;
                    expressions.add(psiExpression);
                }
                continue;
            }
            catch (AnalysisCanceledException e) {
                return buf.toString();
            }
        }
        try {
            int idx = 0;
            int hits = 0;
            String indent = "    ";
            if (lineData.getJumps() != null) {
                for (JumpData jumpData : lineData.getJumps()) {
                    PsiExpression expression;
                    PsiElement parentExpression;
                    if (jumpData.getTrueHits() + jumpData.getFalseHits() <= 0) continue;
                    boolean reverse = (parentExpression = (expression = (PsiExpression)expressions.get(idx++)).getParent()) instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parentExpression).getOperationTokenType() == JavaTokenType.OROR || parentExpression instanceof PsiDoWhileStatement || parentExpression instanceof PsiAssertStatement;
                    buf.append("    ").append(expression.getText()).append("\n");
                    buf.append("    ").append("    ").append("true").append(" ").append(CoverageBundle.message((String)"hits.message", (Object[])new Object[]{reverse ? jumpData.getFalseHits() : jumpData.getTrueHits()})).append("\n");
                    buf.append("    ").append("    ").append("false").append(" ").append(CoverageBundle.message((String)"hits.message", (Object[])new Object[]{reverse ? jumpData.getTrueHits() : jumpData.getFalseHits()})).append("\n");
                    hits += jumpData.getTrueHits() + jumpData.getFalseHits();
                }
            }
            if (lineData.getSwitches() != null) {
                for (JumpData jumpData : lineData.getSwitches()) {
                    PsiExpression conditionExpression = (PsiExpression)expressions.get(idx++);
                    buf.append("    ").append(conditionExpression.getText()).append("\n");
                    int i = 0;
                    for (int key : jumpData.getKeys()) {
                        int switchHits = jumpData.getHits()[i++];
                        buf.append("    ").append("    ").append("case ").append(key).append(": ").append(switchHits).append("\n");
                        hits += switchHits;
                    }
                    int defaultHits = jumpData.getDefaultHits();
                    boolean hasDefaultLabel = JavaCoverageEngine.hasDefaultLabel((PsiElement)conditionExpression);
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    if (!hasDefaultLabel) {
                        defaultHits -= hits;
                    }
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    buf.append("    ").append("    ").append("default: ").append(defaultHits).append("\n");
                    hits += defaultHits;
                }
            }
            if (lineData.getHits() > hits && hits > 0) {
                buf.append(JavaCoverageBundle.message("report.unknown.outcome", lineData.getHits() - hits));
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return CoverageBundle.message((String)"hits.title", (Object[])new Object[]{lineData.getHits()});
        }
        return buf.toString();
    }

    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        String qualifiedName;
        PsiMethod method;
        PsiClass aClass;
        if (element instanceof PsiMethod && (aClass = (method = (PsiMethod)element).getContainingClass()) != null && (qualifiedName = ClassUtil.getJVMClassName((PsiClass)aClass)) != null) {
            return qualifiedName + "," + CoverageListener.sanitize((String)method.getName(), (int)qualifiedName.length());
        }
        return testProxy.toString();
    }

    @NotNull
    public List<PsiElement> findTestsByNames(String @NotNull [] testNames, @NotNull Project project) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (String testName : testNames) {
            int index = testName.indexOf(",");
            if (index <= 0) {
                return elements;
            }
            JavaCoverageEngine.collectTestsByName(elements, testName.substring(index + 1), testName.substring(0, index), psiManager);
        }
        return elements;
    }

    private static void collectTestsByName(List<? super PsiElement> elements, String testName, String className, PsiManager psiManager) {
        PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)psiManager, (String)className);
        if (psiClass == null) {
            return;
        }
        TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
        if (testFramework == null) {
            return;
        }
        Arrays.stream(psiClass.getAllMethods()).filter(method -> testFramework.isTestMethod((PsiElement)method) && testName.equals(CoverageListener.sanitize((String)method.getName(), (int)className.length()))).forEach(elements::add);
    }

    private static boolean hasDefaultLabel(PsiElement conditionExpression) {
        PsiElement bodyElement;
        boolean hasDefault = false;
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)conditionExpression, PsiSwitchStatement.class);
        PsiCodeBlock body = ((PsiSwitchStatementImpl)conditionExpression.getParent()).getBody();
        if (body != null && (bodyElement = body.getFirstBodyElement()) != null) {
            PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)bodyElement, PsiSwitchLabelStatement.class);
            while (label != null) {
                if (label.getEnclosingSwitchStatement() == switchStatement) {
                    hasDefault |= label.isDefaultCase();
                }
                label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiSwitchLabelStatement.class);
            }
        }
        return hasDefault;
    }

    protected JavaCoverageSuite createSuite(CoverageRunner acceptedCovRunner, String name, CoverageFileProvider coverageDataFileProvider, String[] filters, String[] excludePatterns, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        return new JavaCoverageSuite(name, coverageDataFileProvider, filters, excludePatterns, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, acceptedCovRunner, this, project);
    }

    @NotNull
    protected static String getPackageName(PsiFile sourceFile) {
        return (String)ReadAction.compute(() -> ((PsiClassOwner)sourceFile).getPackageName());
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        return projectSdk != null;
    }

    public final void generateReport(final @NotNull Project project, @NotNull DataContext dataContext, final @NotNull CoverageSuitesBundle currentSuite) {
        final ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaCoverageBundle.message("generating.coverage.report", new Object[0])){
            final Exception[] myExceptions;
            {
                super(arg0, arg1);
                this.myExceptions = new Exception[1];
            }

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    ((JavaCoverageRunner)currentSuite.getSuites()[0].getRunner()).generateReport(currentSuite, project);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (ReportGenerationFailedException e) {
                    this.myExceptions[0] = e;
                }
            }

            public void onSuccess() {
                if (this.myExceptions[0] != null) {
                    Messages.showErrorDialog((Project)project, (String)this.myExceptions[0].getMessage(), (String)CommonBundle.getErrorTitle());
                    return;
                }
                if (settings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)new File(settings.OUTPUT_DIRECTORY, "index.html"));
                }
            }
        });
    }

    @Nls
    public String getPresentableText() {
        return JavaCoverageBundle.message("java.coverage.engine.presentable.text", new Object[0]);
    }

    public boolean isGeneratedCode(Project project, String qualifiedName, Object lineData) {
        if (JavaCoverageOptionsProvider.getInstance(project).isGeneratedConstructor(qualifiedName, ((LineData)lineData).getMethodSignature())) {
            return true;
        }
        return super.isGeneratedCode(project, qualifiedName, lineData);
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return new JavaCoverageViewExtension((JavaCoverageAnnotator)this.getCoverageAnnotator(project), project, suiteBundle, stateBean);
    }

    public static boolean isSourceMapNeeded(RunConfigurationBase configuration) {
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.isSourceMapNeeded(configuration)) continue;
            return true;
        }
        return false;
    }
}

