/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JavaCoverageClassesEnumerator {
    protected final CoverageSuitesBundle mySuite;
    protected final Project myProject;
    protected final CoverageDataManager myCoverageManager;
    private final boolean[] myShouldVisitTestSource;
    private final int myRootsCount;
    private int myCurrentRootsCount;

    public JavaCoverageClassesEnumerator(@NotNull CoverageSuitesBundle suite, @NotNull Project project, int totalRoots) {
        boolean[] blArray;
        this.mySuite = suite;
        this.myProject = project;
        this.myCoverageManager = CoverageDataManager.getInstance((Project)this.myProject);
        if (this.mySuite.isTrackTestFolders()) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = false;
            blArray = blArray2;
            blArray2[1] = true;
        } else {
            boolean[] blArray3 = new boolean[1];
            blArray = blArray3;
            blArray3[0] = false;
        }
        this.myShouldVisitTestSource = blArray;
        this.myRootsCount = totalRoots;
    }

    protected void visitClass(PsiClass psiClass) {
    }

    protected void visitClassFiles(String topLevelClassName, List<File> files, String packageVMName, GlobalSearchScope scope) {
    }

    protected void setJavaSuite(JavaCoverageSuite suite) {
    }

    public void visitSuite() {
        this.myCurrentRootsCount = 0;
        this.updateProgress();
        for (CoverageSuite coverageSuite : this.mySuite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            this.setJavaSuite(javaSuite);
            List<PsiClass> classes = javaSuite.getCurrentSuiteClasses(this.myProject);
            List<PsiPackage> packages = javaSuite.getCurrentSuitePackages(this.myProject);
            for (PsiPackage psiPackage : packages) {
                ProgressIndicatorProvider.checkCanceled();
                this.visitRootPackage(psiPackage);
            }
            for (PsiClass psiClass : classes) {
                ProgressIndicatorProvider.checkCanceled();
                ApplicationManager.getApplication().runReadAction(() -> {
                    String packageName = ((PsiClassOwner)psiClass.getContainingFile()).getPackageName();
                    PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
                    if (psiPackage == null) {
                        return;
                    }
                    this.visitClass(psiClass);
                });
            }
        }
    }

    public void visitRootPackage(PsiPackage psiPackage) {
        ProjectData data = this.mySuite.getCoverageData();
        if (data == null) {
            return;
        }
        if (!this.isPackageFiltered(psiPackage)) {
            return;
        }
        GlobalSearchScope scope = this.mySuite.getSearchScope(this.myProject);
        Module[] modules = (Module[])this.myCoverageManager.doInReadActionIfProjectOpen(() -> ModuleManager.getInstance((Project)this.myProject).getModules());
        if (modules == null) {
            return;
        }
        String qualifiedName = psiPackage.getQualifiedName();
        String rootPackageVMName = qualifiedName.replace('.', '/');
        for (Module module : modules) {
            if (!scope.isSearchInModuleContent(module)) continue;
            ProgressIndicatorProvider.checkCanceled();
            HashSet<VirtualFile> productionRootsSet = new HashSet<VirtualFile>();
            for (boolean isTestSource : this.myShouldVisitTestSource) {
                this.visitSource(psiPackage, module, scope, rootPackageVMName, isTestSource, productionRootsSet);
            }
        }
    }

    protected void visitSource(PsiPackage psiPackage, Module module, GlobalSearchScope scope, String rootPackageVMName, boolean isTestSource, Set<VirtualFile> productionRootsSet) {
        VirtualFile[] roots = JavaCoverageClassesEnumerator.getRoots(this.myCoverageManager, module, isTestSource);
        if (roots == null) {
            return;
        }
        for (VirtualFile output : roots) {
            if (!isTestSource) {
                productionRootsSet.add(output);
            } else if (productionRootsSet.contains(output)) continue;
            File outputRoot = PackageAnnotator.findRelativeFile(rootPackageVMName, VfsUtilCore.virtualToIoFile((VirtualFile)output));
            if (!outputRoot.exists()) continue;
            this.visitRoot(outputRoot, rootPackageVMName, scope);
        }
    }

    protected void visitRoot(File packageOutputRoot, String rootPackageVMName, GlobalSearchScope scope) {
        Stack stack = new Stack((Object[])new PackageData[]{new PackageData(rootPackageVMName, packageOutputRoot.listFiles())});
        while (!stack.isEmpty()) {
            ProgressIndicatorProvider.checkCanceled();
            PackageData packageData = (PackageData)stack.pop();
            String packageVMName = packageData.packageVMName;
            File[] children = packageData.children;
            if (children == null) continue;
            HashMap<String, List> topLevelClasses = new HashMap<String, List>();
            for (File child : children) {
                if (PackageAnnotator.isClassFile(child)) {
                    String childName = PackageAnnotator.getClassName(child);
                    String classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                    String toplevelClassSrcFQName = PackageAnnotator.getSourceToplevelFQName(classFqVMName);
                    topLevelClasses.computeIfAbsent(toplevelClassSrcFQName, k -> new ArrayList()).add(child);
                    continue;
                }
                if (!child.isDirectory()) continue;
                String childPackageVMName = JavaCoverageClassesEnumerator.getChildVMName(packageVMName, child);
                stack.push((Object)new PackageData(childPackageVMName, child.listFiles()));
            }
            for (Map.Entry entry : topLevelClasses.entrySet()) {
                this.visitClassFiles((String)entry.getKey(), (List)entry.getValue(), packageVMName, scope);
            }
        }
        ++this.myCurrentRootsCount;
        this.updateProgress();
    }

    private void updateProgress() {
        if (this.myRootsCount <= 1) {
            return;
        }
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator == null) {
            return;
        }
        progressIndicator.setIndeterminate(false);
        progressIndicator.setFraction((double)this.myCurrentRootsCount / (double)this.myRootsCount);
    }

    @NotNull
    protected static String getChildVMName(@NotNull String packageVMName, @NotNull File child) {
        String childName = child.getName();
        return packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
    }

    private boolean isPackageFiltered(@NotNull PsiPackage psiPackage) {
        String qualifiedName = psiPackage.getQualifiedName();
        for (CoverageSuite coverageSuite : this.mySuite.getSuites()) {
            if (!(coverageSuite instanceof JavaCoverageSuite) || !((JavaCoverageSuite)coverageSuite).isPackageFiltered(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public static VirtualFile[] getRoots(CoverageDataManager manager, Module module, boolean isTestSource) {
        return (VirtualFile[])manager.doInReadActionIfProjectOpen(() -> {
            OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().withoutDepModules();
            if (isTestSource) {
                enumerator = enumerator.productionOnly();
            }
            return enumerator.classes().getRoots();
        });
    }

    private static final class PackageData {
        private final String packageVMName;
        private final File[] children;

        private PackageData(String packageVMName, File[] children) {
            this.packageVMName = packageVMName;
            this.children = children;
        }
    }

    public static class RootsCounter
    extends JavaCoverageClassesEnumerator {
        private int myRoots;

        public RootsCounter(@NotNull CoverageSuitesBundle suite, @NotNull Project project) {
            super(suite, project, 0);
            this.visitSuite();
        }

        @Override
        protected void visitRoot(File packageOutputRoot, String rootPackageVMName, GlobalSearchScope scope) {
            ++this.myRoots;
        }

        public int getRoots() {
            return this.myRoots;
        }
    }
}

