/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageClassesAnnotator;
import com.intellij.coverage.JavaCoverageClassesEnumerator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.ProjectData;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaCoverageAnnotator
extends BaseCoverageAnnotator {
    private final Map<String, PackageAnnotator.PackageCoverageInfo> myPackageCoverageInfos = new HashMap<String, PackageAnnotator.PackageCoverageInfo>();
    private final Map<String, PackageAnnotator.PackageCoverageInfo> myFlattenPackageCoverageInfos = new HashMap<String, PackageAnnotator.PackageCoverageInfo>();
    private final Map<VirtualFile, PackageAnnotator.PackageCoverageInfo> myDirCoverageInfos = new HashMap<VirtualFile, PackageAnnotator.PackageCoverageInfo>();
    private final Map<VirtualFile, PackageAnnotator.PackageCoverageInfo> myTestDirCoverageInfos = new HashMap<VirtualFile, PackageAnnotator.PackageCoverageInfo>();
    private final Map<String, PackageAnnotator.ClassCoverageInfo> myClassCoverageInfos = new ConcurrentHashMap<String, PackageAnnotator.ClassCoverageInfo>();
    private final Map<PsiElement, PackageAnnotator.SummaryCoverageInfo> myExtensionCoverageInfos = new WeakHashMap<PsiElement, PackageAnnotator.SummaryCoverageInfo>();

    public JavaCoverageAnnotator(Project project) {
        super(project);
    }

    public static JavaCoverageAnnotator getInstance(Project project) {
        return (JavaCoverageAnnotator)((Object)project.getService(JavaCoverageAnnotator.class));
    }

    @Nullable
    public String getDirCoverageInformationString(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager coverageDataManager) {
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (psiPackage == null) {
            return null;
        }
        VirtualFile virtualFile = directory.getVirtualFile();
        boolean isInTestContent = TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)directory.getProject());
        if (!currentSuite.isTrackTestFolders() && isInTestContent) {
            return null;
        }
        return JavaCoverageAnnotator.getCoverageInformationString(isInTestContent ? (PackageAnnotator.SummaryCoverageInfo)this.myTestDirCoverageInfos.get(virtualFile) : (PackageAnnotator.SummaryCoverageInfo)this.myDirCoverageInfos.get(virtualFile), coverageDataManager.isSubCoverageActive());
    }

    @Nullable
    public String getFileCoverageInformationString(@NotNull PsiFile file, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()) {
            PackageAnnotator.ClassCoverageInfo info = extension.getSummaryCoverageInfo(this, (PsiNamedElement)file);
            if (info == null) continue;
            return JavaCoverageAnnotator.getCoverageInformationString(info, manager.isSubCoverageActive());
        }
        return null;
    }

    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myPackageCoverageInfos.clear();
        this.myFlattenPackageCoverageInfos.clear();
        this.myDirCoverageInfos.clear();
        this.myTestDirCoverageInfos.clear();
        this.myClassCoverageInfos.clear();
        this.myExtensionCoverageInfos.clear();
    }

    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        Project project = this.getProject();
        return () -> {
            PackageAnnotator.Annotator annotator = new PackageAnnotator.Annotator(){

                @Override
                public void annotatePackage(String packageQualifiedName, PackageAnnotator.PackageCoverageInfo packageCoverageInfo) {
                    JavaCoverageAnnotator.this.myPackageCoverageInfos.put(packageQualifiedName, packageCoverageInfo);
                }

                @Override
                public void annotatePackage(String packageQualifiedName, PackageAnnotator.PackageCoverageInfo packageCoverageInfo, boolean flatten) {
                    if (flatten) {
                        JavaCoverageAnnotator.this.myFlattenPackageCoverageInfos.put(packageQualifiedName, packageCoverageInfo);
                    } else {
                        this.annotatePackage(packageQualifiedName, packageCoverageInfo);
                    }
                }

                @Override
                public void annotateSourceDirectory(VirtualFile dir, PackageAnnotator.PackageCoverageInfo dirCoverageInfo, Module module) {
                    JavaCoverageAnnotator.this.myDirCoverageInfos.put(dir, dirCoverageInfo);
                }

                @Override
                public void annotateTestDirectory(VirtualFile virtualFile, PackageAnnotator.PackageCoverageInfo packageCoverageInfo, Module module) {
                    JavaCoverageAnnotator.this.myTestDirCoverageInfos.put(virtualFile, packageCoverageInfo);
                }

                @Override
                public void annotateClass(String classQualifiedName, PackageAnnotator.ClassCoverageInfo classCoverageInfo) {
                    JavaCoverageAnnotator.this.myClassCoverageInfos.put(classQualifiedName, classCoverageInfo);
                }
            };
            long startNs = System.nanoTime();
            int totalRoots = new JavaCoverageClassesEnumerator.RootsCounter(suite, project).getRoots();
            new JavaCoverageClassesAnnotator(suite, project, annotator, totalRoots).visitSuite();
            dataManager.triggerPresentationUpdate();
            long endNs = System.nanoTime();
            int annotatedClasses = this.myClassCoverageInfos.size();
            ProjectData data = suite.getCoverageData();
            int loadedClasses = data == null ? 0 : data.getClassesNumber();
            CoverageLogger.logReportBuilding((Project)project, (long)TimeUnit.NANOSECONDS.toMillis(endNs - startNs), (int)annotatedClasses, (int)loadedClasses);
        };
    }

    @Nullable
    @Nls
    public static String getCoverageInformationString(PackageAnnotator.SummaryCoverageInfo info, boolean subCoverageActive) {
        if (info == null) {
            return null;
        }
        if (info.totalClassCount == 0 || info.totalLineCount == 0) {
            return null;
        }
        if (subCoverageActive) {
            return info.coveredClassCount + info.getCoveredLineCount() > 0 ? CoverageBundle.message((String)"coverage.view.text.covered", (Object[])new Object[0]) : null;
        }
        return JavaCoverageBundle.message("coverage.view.text.classes.covered", (int)((double)info.coveredClassCount / (double)info.totalClassCount * 100.0)) + ", " + CoverageBundle.message((String)"coverage.view.text.lines.covered", (Object[])new Object[]{(int)((double)info.getCoveredLineCount() / (double)info.totalLineCount * 100.0)});
    }

    @Nullable
    public String getPackageCoverageInformationString(PsiPackage psiPackage, @Nullable Module module, @NotNull CoverageDataManager coverageDataManager) {
        return this.getPackageCoverageInformationString(psiPackage, module, coverageDataManager, false);
    }

    @Nullable
    public String getPackageCoverageInformationString(PsiPackage psiPackage, @Nullable Module module, @NotNull CoverageDataManager coverageDataManager, boolean flatten) {
        if (psiPackage == null) {
            return null;
        }
        boolean subCoverageActive = coverageDataManager.isSubCoverageActive();
        if (module != null) {
            PsiDirectory[] directories = psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module));
            PackageAnnotator.SummaryCoverageInfo result = null;
            for (PsiDirectory directory : directories) {
                VirtualFile virtualFile = directory.getVirtualFile();
                result = JavaCoverageAnnotator.merge(result, this.myDirCoverageInfos.get(virtualFile));
                result = JavaCoverageAnnotator.merge(result, this.myTestDirCoverageInfos.get(virtualFile));
            }
            return JavaCoverageAnnotator.getCoverageInformationString(result, subCoverageActive);
        }
        PackageAnnotator.PackageCoverageInfo info = this.getPackageCoverageInfo(psiPackage.getQualifiedName(), flatten);
        return JavaCoverageAnnotator.getCoverageInformationString(info, subCoverageActive);
    }

    public PackageAnnotator.PackageCoverageInfo getPackageCoverageInfo(@NotNull String qualifiedName, boolean flattenPackages) {
        return flattenPackages ? this.myFlattenPackageCoverageInfos.get(qualifiedName) : this.myPackageCoverageInfos.get(qualifiedName);
    }

    public String getLineCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.getCoveredLineCount(), info.totalLineCount);
    }

    public String getMethodCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.coveredMethodCount, info.totalMethodCount);
    }

    public String getClassCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.coveredClassCount, info.totalClassCount);
    }

    public String getBranchCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.coveredBranchCount, info.totalBranchCount);
    }

    private static String getPercentage(int covered, int total) {
        int percentage = total == 0 ? 100 : (int)((double)covered / (double)total * 100.0);
        return percentage + "% (" + covered + "/" + total + ")";
    }

    public static PackageAnnotator.SummaryCoverageInfo merge(@Nullable PackageAnnotator.SummaryCoverageInfo info, @Nullable PackageAnnotator.SummaryCoverageInfo testInfo) {
        if (info == null) {
            return testInfo;
        }
        if (testInfo == null) {
            return info;
        }
        PackageAnnotator.PackageCoverageInfo coverageInfo = new PackageAnnotator.PackageCoverageInfo();
        coverageInfo.totalClassCount = info.totalClassCount + testInfo.totalClassCount;
        coverageInfo.coveredClassCount = info.coveredClassCount + testInfo.coveredClassCount;
        coverageInfo.totalLineCount = info.totalLineCount + testInfo.totalLineCount;
        coverageInfo.coveredLineCount = info.getCoveredLineCount() + testInfo.getCoveredLineCount();
        coverageInfo.totalBranchCount = info.totalBranchCount + testInfo.totalBranchCount;
        coverageInfo.coveredBranchCount = info.coveredBranchCount + testInfo.coveredBranchCount;
        return coverageInfo;
    }

    @Nullable
    @Nls
    public String getClassCoverageInformationString(String classFQName, CoverageDataManager coverageDataManager) {
        PackageAnnotator.ClassCoverageInfo info = this.myClassCoverageInfos.get(classFQName);
        return JavaCoverageAnnotator.getClassCoverageInformationString(info, coverageDataManager);
    }

    @Nullable
    @Nls
    public static String getClassCoverageInformationString(PackageAnnotator.ClassCoverageInfo info, CoverageDataManager coverageDataManager) {
        if (info == null) {
            return null;
        }
        if (info.totalMethodCount == 0 || info.totalLineCount == 0) {
            return null;
        }
        if (coverageDataManager.isSubCoverageActive()) {
            return info.coveredMethodCount + info.fullyCoveredLineCount + info.partiallyCoveredLineCount > 0 ? CoverageBundle.message((String)"coverage.view.text.covered", (Object[])new Object[0]) : null;
        }
        return JavaCoverageBundle.message("coverage.view.text.methods.covered", (int)((double)info.coveredMethodCount / (double)info.totalMethodCount * 100.0)) + ", " + CoverageBundle.message((String)"coverage.view.text.lines.covered", (Object[])new Object[]{(int)((double)(info.fullyCoveredLineCount + info.partiallyCoveredLineCount) / (double)info.totalLineCount * 100.0)});
    }

    @Nullable
    public PackageAnnotator.ClassCoverageInfo getClassCoverageInfo(@Nullable String classFQName) {
        if (classFQName == null) {
            return null;
        }
        return this.myClassCoverageInfos.get(classFQName);
    }

    @Nullable
    public PackageAnnotator.SummaryCoverageInfo getExtensionCoverageInfo(@Nullable PsiNamedElement value) {
        if (value == null) {
            return null;
        }
        PackageAnnotator.SummaryCoverageInfo cachedInfo = this.myExtensionCoverageInfos.get(value);
        if (cachedInfo != null) {
            return cachedInfo;
        }
        return (PackageAnnotator.SummaryCoverageInfo)JavaCoverageEngineExtension.EP_NAME.computeSafeIfAny(extension -> {
            PackageAnnotator.ClassCoverageInfo info = extension.getSummaryCoverageInfo(this, value);
            if (info != null) {
                this.myExtensionCoverageInfos.put((PsiElement)value, info);
                return info;
            }
            return null;
        });
    }
}

