/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageClassesEnumerator;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.target.java.JavaTargetParameter;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jacoco.agent.AgentJar;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JaCoCoCoverageRunner
extends JavaCoverageRunner {
    private static final Logger LOG = Logger.getInstance(JaCoCoCoverageRunner.class);

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        ProjectData data = new ProjectData();
        try {
            Project project;
            Project project2 = project = baseCoverageSuite instanceof BaseCoverageSuite ? baseCoverageSuite.getProject() : null;
            if (project != null) {
                RunConfigurationBase configuration = ((BaseCoverageSuite)baseCoverageSuite).getConfiguration();
                Module mainModule = configuration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule() : null;
                JaCoCoCoverageRunner.loadExecutionData(sessionDataFile, data, mainModule, project, baseCoverageSuite);
            }
        }
        catch (IOException e) {
            JaCoCoCoverageRunner.processError(sessionDataFile, e);
            return data;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return data;
        }
        return data;
    }

    private static void processError(@NotNull File sessionDataFile, IOException e) {
        String path = sessionDataFile.getAbsolutePath();
        if ("Invalid execution data file.".equals(e.getMessage())) {
            Notifications.Bus.notify((Notification)new Notification("Coverage", CoverageBundle.message((String)"coverage.error.loading.report", (Object[])new Object[0]), JavaCoverageBundle.message("coverage.error.jacoco.report.format", path), NotificationType.ERROR));
            LOG.info((Throwable)e);
        } else if (e.getMessage() != null && e.getMessage().startsWith("Unknown block type")) {
            Notifications.Bus.notify((Notification)new Notification("Coverage", CoverageBundle.message((String)"coverage.error.loading.report", (Object[])new Object[0]), JavaCoverageBundle.message("coverage.error.jacoco.report.corrupted", path), NotificationType.ERROR));
            LOG.info((Throwable)e);
        } else {
            LOG.error((Throwable)e);
        }
    }

    private static void loadExecutionData(@NotNull File sessionDataFile, ProjectData data, @Nullable Module mainModule, @NotNull Project project, CoverageSuite suite) throws IOException {
        ExecFileLoader loader = new ExecFileLoader();
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        JaCoCoCoverageRunner.loadReportToCoverageBuilder(coverageBuilder, sessionDataFile, mainModule, project, loader, (JavaCoverageSuite)suite);
        for (IClassCoverage classCoverage : coverageBuilder.getClasses()) {
            String className = classCoverage.getName();
            className = className.replace('\\', '.').replace('/', '.');
            ClassData classData = data.getOrCreateClassData(className);
            Collection methods = classCoverage.getMethods();
            LineData[] lines = new LineData[classCoverage.getLastLine() + 1];
            for (IMethodCoverage method : methods) {
                String desc = method.getName() + method.getDesc();
                int firstLine = method.getFirstLine();
                int lastLine = method.getLastLine();
                for (int i = firstLine; i <= lastLine; ++i) {
                    ILine methodLine = method.getLine(i);
                    int methodLineStatus = methodLine.getStatus();
                    if (methodLineStatus == 0) continue;
                    LineData lineData = new LineData(i, desc);
                    switch (methodLineStatus) {
                        case 2: {
                            lineData.setStatus((byte)2);
                        }
                        case 3: {
                            lineData.setStatus((byte)1);
                        }
                    }
                    lineData.setStatus((byte)0);
                    lineData.setHits(methodLineStatus == 2 || methodLineStatus == 3 ? 1 : 0);
                    ICounter branchCounter = methodLine.getBranchCounter();
                    int coveredCount = branchCounter.getCoveredCount();
                    for (int b = 0; b < branchCounter.getTotalCount(); ++b) {
                        JumpData jump = lineData.addJump(b);
                        if (coveredCount-- <= 0) continue;
                        jump.setTrueHits(1);
                        jump.setFalseHits(1);
                    }
                    classData.registerMethodSignature(lineData);
                    lineData.fillArrays();
                    lines[i] = lineData;
                }
            }
            classData.setLines(lines);
        }
    }

    private static void loadReportToCoverageBuilder(@NotNull CoverageBuilder coverageBuilder, @NotNull File sessionDataFile, @Nullable Module mainModule, @NotNull Project project, ExecFileLoader loader, final JavaCoverageSuite suite) throws IOException {
        loader.load(sessionDataFile);
        final Analyzer analyzer = new Analyzer(loader.getExecutionDataStore(), (ICoverageVisitor)coverageBuilder);
        Module[] modules = JaCoCoCoverageRunner.getModules(mainModule, project);
        CoverageDataManager manager = CoverageDataManager.getInstance((Project)project);
        for (Module module : modules) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = JavaCoverageClassesEnumerator.getRoots(manager, module, true)) {
                try {
                    final Path rootPath = Paths.get(new File(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)root.getUrl()))).toURI());
                    Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                            String vmClassName = rootPath.relativize(path).toString().replaceAll(StringUtil.escapeToRegexp((String)File.separator), ".");
                            if (suite.isClassFiltered(vmClassName = StringUtil.trimEnd((String)vmClassName, (String)".class"), suite.getExcludedClassNames()) || !suite.isPackageFiltered(StringUtil.getPackageName((String)vmClassName))) {
                                return FileVisitResult.CONTINUE;
                            }
                            File file = path.toFile();
                            try {
                                analyzer.analyzeAll(file);
                            }
                            catch (Exception e) {
                                LOG.info((Throwable)e);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
        }
    }

    private static Module[] getModules(@Nullable Module mainModule, @NotNull Project project) {
        Module[] modules;
        if (mainModule != null) {
            HashSet mainModuleWithDependencies = new HashSet();
            ReadAction.run(() -> ModuleUtilCore.getDependencies((Module)mainModule, (Set)mainModuleWithDependencies));
            modules = mainModuleWithDependencies.toArray(Module.EMPTY_ARRAY);
        } else {
            modules = ModuleManager.getInstance((Project)project).getModules();
        }
        return modules;
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String @Nullable [] patterns, SimpleJavaParameters parameters, boolean collectLineInfo, boolean isSampling) {
        this.appendCoverageArgument(sessionDataFilePath, patterns, null, parameters, collectLineInfo, isSampling, null, null);
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String @Nullable [] patterns, String[] excludePatterns, SimpleJavaParameters javaParameters, boolean collectLineInfo, boolean isSampling, String sourceMapPath, @Nullable Project project) {
        String path;
        try {
            path = AgentJar.extractToTempLocation().getAbsolutePath();
        }
        catch (IOException e) {
            return;
        }
        String agentPath = JaCoCoCoverageRunner.handleSpacesInAgentPath(path);
        if (agentPath == null) {
            return;
        }
        javaParameters.getTargetDependentParameters().asTargetParameters().add(request -> this.createArgumentTargetValue(agentPath, sessionDataFilePath, patterns, excludePatterns));
    }

    public JavaTargetParameter createArgumentTargetValue(String agentPath, String sessionDataFilePath, String @Nullable [] patterns, String[] excludePatterns) {
        HashSet uploadPaths = ContainerUtil.newHashSet((Object[])new String[]{agentPath});
        HashSet downloadPaths = ContainerUtil.newHashSet((Object[])new String[]{sessionDataFilePath});
        JavaTargetParameter.Builder builder = new JavaTargetParameter.Builder((Set)uploadPaths, (Set)downloadPaths);
        return JaCoCoCoverageRunner.doCreateCoverageArgument(builder, patterns, excludePatterns, sessionDataFilePath, agentPath);
    }

    @NotNull
    private static JavaTargetParameter doCreateCoverageArgument(@NotNull JavaTargetParameter.Builder builder, String @Nullable [] patterns, String[] excludePatterns, String sessionDataFilePath, String agentPath) {
        builder.fixed("-javaagent:").resolved(agentPath).fixed("=destfile=").resolved(sessionDataFilePath).fixed(",append=false");
        if (!ArrayUtil.isEmpty((Object[])patterns)) {
            builder.fixed(",includes=").fixed(StringUtil.join((String[])patterns, (String)":"));
        }
        if (!ArrayUtil.isEmpty((Object[])excludePatterns)) {
            builder.fixed(",excludes=").fixed(StringUtil.join((String[])excludePatterns, (String)":"));
        }
        return builder.build();
    }

    @Override
    public boolean isBranchInfoAvailable(boolean sampling) {
        return true;
    }

    @Override
    public void generateReport(CoverageSuitesBundle suite, Project project) throws IOException {
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        File targetDirectory = new File(settings.OUTPUT_DIRECTORY);
        RunConfigurationBase runConfiguration = suite.getRunConfiguration();
        Module module = runConfiguration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)runConfiguration).getConfigurationModule().getModule() : null;
        ExecFileLoader loader = new ExecFileLoader();
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        for (CoverageSuite aSuite : suite.getSuites()) {
            File coverageFile = new File(aSuite.getCoverageDataFileName());
            try {
                JaCoCoCoverageRunner.loadReportToCoverageBuilder(coverageBuilder, coverageFile, module, project, loader, (JavaCoverageSuite)suite.getSuites()[0]);
            }
            catch (IOException e) {
                JaCoCoCoverageRunner.processError(coverageFile, e);
            }
        }
        IBundleCoverage bundleCoverage = coverageBuilder.getBundle(suite.getPresentableName());
        IReportVisitor visitor = new HTMLFormatter().createVisitor((IMultiReportOutput)new FileMultiReportOutput(targetDirectory));
        visitor.visitInfo(loader.getSessionInfoStore().getInfos(), loader.getExecutionDataStore().getContents());
        int tabWidth = 4;
        MultiSourceFileLocator multiSourceFileLocator = new MultiSourceFileLocator(tabWidth);
        for (Module srcModule : JaCoCoCoverageRunner.getModules(module, project)) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)srcModule).getSourceRoots(true)) {
                multiSourceFileLocator.add((ISourceFileLocator)new DirectorySourceFileLocator(VfsUtilCore.virtualToIoFile((VirtualFile)root), StandardCharsets.UTF_8.name(), tabWidth));
            }
        }
        visitor.visitBundle(bundleCoverage, (ISourceFileLocator)multiSourceFileLocator);
        visitor.visitEnd();
    }

    @NotNull
    public String getPresentableName() {
        return "JaCoCo";
    }

    @NotNull
    public String getId() {
        return "jacoco";
    }

    @NotNull
    public String getDataFileExtension() {
        return "exec";
    }

    @Override
    public boolean shouldProcessUnloadedClasses() {
        return false;
    }
}

