/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.target.java.JavaTargetParameter;
import com.intellij.execution.target.java.TargetPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IDEACoverageRunner
extends JavaCoverageRunner {
    private static final Logger LOG = Logger.getInstance(IDEACoverageRunner.class);

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite coverageSuite) {
        ProjectData projectData = ProjectDataLoader.load((File)sessionDataFile);
        File sourceMapFile = new File(JavaCoverageEnabledConfiguration.getSourceMapPath(sessionDataFile.getPath()));
        if (sourceMapFile.exists()) {
            try {
                SaveHook.loadAndApplySourceMap((ProjectData)projectData, (File)sourceMapFile);
            }
            catch (IOException e) {
                LOG.warn("Error reading source map associated with coverage data", (Throwable)e);
            }
        }
        return projectData;
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String @Nullable [] patterns, SimpleJavaParameters parameters, boolean collectLineInfo, boolean isSampling) {
        this.appendCoverageArgument(sessionDataFilePath, patterns, null, parameters, collectLineInfo, isSampling, null, null);
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String[] patterns, String[] excludePatterns, SimpleJavaParameters javaParameters, boolean collectLineInfo, boolean isSampling, @Nullable String sourceMapPath, @Nullable Project project) {
        JavaCoverageOptionsProvider optionsProvider;
        String agentPath = IDEACoverageRunner.handleSpacesInAgentPath(PathUtil.getJarPathForClass(ProjectData.class));
        if (agentPath == null) {
            return;
        }
        String[] excludeAnnotations = IDEACoverageRunner.getExcludeAnnotations(project);
        List targetParameters = javaParameters.getTargetDependentParameters().asTargetParameters();
        targetParameters.add(request -> IDEACoverageRunner.createArgumentTargetParameter(agentPath, sessionDataFilePath, patterns, excludePatterns, excludeAnnotations, collectLineInfo, isSampling, sourceMapPath));
        if (!Registry.is((String)"idea.coverage.thread.safe.enabled")) {
            targetParameters.add(request -> JavaTargetParameter.fixed((String)"-Didea.coverage.thread-safe.enabled=false"));
        }
        if (isSampling && Registry.is((String)"idea.coverage.new.sampling.enabled")) {
            targetParameters.add(request -> JavaTargetParameter.fixed((String)"-Didea.new.sampling.coverage=true"));
        }
        if (!isSampling && Registry.is((String)"idea.coverage.new.tracing.enabled")) {
            targetParameters.add(request -> JavaTargetParameter.fixed((String)"-Didea.new.tracing.coverage=true"));
            if (collectLineInfo && !Registry.is((String)"idea.coverage.new.test.tracking.enabled")) {
                targetParameters.add(request -> JavaTargetParameter.fixed((String)"-Didea.new.test.tracking.coverage=false"));
            }
        }
        if (project != null && (optionsProvider = JavaCoverageOptionsProvider.getInstance(project)).ignoreEmptyPrivateConstructors()) {
            targetParameters.add(request -> JavaTargetParameter.fixed((String)"-Dcoverage.ignore.private.constructor.util.class=true"));
        }
    }

    @Nullable
    private static JavaTargetParameter createArgumentTargetParameter(String agentPath, String sessionDataFilePath, String @Nullable [] patterns, String[] excludePatterns, String[] excludeAnnotations, boolean collectLineInfo, boolean isSampling, String sourceMapPath) {
        try {
            File tempFile = IDEACoverageRunner.createTempFile();
            tempFile.deleteOnExit();
            Ref writeOnceRef = new Ref((Object)false);
            String tempFilePath = tempFile.getAbsolutePath();
            TargetPaths targetPaths = TargetPaths.ordered(builder -> {
                builder.download(sessionDataFilePath, __ -> {
                    IDEACoverageRunner.createFileOrClearExisting(sessionDataFilePath);
                    return Unit.INSTANCE;
                }, targetSessionDataPath -> {
                    if (!((Boolean)writeOnceRef.get()).booleanValue()) {
                        try {
                            IDEACoverageRunner.writeOptionsToFile(tempFile, targetSessionDataPath, patterns, excludePatterns, excludeAnnotations, collectLineInfo, isSampling, sourceMapPath);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            writeOnceRef.set((Object)true);
                        }
                    }
                    return Unit.INSTANCE;
                }).upload(agentPath, __ -> Unit.INSTANCE, __ -> Unit.INSTANCE).upload(tempFilePath, __ -> Unit.INSTANCE, __ -> Unit.INSTANCE);
                return Unit.INSTANCE;
            });
            return new JavaTargetParameter.Builder(targetPaths).fixed("-javaagent:").resolved(agentPath).fixed("=").resolved(tempFilePath).build();
        }
        catch (IOException e) {
            LOG.info("Coverage was not enabled", (Throwable)e);
            return null;
        }
    }

    private static void createFileOrClearExisting(@NotNull String sessionDataFilePath) {
        File file = new File(sessionDataFilePath);
        FileUtil.createIfDoesntExist((File)file);
        try {
            new FileOutputStream(file).close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void writeOptionsToFile(File file, String sessionDataFilePath, String @Nullable [] patterns, String[] excludePatterns, String[] excludeAnnotations, boolean collectLineInfo, boolean isSampling, String sourceMapPath) throws IOException {
        IDEACoverageRunner.write2file(file, sessionDataFilePath);
        IDEACoverageRunner.write2file(file, String.valueOf(collectLineInfo));
        IDEACoverageRunner.write2file(file, Boolean.FALSE.toString());
        IDEACoverageRunner.write2file(file, Boolean.FALSE.toString());
        IDEACoverageRunner.write2file(file, String.valueOf(isSampling));
        if (sourceMapPath != null) {
            IDEACoverageRunner.write2file(file, Boolean.TRUE.toString());
            IDEACoverageRunner.write2file(file, sourceMapPath);
        }
        if (patterns != null) {
            IDEACoverageRunner.writePatterns(file, patterns);
        }
        if (excludePatterns != null) {
            IDEACoverageRunner.write2file(file, "-exclude");
            IDEACoverageRunner.writePatterns(file, excludePatterns);
        }
        if (!ArrayUtil.isEmpty((Object[])excludeAnnotations)) {
            IDEACoverageRunner.write2file(file, "-excludeAnnotations");
            IDEACoverageRunner.writePatterns(file, excludeAnnotations);
        }
    }

    private static String[] convertToPatterns(String[] patterns) {
        String[] result = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            Object coveragePattern = patterns[i];
            if (!((String)(coveragePattern = ((String)coveragePattern).replace("$", "\\$").replace(".", "\\.").replaceAll("\\*", ".*"))).endsWith(".*")) {
                coveragePattern = (String)coveragePattern + "(\\$.*)*";
            }
            result[i] = coveragePattern;
        }
        return result;
    }

    private static void writePatterns(File tempFile, String[] patterns) throws IOException {
        for (String coveragePattern : IDEACoverageRunner.convertToPatterns(patterns)) {
            IDEACoverageRunner.write2file(tempFile, coveragePattern);
        }
    }

    private static String[] getExcludeAnnotations(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        JavaCoverageOptionsProvider optionsProvider = JavaCoverageOptionsProvider.getInstance(project);
        return ArrayUtil.toStringArray(optionsProvider.getExcludeAnnotationPatterns());
    }

    @NotNull
    public String getPresentableName() {
        return "IntelliJ IDEA";
    }

    @NotNull
    public String getId() {
        return "idea";
    }

    @NotNull
    public String getDataFileExtension() {
        return "ic";
    }

    public boolean isCoverageByTestApplicable() {
        return true;
    }

    static void setExcludeAnnotations(Project project, ProjectData projectData) {
        JavaCoverageOptionsProvider optionsProvider = JavaCoverageOptionsProvider.getInstance(project);
        try {
            String[] patterns = ArrayUtil.toStringArray(optionsProvider.getExcludeAnnotationPatterns());
            String[] regexps = IDEACoverageRunner.convertToPatterns(patterns);
            projectData.setAnnotationsToIgnore(Stream.of(regexps).map(s -> Pattern.compile(s)).toList());
        }
        catch (PatternSyntaxException e) {
            LOG.info("Failed to collect exclude annotation patterns", (Throwable)e);
        }
    }
}

