/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u001b\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004H\u0007\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J4\u0010\u001b\u001a\u00020\u001c2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0012\b\u0002\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\u001eH\u0007JD\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0010\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\u001eH\u0002J \u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\u001eH\u0002J \u0010(\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020)2\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\u001eH\u0002J\u0011\u0010*\u001a\u00020\u0011*\u00020+H\u0000\u00a2\u0006\u0002\b,J\f\u0010-\u001a\u00020\u0011*\u00020\u000eH\u0002J\f\u0010.\u001a\u00020\u0011*\u00020\u000eH\u0002R(\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014 \u0007*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0002\b\u00060\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0013\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/intellij/plugins/markdown/util/MarkdownPsiStructureUtil;", "", "()V", "HEADER_ORDER", "", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "[Lcom/intellij/psi/tree/TokenSet;", "IGNORED_CONTAINERS", "PRESENTABLE_CONTAINERS", "PRESENTABLE_TYPES", "TRANSPARENT_CONTAINERS", "findFirstMarkdownChild", "Lcom/intellij/psi/PsiElement;", "element", "isSameLevelOrHigher", "", "left", "right", "isSimpleNestedList", "itemChildren", "([Lcom/intellij/psi/PsiElement;)Z", "obtainHeaderLevel", "", "headerType", "Lcom/intellij/psi/tree/IElementType;", "processContainer", "", "consumer", "Lcom/intellij/util/Consumer;", "nextHeaderConsumer", "processHeader", "container", "sameLevelRestriction", "from", "resultConsumer", "processList", "list", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "processListItem", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "isTopLevel", "Lcom/intellij/lang/ASTNode;", "isTopLevel$intellij_markdown_core", "isTransparentInFull", "isTransparentInPartial", "intellij.markdown.core"})
public final class MarkdownPsiStructureUtil {
    @NotNull
    public static final MarkdownPsiStructureUtil INSTANCE = new MarkdownPsiStructureUtil();
    @JvmField
    @NotNull
    public static final TokenSet PRESENTABLE_TYPES = MarkdownTokenTypeSets.HEADERS;
    @JvmField
    @NotNull
    public static final TokenSet TRANSPARENT_CONTAINERS;
    @NotNull
    private static final TokenSet PRESENTABLE_CONTAINERS;
    @NotNull
    private static final TokenSet IGNORED_CONTAINERS;
    @NotNull
    private static final TokenSet[] HEADER_ORDER;

    private MarkdownPsiStructureUtil() {
    }

    public final boolean isTopLevel$intellij_markdown_core(@NotNull ASTNode $this$isTopLevel) {
        ASTNode aSTNode = $this$isTopLevel.getTreeParent();
        return aSTNode != null ? AstUtilsKt.hasType(aSTNode, MarkdownElementTypes.MARKDOWN_FILE) : false;
    }

    @JvmStatic
    public static final boolean isSimpleNestedList(@NotNull PsiElement[] itemChildren) {
        if (itemChildren.length != 2) {
            return false;
        }
        PsiElement firstItem = itemChildren[0];
        PsiElement secondItem = itemChildren[1];
        return PsiUtilsKt.hasType(firstItem, MarkdownElementTypes.PARAGRAPH) && secondItem instanceof MarkdownList;
    }

    @JvmStatic
    @JvmOverloads
    public static final void processContainer(@Nullable PsiElement element2, @NotNull Consumer<PsiElement> consumer, @Nullable Consumer<PsiElement> nextHeaderConsumer) {
        PsiElement structureContainer;
        if (element2 == null) {
            return;
        }
        PsiElement psiElement = structureContainer = element2 instanceof MarkdownFile ? INSTANCE.findFirstMarkdownChild(element2) : PsiUtilsKt.parentOfType(element2, true, TRANSPARENT_CONTAINERS);
        if (structureContainer == null) {
            return;
        }
        boolean areListsVisible = Registry.is((String)"markdown.structure.view.list.visibility");
        if (element2 instanceof MarkdownHeader) {
            INSTANCE.processHeader(structureContainer, element2, element2, consumer, nextHeaderConsumer);
        } else if (element2 instanceof MarkdownList && areListsVisible) {
            INSTANCE.processList((MarkdownList)element2, consumer);
        } else if (element2 instanceof MarkdownListItem && areListsVisible) {
            if (!((MarkdownListItem)element2).hasTrivialChildren()) {
                INSTANCE.processListItem((MarkdownListItem)element2, consumer);
            }
        } else {
            INSTANCE.processHeader(structureContainer, null, null, consumer, nextHeaderConsumer);
        }
    }

    public static /* synthetic */ void processContainer$default(PsiElement psiElement, Consumer consumer, Consumer consumer2, int n, Object object) {
        if ((n & 4) != 0) {
            consumer2 = null;
        }
        MarkdownPsiStructureUtil.processContainer(psiElement, (Consumer<PsiElement>)consumer, (Consumer<PsiElement>)consumer2);
    }

    private final PsiElement findFirstMarkdownChild(PsiElement element2) {
        Object v0;
        block1: {
            Sequence<PsiElement> $this$firstOrNull$iv = PsiUtilsKt.children(element2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!MarkdownLanguageUtils.INSTANCE.isMarkdownLanguage(it.getLanguage())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void processHeader(PsiElement container, PsiElement sameLevelRestriction, PsiElement from, Consumer<PsiElement> resultConsumer, Consumer<PsiElement> nextHeaderConsumer) {
        block7: {
            PsiElement startElement = from == null ? container.getFirstChild() : from.getNextSibling();
            PsiElement maxContentLevel = null;
            PsiElement psiElement = startElement;
            Sequence sequence = psiElement != null ? PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true) : null;
            if (sequence == null) {
                sequence = SequencesKt.emptySequence();
            }
            for (PsiElement element2 : sequence) {
                if (this.isTransparentInPartial(element2) && maxContentLevel == null) {
                    this.processHeader(element2, null, null, resultConsumer, nextHeaderConsumer);
                    continue;
                }
                if (this.isTransparentInFull(element2) && maxContentLevel == null) {
                    if (!IGNORED_CONTAINERS.contains(PsiTreeUtilKt.getElementType((PsiElement)container)) && PRESENTABLE_CONTAINERS.contains(PsiTreeUtilKt.getElementType((PsiElement)element2))) {
                        resultConsumer.consume((Object)element2);
                    }
                    this.processHeader(element2, null, null, resultConsumer, nextHeaderConsumer);
                    continue;
                }
                if (!(element2 instanceof MarkdownHeader)) continue;
                if (sameLevelRestriction != null && this.isSameLevelOrHigher(element2, sameLevelRestriction)) {
                    Consumer<PsiElement> consumer = nextHeaderConsumer;
                    if (consumer != null) {
                        consumer.consume((Object)element2);
                    }
                    return;
                }
                if (maxContentLevel != null && !this.isSameLevelOrHigher(element2, maxContentLevel)) continue;
                maxContentLevel = element2;
                if (!PRESENTABLE_TYPES.contains((IElementType)((MarkdownHeader)element2).getElementType())) continue;
                resultConsumer.consume((Object)element2);
            }
            Consumer<PsiElement> consumer = nextHeaderConsumer;
            if (consumer == null) break block7;
            consumer.consume(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void processList(MarkdownList list, Consumer<? super PsiElement> resultConsumer) {
        for (PsiElement child : PsiUtilsKt.children((PsiElement)list)) {
            children = child.getChildren();
            v0 = (PsiElement)ArraysKt.firstOrNull((Object[])children);
            if (MarkdownPsiStructureUtil.PRESENTABLE_TYPES.contains((IElementType)(v0 != null ? PsiTreeUtilKt.getElementType((PsiElement)v0) : null))) ** GOTO lbl-1000
            v1 = (PsiElement)ArraysKt.singleOrNull((Object[])children);
            if (MarkdownPsiStructureUtil.PRESENTABLE_CONTAINERS.contains((IElementType)(v1 != null ? PsiTreeUtilKt.getElementType((PsiElement)v1) : null))) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            containerIsFirst = v2;
            if (containerIsFirst) {
                resultConsumer.consume(ArraysKt.first((Object[])children));
                continue;
            }
            if (MarkdownPsiStructureUtil.isSimpleNestedList((PsiElement[])children)) {
                resultConsumer.consume(children[1]);
                continue;
            }
            if (!(child instanceof MarkdownListItem)) continue;
            resultConsumer.consume((Object)child);
        }
    }

    private final void processListItem(MarkdownListItem from, Consumer<? super PsiElement> resultConsumer) {
        for (PsiElement child2 : PsiUtilsKt.children((PsiElement)from)) {
            if (PRESENTABLE_TYPES.contains(PsiTreeUtilKt.getElementType((PsiElement)child2))) {
                resultConsumer.consume((Object)child2);
                break;
            }
            if (!PRESENTABLE_CONTAINERS.contains(PsiTreeUtilKt.getElementType((PsiElement)child2))) continue;
            resultConsumer.consume((Object)child2);
        }
    }

    private final boolean isTransparentInFull(PsiElement $this$isTransparentInFull) {
        if (!Registry.is((String)"markdown.structure.view.list.visibility")) {
            return false;
        }
        return TRANSPARENT_CONTAINERS.contains(PsiTreeUtilKt.getElementType((PsiElement)$this$isTransparentInFull)) && !($this$isTransparentInFull instanceof MarkdownListItem);
    }

    private final boolean isTransparentInPartial(PsiElement $this$isTransparentInPartial) {
        return !Registry.is((String)"markdown.structure.view.list.visibility") && TRANSPARENT_CONTAINERS.contains(PsiTreeUtilKt.getElementType((PsiElement)$this$isTransparentInPartial));
    }

    private final boolean isSameLevelOrHigher(PsiElement left, PsiElement right) {
        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)left);
        Intrinsics.checkNotNull((Object)iElementType);
        int n = this.obtainHeaderLevel(iElementType);
        IElementType iElementType2 = PsiTreeUtilKt.getElementType((PsiElement)right);
        Intrinsics.checkNotNull((Object)iElementType2);
        return n <= this.obtainHeaderLevel(iElementType2);
    }

    /*
     * WARNING - void declaration
     */
    private final int obtainHeaderLevel(IElementType headerType) {
        void var2_8;
        int n;
        block1: {
            TokenSet[] $this$indexOfFirst$iv = HEADER_ORDER;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                TokenSet it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!it.contains(headerType)) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int index = n;
        return index == -1 ? Integer.MAX_VALUE : var2_8;
    }

    @JvmStatic
    @JvmOverloads
    public static final void processContainer(@Nullable PsiElement element2, @NotNull Consumer<PsiElement> consumer) {
        MarkdownPsiStructureUtil.processContainer$default(element2, consumer, null, 4, null);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{MarkdownElementTypes.MARKDOWN_FILE, MarkdownElementTypes.UNORDERED_LIST, MarkdownElementTypes.ORDERED_LIST, MarkdownElementTypes.LIST_ITEM, MarkdownElementTypes.BLOCK_QUOTE};
        TRANSPARENT_CONTAINERS = TokenSet.create((IElementType[])iElementTypeArray);
        iElementTypeArray = new IElementType[]{MarkdownElementTypes.UNORDERED_LIST, MarkdownElementTypes.ORDERED_LIST};
        PRESENTABLE_CONTAINERS = TokenSet.create((IElementType[])iElementTypeArray);
        iElementTypeArray = new IElementType[]{MarkdownElementTypes.BLOCK_QUOTE};
        IGNORED_CONTAINERS = TokenSet.create((IElementType[])iElementTypeArray);
        iElementTypeArray = new TokenSet[7];
        IElementType[] iElementTypeArray2 = new IElementType[]{(IElementType)MarkdownElementTypes.MARKDOWN_FILE_ELEMENT_TYPE};
        iElementTypeArray[0] = TokenSet.create((IElementType[])iElementTypeArray2);
        iElementTypeArray[1] = MarkdownTokenTypeSets.HEADER_LEVEL_1_SET;
        iElementTypeArray[2] = MarkdownTokenTypeSets.HEADER_LEVEL_2_SET;
        iElementTypeArray[3] = MarkdownTokenTypeSets.HEADER_LEVEL_3_SET;
        iElementTypeArray[4] = MarkdownTokenTypeSets.HEADER_LEVEL_4_SET;
        iElementTypeArray[5] = MarkdownTokenTypeSets.HEADER_LEVEL_5_SET;
        iElementTypeArray[6] = MarkdownTokenTypeSets.HEADER_LEVEL_6_SET;
        HEADER_ORDER = iElementTypeArray;
    }
}

