/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.split;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.SplitEditorToolbar;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBSplitter;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class SplitFileEditor<E1 extends FileEditor, E2 extends FileEditor>
extends UserDataHolderBase
implements FileEditor {
    public static final Key<SplitFileEditor> PARENT_SPLIT_KEY = Key.create((String)"parentSplit");
    private static final String MY_PROPORTION_KEY = "SplitFileEditor.Proportion";
    @NotNull
    protected final E1 myMainEditor;
    @NotNull
    protected final E2 mySecondEditor;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private TextEditorWithPreview.Layout mySplitEditorLayout = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().getSplitEditorLayout();
    private boolean myVerticalSplitOption = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isVerticalSplit();
    @NotNull
    private final MyListenersMultimap myListenersGenerator = new MyListenersMultimap();
    private SplitEditorToolbar myToolbarWrapper;
    private JBSplitter mySplitter;

    public SplitFileEditor(@NotNull E1 mainEditor, @NotNull E2 secondEditor) {
        this.myMainEditor = mainEditor;
        this.mySecondEditor = secondEditor;
        this.adjustDefaultLayout(mainEditor);
        this.myComponent = this.createComponent();
        if (this.myMainEditor instanceof TextEditor) {
            this.myMainEditor.putUserData(PARENT_SPLIT_KEY, (Object)this);
        }
        if (this.mySecondEditor instanceof TextEditor) {
            this.mySecondEditor.putUserData(PARENT_SPLIT_KEY, (Object)this);
        }
        MarkdownApplicationSettings.SettingsChangedListener settingsChangedListener = new MarkdownApplicationSettings.SettingsChangedListener(){

            @Override
            public void beforeSettingsChanged(@NotNull MarkdownApplicationSettings newSettings) {
                TextEditorWithPreview.Layout oldSplitEditorLayout = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().getSplitEditorLayout();
                boolean oldVerticalSplitOption = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isVerticalSplit();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (oldSplitEditorLayout == SplitFileEditor.this.mySplitEditorLayout) {
                        SplitFileEditor.this.triggerLayoutChange(newSettings.getMarkdownPreviewSettings().getSplitEditorLayout(), false);
                    }
                    if (oldVerticalSplitOption == SplitFileEditor.this.myVerticalSplitOption) {
                        SplitFileEditor.this.triggerSplitOrientationChange(newSettings.getMarkdownPreviewSettings().isVerticalSplit());
                    }
                });
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(MarkdownApplicationSettings.SettingsChangedListener.TOPIC, (Object)settingsChangedListener);
    }

    private void adjustDefaultLayout(E1 editor2) {
    }

    private void triggerSplitOrientationChange(boolean isVerticalSplit) {
        if (this.myVerticalSplitOption == isVerticalSplit) {
            return;
        }
        this.myVerticalSplitOption = isVerticalSplit;
        this.myToolbarWrapper.refresh();
        this.mySplitter.setOrientation(!this.myVerticalSplitOption);
        this.myComponent.repaint();
    }

    @NotNull
    private JComponent createComponent() {
        this.mySplitter = new JBSplitter(!MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isVerticalSplit(), 0.5f, 0.15f, 0.85f);
        this.mySplitter.setSplitterProportionKey(MY_PROPORTION_KEY);
        this.mySplitter.setFirstComponent(this.myMainEditor.getComponent());
        this.mySplitter.setSecondComponent(this.mySecondEditor.getComponent());
        this.mySplitter.setDividerWidth(3);
        this.myToolbarWrapper = SplitFileEditor.createMarkdownToolbarWrapper((JComponent)this.mySplitter);
        JPanel result2 = new JPanel(new BorderLayout());
        result2.add((Component)this.myToolbarWrapper, "North");
        result2.add((Component)this.mySplitter, "Center");
        this.adjustEditorsVisibility();
        return result2;
    }

    @NotNull
    private static SplitEditorToolbar createMarkdownToolbarWrapper(@NotNull JComponent targetComponentForActions) {
        ActionToolbar leftToolbar = SplitFileEditor.createToolbarFromGroupId("Markdown.Toolbar.Left");
        leftToolbar.setTargetComponent(targetComponentForActions);
        leftToolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbar rightToolbar = SplitFileEditor.createToolbarFromGroupId("Markdown.Toolbar.Right");
        rightToolbar.setTargetComponent(targetComponentForActions);
        rightToolbar.setReservePlaceAutoPopupIcon(false);
        return new SplitEditorToolbar(leftToolbar, rightToolbar);
    }

    @NotNull
    private static ActionToolbar createToolbarFromGroupId(@NotNull String groupId) {
        ActionManager actionManager = ActionManager.getInstance();
        if (!actionManager.isGroup(groupId)) {
            throw new IllegalStateException(groupId + " should have been a group");
        }
        ActionGroup group = (ActionGroup)actionManager.getAction(groupId);
        ActionToolbarImpl editorToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", group, true);
        editorToolbar.setBorder((Border)new JBEmptyBorder(0, 2, 0, 2));
        return editorToolbar;
    }

    public void triggerLayoutChange(@NotNull TextEditorWithPreview.Layout newLayout, boolean requestFocus) {
        if (this.mySplitEditorLayout == newLayout) {
            return;
        }
        this.mySplitEditorLayout = newLayout;
        this.invalidateLayout(requestFocus);
    }

    private void invalidateLayout(boolean requestFocus) {
        this.adjustEditorsVisibility();
        this.myToolbarWrapper.refresh();
        this.myComponent.repaint();
        if (!requestFocus) {
            return;
        }
        JComponent focusComponent = this.getPreferredFocusedComponent();
        if (focusComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusComponent).requestFocus((Component)focusComponent, true);
        }
    }

    private void adjustEditorsVisibility() {
    }

    @NotNull
    public E1 getMainEditor() {
        return this.myMainEditor;
    }

    @NotNull
    public E2 getSecondEditor() {
        return this.mySecondEditor;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return new MyFileEditorState(this.mySplitEditorLayout.name(), this.myMainEditor.getState(level), this.mySecondEditor.getState(level));
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return this.myMainEditor.isModified() || this.mySecondEditor.isModified();
    }

    public boolean isValid() {
        return this.myMainEditor.isValid() && this.mySecondEditor.isValid();
    }

    public void selectNotify() {
        this.myMainEditor.selectNotify();
        this.mySecondEditor.selectNotify();
    }

    public void deselectNotify() {
        this.myMainEditor.deselectNotify();
        this.mySecondEditor.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        this.myMainEditor.addPropertyChangeListener(listener);
        this.mySecondEditor.addPropertyChangeListener(listener);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.addListenerAndGetDelegate(listener);
        this.myMainEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
        this.mySecondEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        this.myMainEditor.removePropertyChangeListener(listener);
        this.mySecondEditor.removePropertyChangeListener(listener);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.removeListenerAndGetDelegate(listener);
        if (delegate != null) {
            this.myMainEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
            this.mySecondEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myMainEditor.getBackgroundHighlighter();
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.myMainEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.myMainEditor.getStructureViewBuilder();
    }

    public void dispose() {
        Disposer.dispose(this.myMainEditor);
        Disposer.dispose(this.mySecondEditor);
    }

    private class MyListenersMultimap {
        private final Map<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>> myMap = new HashMap<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>>();

        private MyListenersMultimap() {
        }

        @NotNull
        public DoublingEventListenerDelegate addListenerAndGetDelegate(@NotNull PropertyChangeListener listener) {
            if (!this.myMap.containsKey(listener)) {
                this.myMap.put(listener, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)1, (Object)new DoublingEventListenerDelegate(listener)));
            } else {
                Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener);
                this.myMap.put(listener, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() + 1), (Object)((DoublingEventListenerDelegate)oldPair.getSecond())));
            }
            return (DoublingEventListenerDelegate)this.myMap.get(listener).getSecond();
        }

        @Nullable
        public DoublingEventListenerDelegate removeListenerAndGetDelegate(@NotNull PropertyChangeListener listener) {
            Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener);
            if (oldPair == null) {
                return null;
            }
            if ((Integer)oldPair.getFirst() == 1) {
                this.myMap.remove(listener);
            } else {
                this.myMap.put(listener, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() - 1), (Object)((DoublingEventListenerDelegate)oldPair.getSecond())));
            }
            return (DoublingEventListenerDelegate)oldPair.getSecond();
        }
    }

    public static class MyFileEditorState
    implements FileEditorState {
        @Nullable
        private final String mySplitLayout;
        @Nullable
        private final FileEditorState myFirstState;
        @Nullable
        private final FileEditorState mySecondState;

        public MyFileEditorState(@Nullable String splitLayout, @Nullable FileEditorState firstState, @Nullable FileEditorState secondState) {
            this.mySplitLayout = splitLayout;
            this.myFirstState = firstState;
            this.mySecondState = secondState;
        }

        @Nullable
        public String getSplitLayout() {
            return this.mySplitLayout;
        }

        @Nullable
        public FileEditorState getFirstState() {
            return this.myFirstState;
        }

        @Nullable
        public FileEditorState getSecondState() {
            return this.mySecondState;
        }

        public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
            return !(!(otherState instanceof MyFileEditorState) || this.myFirstState != null && !this.myFirstState.canBeMergedWith(((MyFileEditorState)otherState).myFirstState, level) || this.mySecondState != null && !this.mySecondState.canBeMergedWith(((MyFileEditorState)otherState).mySecondState, level));
        }
    }

    private final class DoublingEventListenerDelegate
    implements PropertyChangeListener {
        @NotNull
        private final PropertyChangeListener myDelegate;

        private DoublingEventListenerDelegate(PropertyChangeListener delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.myDelegate.propertyChange(new PropertyChangeEvent((Object)SplitFileEditor.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }
    }

    @Deprecated
    public static enum SplitEditorLayout {
        FIRST(true, false, MarkdownBundle.message("markdown.layout.editor.only", new Object[0])),
        SECOND(false, true, MarkdownBundle.message("markdown.layout.preview.only", new Object[0])),
        SPLIT(true, true, MarkdownBundle.message("markdown.layout.editor.and.preview", new Object[0]));

        public final boolean showFirst;
        public final boolean showSecond;
        public final String presentationName;

        private SplitEditorLayout(boolean showFirst, boolean showSecond, String presentationName) {
            this.showFirst = showFirst;
            this.showSecond = showSecond;
            this.presentationName = presentationName;
        }

        public String getPresentationText() {
            return StringUtil.capitalize((String)this.presentationName);
        }

        public String toString() {
            return MarkdownBundle.message("markdown.layout.show", this.presentationName);
        }
    }
}

