/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef.impl;

import com.intellij.openapi.diagnostic.Logger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.ui.preview.html.links.IntelliJImageGeneratingProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0002\"#B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0003J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u001e\u001a\u00020\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/IncrementalDOMBuilder;", "", "html", "", "basePath", "Ljava/nio/file/Path;", "fileSchemeResourceProcessor", "Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/IncrementalDOMBuilder$FileSchemeResourceProcessingStrategy;", "(Ljava/lang/String;Ljava/nio/file/Path;Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/IncrementalDOMBuilder$FileSchemeResourceProcessingStrategy;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "document", "Lorg/jsoup/nodes/Document;", "kotlin.jvm.PlatformType", "actuallyProcessImageNode", "", "node", "Lorg/jsoup/nodes/Node;", "closeTag", "encodeArgument", "argument", "ensureCorrectTag", "name", "generateDomBuildCalls", "generateRenderClosure", "openTag", "preprocessNode", "shouldPreprocessImageNode", "", "textElement", "getter", "Lkotlin/Function0;", "traverse", "Companion", "FileSchemeResourceProcessingStrategy", "intellij.markdown.core"})
@ApiStatus.Internal
public final class IncrementalDOMBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path basePath;
    @Nullable
    private final FileSchemeResourceProcessingStrategy fileSchemeResourceProcessor;
    private final Document document;
    @NotNull
    private final StringBuilder builder;

    public IncrementalDOMBuilder(@NotNull String html2, @Nullable Path basePath, @Nullable FileSchemeResourceProcessingStrategy fileSchemeResourceProcessor) {
        this.basePath = basePath;
        this.fileSchemeResourceProcessor = fileSchemeResourceProcessor;
        this.document = Jsoup.parse((String)html2);
        this.builder = new StringBuilder();
    }

    public /* synthetic */ IncrementalDOMBuilder(String string, Path path, FileSchemeResourceProcessingStrategy fileSchemeResourceProcessingStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fileSchemeResourceProcessingStrategy = null;
        }
        this(string, path, fileSchemeResourceProcessingStrategy);
    }

    @NotNull
    public final String generateRenderClosure() {
        return "\n      () => {\n        const o = (tag, ...attrs) => IncrementalDOM.elementOpen(tag, null, null, ...attrs.map(decodeURIComponent));\n        const t = content => IncrementalDOM.text(decodeURIComponent(content));\n        const c = IncrementalDOM.elementClose;\n        " + this.generateDomBuildCalls() + "\n      }\n    ";
    }

    @NotNull
    public final String generateDomBuildCalls() {
        this.traverse((Node)this.document.body());
        return this.builder.toString();
    }

    private final String ensureCorrectTag(String name) {
        return Intrinsics.areEqual((Object)name, (Object)"body") ? "div" : name;
    }

    private final String encodeArgument(String argument) {
        return StringsKt.replace$default((String)URLEncoder.encode(argument, Charsets.UTF_8), (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }

    private final void openTag(Node node) {
        StringBuilder $this$openTag_u24lambda_u240 = this.builder;
        boolean bl = false;
        $this$openTag_u24lambda_u240.append("o('");
        $this$openTag_u24lambda_u240.append(this.ensureCorrectTag(node.nodeName()));
        $this$openTag_u24lambda_u240.append("'");
        for (Attribute attribute : node.attributes()) {
            $this$openTag_u24lambda_u240.append(",'");
            $this$openTag_u24lambda_u240.append(attribute.getKey());
            $this$openTag_u24lambda_u240.append('\'');
            String value = attribute.getValue();
            if (value == null) continue;
            $this$openTag_u24lambda_u240.append(",'");
            $this$openTag_u24lambda_u240.append(this.encodeArgument(value));
            $this$openTag_u24lambda_u240.append("'");
        }
        $this$openTag_u24lambda_u240.append(");");
    }

    private final void closeTag(Node node) {
        StringBuilder $this$closeTag_u24lambda_u241 = this.builder;
        boolean bl = false;
        $this$closeTag_u24lambda_u241.append("c('");
        $this$closeTag_u24lambda_u241.append(this.ensureCorrectTag(node.nodeName()));
        $this$closeTag_u24lambda_u241.append("');");
    }

    private final void textElement(Function0<String> getter) {
        StringBuilder $this$textElement_u24lambda_u242 = this.builder;
        boolean bl = false;
        $this$textElement_u24lambda_u242.append("t(`");
        $this$textElement_u24lambda_u242.append(this.encodeArgument((String)getter.invoke()));
        $this$textElement_u24lambda_u242.append("`);");
    }

    private final Node preprocessNode(Node node) {
        if (this.fileSchemeResourceProcessor != null && this.basePath != null && this.shouldPreprocessImageNode(node)) {
            try {
                this.actuallyProcessImageNode(node, this.basePath, this.fileSchemeResourceProcessor);
            }
            catch (Throwable exception) {
                String originalUrlValue = node.attr("src");
                IncrementalDOMBuilder $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(IncrementalDOMBuilder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.error("Failed to process image node\nbasePath: " + this.basePath + "\noriginalUrl: " + originalUrlValue, exception);
            }
        }
        return node;
    }

    private final void actuallyProcessImageNode(Node node, Path basePath, FileSchemeResourceProcessingStrategy fileSchemeResourceProcessor) {
        URI uri;
        String originalUrlValue = node.attr("src");
        if (StringsKt.startsWith$default((String)originalUrlValue, (String)"file:/", (boolean)false, (int)2, null)) {
            v0 = IncrementalDOMBuilder.Companion.createUri(originalUrlValue);
        } else {
            v0 = IncrementalDOMBuilder.Companion.createFileUri(originalUrlValue, basePath);
            if (v0 == null) {
                v0 = uri = IncrementalDOMBuilder.Companion.createUri(originalUrlValue);
            }
        }
        if (uri != null && (uri.getScheme() == null || Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file"))) {
            String string = fileSchemeResourceProcessor.processFileSchemeResource(basePath, uri);
            if (string == null) {
                return;
            }
            String processed = string;
            node.attr("data-original-src", originalUrlValue);
            node.attr("src", processed);
        }
    }

    private final boolean shouldPreprocessImageNode(Node node) {
        return Intrinsics.areEqual((Object)node.nodeName(), (Object)"img") && !node.hasAttr(IntelliJImageGeneratingProvider.Companion.getIgnorePathProcessingAttributeName());
    }

    private final void traverse(Node node) {
        Node node2 = node;
        if (node2 instanceof TextNode) {
            this.textElement((Function0<String>)((Function0)new Function0<String>(node){
                final /* synthetic */ Node $node;
                {
                    this.$node = $node;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ((TextNode)this.$node).getWholeText();
                }
            }));
        } else if (node2 instanceof DataNode) {
            this.textElement((Function0<String>)((Function0)new Function0<String>(node){
                final /* synthetic */ Node $node;
                {
                    this.$node = $node;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ((DataNode)this.$node).getWholeData();
                }
            }));
        } else if (!(node2 instanceof Comment)) {
            Node preprocessed = this.preprocessNode(node);
            this.openTag(preprocessed);
            for (Node child2 : preprocessed.childNodes()) {
                this.traverse(child2);
            }
            this.closeTag(preprocessed);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/IncrementalDOMBuilder$FileSchemeResourceProcessingStrategy;", "", "processFileSchemeResource", "", "basePath", "Ljava/nio/file/Path;", "originalUri", "Ljava/net/URI;", "intellij.markdown.core"})
    public static interface FileSchemeResourceProcessingStrategy {
        @Nullable
        public String processFileSchemeResource(@NotNull Path var1, @NotNull URI var2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/IncrementalDOMBuilder$Companion;", "", "()V", "createFileUri", "Ljava/net/URI;", "string", "", "basePath", "Ljava/nio/file/Path;", "createUri", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final URI createUri(String string) {
            try {
                return new URI(string);
            }
            catch (URISyntaxException exception) {
                return null;
            }
        }

        private final URI createFileUri(String string, Path basePath) {
            try {
                Path path = basePath;
                if (path == null || (path = path.resolve(string)) == null) {
                    path = Paths.get(string, new String[0]);
                }
                Path resolved = path;
                return resolved.toUri();
            }
            catch (Throwable ignored) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

