/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Base64;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlResourceSavingSettings;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u000fJ\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u001c\u0010\u0019\u001a\u000e\u0018\u00010\u0003\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0011H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0011H\u0002R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlExporter;", "", "htmlSource", "", "savingSettings", "Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "targetFile", "Ljava/io/File;", "(Ljava/lang/String;Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;Lcom/intellij/openapi/project/Project;Ljava/io/File;)V", "document", "Lorg/jsoup/nodes/Document;", "kotlin.jvm.PlatformType", "appendInlineStylesContent", "", "styles", "Lorg/jsoup/select/Elements;", "encodeImage", "url", "bytes", "", "export", "getImgUriWithProtocol", "imgSrc", "getRelativeImagePath", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/util/NlsSafe;", "resDir", "getResource", "getSavedImageFile", "imgUrl", "getStyleContent", "linkElement", "Lorg/jsoup/nodes/Element;", "inlineImagesContent", "images", "saveImages", "intellij.markdown.core"})
public final class HtmlExporter {
    @NotNull
    private final HtmlResourceSavingSettings savingSettings;
    @NotNull
    private final Project project;
    @NotNull
    private final File targetFile;
    private final Document document;

    public HtmlExporter(@NotNull String htmlSource, @NotNull HtmlResourceSavingSettings savingSettings, @NotNull Project project, @NotNull File targetFile) {
        this.savingSettings = savingSettings;
        this.project = project;
        this.targetFile = targetFile;
        this.document = Jsoup.parse((String)htmlSource);
    }

    public final void export() {
        Element $this$export_u24lambda_u240 = this.document.head();
        boolean bl = false;
        $this$export_u24lambda_u240.getElementsByTag("script").remove();
        $this$export_u24lambda_u240.getElementsByTag("meta").remove();
        this.appendInlineStylesContent($this$export_u24lambda_u240.select("link[rel=\"stylesheet\"]"));
        Elements images = this.document.body().getElementsByTag("img");
        if (this.savingSettings.isSaved()) {
            this.saveImages(images);
        } else {
            this.inlineImagesContent(images);
        }
        FilesKt.writeText$default((File)this.targetFile, (String)this.document.html(), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendInlineStylesContent(Elements styles) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)styles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Element it$iv$iv;
            String content2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element it = (Element)element$iv$iv;
            boolean bl2 = false;
            if ((this.getStyleContent(it) == null ? null : new Element("style").text(content2)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List inlinedStyles = (List)destination$iv$iv;
        styles.remove();
        Iterable $this$forEach$iv = inlinedStyles;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            if (!it.hasText()) continue;
            this.document.head().appendChild((Node)it);
        }
    }

    private final String getStyleContent(Element linkElement) {
        String string;
        String string2 = linkElement.attr("href");
        if (string2 == null) {
            return null;
        }
        String url = string2;
        try {
            string = HttpRequests.request((String)url).readString();
        }
        catch (IOException exception) {
            String name = new File(url).getName();
            Object[] objectArray = new Object[]{name};
            MarkdownNotifications.showWarning$default(MarkdownNotifications.INSTANCE, this.project, "markdown.export.html.missing.style", null, MarkdownBundle.message("markdown.export.style.not.found.msg", objectArray), 4, null);
            string = null;
        }
        return string;
    }

    private final void inlineImagesContent(Elements images) {
        Iterable $this$forEach$iv = (Iterable)images;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String imgSrc = this.getImgUriWithProtocol(it.attr("src"));
            byte[] content2 = this.getResource(imgSrc);
            if (content2 == null || !(((CharSequence)imgSrc).length() > 0)) continue;
            it.attr("src", this.encodeImage(imgSrc, content2));
        }
    }

    private final String encodeImage(String url, byte[] bytes) {
        CharSequence extension = FileUtil.getExtension((CharSequence)url, (String)"png");
        CharSequence contentType = Intrinsics.areEqual((Object)extension, (Object)"svg") ? (CharSequence)"svg+xml" : extension;
        return "data:image/" + contentType + ";base64, " + Base64.encode((byte[])bytes);
    }

    private final void saveImages(Elements images) {
        Iterable $this$forEach$iv = (Iterable)images;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String imgSrc = it.attr("src");
            String imgUri = this.getImgUriWithProtocol(imgSrc);
            byte[] content2 = this.getResource(imgUri);
            if (content2 == null || !(((CharSequence)imgSrc).length() > 0)) continue;
            File savedImgFile = this.getSavedImageFile(this.savingSettings.getResourceDir(), imgSrc);
            FileUtil.createIfDoesntExist((File)savedImgFile);
            FilesKt.writeBytes((File)savedImgFile, (byte[])content2);
            String relativeImgPath = this.getRelativeImagePath(this.savingSettings.getResourceDir());
            String[] stringArray = new String[]{relativeImgPath, new File(imgSrc).getName()};
            it.attr("src", FileUtil.join((String[])stringArray));
        }
    }

    private final String getImgUriWithProtocol(String imgSrc) {
        return StringsKt.startsWith$default((String)imgSrc, (String)"file:", (boolean)false, (int)2, null) ? imgSrc : new File(imgSrc).toURI().toString();
    }

    private final byte[] getResource(String url) {
        byte[] byArray;
        try {
            byArray = HttpRequests.request((String)url).readBytes(null);
        }
        catch (IOException exception) {
            String name = new File(url).getName();
            Object[] objectArray = new Object[]{name};
            MarkdownNotifications.showWarning$default(MarkdownNotifications.INSTANCE, this.project, "markdown.export.html.missing.image", null, MarkdownBundle.message("markdown.export.images.not.found.msg", objectArray), 4, null);
            byArray = null;
        }
        return byArray;
    }

    private final File getSavedImageFile(String resDir, String imgUrl) {
        String[] stringArray = new String[]{resDir, new File(imgUrl).getName()};
        return new File(FileUtil.join((String[])stringArray));
    }

    private final String getRelativeImagePath(String resDir) {
        return FileUtil.getRelativePath((File)this.targetFile.getParentFile(), (File)new File(resDir));
    }
}

