/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFencePluginCacheCollector;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;

public final class MarkdownCodeFenceHtmlCache
implements Disposable {
    @NotNull
    public static final String MARKDOWN_FILE_PATH_KEY = "markdown-md5-file-path";
    @NotNull
    private final Alarm myAlarm = new Alarm((Disposable)this);
    @NotNull
    private final Collection<MarkdownCodeFencePluginCacheCollector> myCodeFencePluginCaches = ContainerUtil.newConcurrentSet();
    @NotNull
    private final Collection<File> myAdditionalCacheToDelete = ContainerUtil.newConcurrentSet();

    public static MarkdownCodeFenceHtmlCache getInstance() {
        return (MarkdownCodeFenceHtmlCache)ApplicationManager.getApplication().getService(MarkdownCodeFenceHtmlCache.class);
    }

    public MarkdownCodeFenceHtmlCache() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleClearCache();
        }
        BulkFileListener listener = new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file;
                    if (!(vFileEvent instanceof VFileDeleteEvent) || (file = vFileEvent.getFile()) == null || !fileTypeRegistry.isFileOfType(file, (FileType)MarkdownFileType.INSTANCE)) continue;
                    MarkdownCodeFenceHtmlCache.this.myAdditionalCacheToDelete.addAll(MarkdownCodeFenceHtmlCache.processSourceFileToDelete(file, ContainerUtil.emptyList()));
                }
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)listener);
    }

    private static List<File> getPluginSystemPaths() {
        return CodeFenceGeneratingProvider.collectProviders().stream().filter(MarkdownCodeFenceCacheableProvider.class::isInstance).map(MarkdownCodeFenceCacheableProvider.class::cast).map(provider -> provider.getCacheRootPath().toFile()).collect(Collectors.toList());
    }

    public Collection<File> collectFilesToRemove() {
        return this.myCodeFencePluginCaches.stream().flatMap(cacheProvider -> MarkdownCodeFenceHtmlCache.processSourceFileToDelete(cacheProvider.getFile(), cacheProvider.getAliveCachedFiles()).stream()).collect(Collectors.toList());
    }

    private static Collection<File> processSourceFileToDelete(@NotNull VirtualFile sourceFile, @NotNull Collection<File> aliveCachedFiles2) {
        HashSet<File> filesToDelete = new HashSet<File>();
        for (File codeFencePluginSystemPath : MarkdownCodeFenceHtmlCache.getPluginSystemPaths()) {
            for (File sourceFileCacheDirectory : MarkdownCodeFenceHtmlCache.getChildren(codeFencePluginSystemPath)) {
                if (MarkdownCodeFenceHtmlCache.isCachedSourceFile(sourceFileCacheDirectory, sourceFile) && aliveCachedFiles2.isEmpty()) {
                    filesToDelete.add(sourceFileCacheDirectory);
                    continue;
                }
                for (File file : MarkdownCodeFenceHtmlCache.getChildren(sourceFileCacheDirectory)) {
                    if (!MarkdownCodeFenceHtmlCache.isCachedSourceFile(sourceFileCacheDirectory, sourceFile) || aliveCachedFiles2.contains(file)) continue;
                    filesToDelete.add(file);
                }
            }
        }
        return filesToDelete;
    }

    private static File @NotNull [] getChildren(@NotNull File directory) {
        File[] files = directory.listFiles();
        return files != null ? files : ArrayUtilRt.EMPTY_FILE_ARRAY;
    }

    private static boolean isCachedSourceFile(@NotNull File sourceFileDir, @NotNull VirtualFile sourceFile) {
        return sourceFileDir.getName().equals(MarkdownUtil.INSTANCE.md5(sourceFile.getPath(), MARKDOWN_FILE_PATH_KEY));
    }

    public void registerCacheProvider(@NotNull MarkdownCodeFencePluginCacheCollector cacheCollector) {
        this.myCodeFencePluginCaches.add(cacheCollector);
    }

    private void scheduleClearCache() {
        this.myAlarm.addRequest(() -> {
            this.clearCache();
            this.scheduleClearCache();
        }, Registry.intValue((String)"markdown.clear.cache.interval"));
    }

    public synchronized void clearCache() {
        Set filesToDelete = ContainerUtil.union(this.myAdditionalCacheToDelete, this.collectFilesToRemove());
        for (File file : filesToDelete) {
            FileUtil.delete((File)file);
        }
        this.myAdditionalCacheToDelete.clear();
        this.myCodeFencePluginCaches.clear();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myAlarm);
    }
}

