/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.SimpleTagProvider;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.ui.preview.html.ASTUtilsKt;
import org.intellij.plugins.markdown.ui.preview.html.HeaderGeneratingProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/HeaderGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "headerTag", "", "(Ljava/lang/String;)V", "openTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "Companion", "intellij.markdown.core"})
@ApiStatus.Internal
public final class HeaderGeneratingProvider
extends SimpleTagProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<IElementType> whitespaces;

    public HeaderGeneratingProvider(@NotNull String headerTag) {
        super(headerTag);
    }

    public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
        String anchorText = Companion.buildAnchorText(node, text);
        if (anchorText == null) {
            super.openTag(visitor2, text, node);
            return;
        }
        CharSequence[] charSequenceArray = new CharSequence[]{"id=\"" + anchorText + "\""};
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor2, (ASTNode)node, (CharSequence)this.getTagName(), (CharSequence[])charSequenceArray, (boolean)false, (int)8, null);
    }

    public static final /* synthetic */ Set access$getWhitespaces$cp() {
        return whitespaces;
    }

    static {
        Object[] objectArray = new IElementType[]{MarkdownTokenTypes.EOL, MarkdownTokenTypes.WHITE_SPACE};
        whitespaces = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u000f*\u00060\u0010j\u0002`\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/HeaderGeneratingProvider$Companion;", "", "()V", "whitespaces", "", "Lorg/intellij/markdown/IElementType;", "buildAnchorText", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "fileText", "findContentHolder", "obtainLinkTextElements", "Lkotlin/sequences/Sequence;", "processInlineLink", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final ASTNode findContentHolder(ASTNode node) {
            Object v0;
            block1: {
                Sequence<ASTNode> sequence = ASTUtilsKt.children(node);
                for (Object e : sequence) {
                    ASTNode it = (ASTNode)e;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.ATX_CONTENT) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.SETEXT_CONTENT))) continue;
                    v0 = e;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final String buildAnchorText(@NotNull ASTNode node, @NotNull String fileText) {
            StringBuilder stringBuilder;
            ASTNode aSTNode = this.findContentHolder(node);
            if (aSTNode == null) {
                return null;
            }
            ASTNode contentHolder = aSTNode;
            Sequence children2 = SequencesKt.filterNot(ASTUtilsKt.children(contentHolder), (Function1)buildAnchorText.children.1.INSTANCE);
            StringBuilder $this$buildAnchorText_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int count = 0;
            for (ASTNode child2 : children2) {
                IElementType iElementType;
                if (count >= 1) {
                    $this$buildAnchorText_u24lambda_u241.append(" ");
                }
                if (Intrinsics.areEqual((Object)(iElementType = child2.getType()), (Object)MarkdownElementTypes.IMAGE)) {
                    $this$buildAnchorText_u24lambda_u241.append("");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
                    Companion.processInlineLink($this$buildAnchorText_u24lambda_u241, child2, fileText);
                } else {
                    $this$buildAnchorText_u24lambda_u241.append(ASTUtilKt.getTextInNode((ASTNode)child2, (CharSequence)fileText));
                }
                ++count;
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String text = string;
            String string2 = text.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            CharSequence charSequence = string2;
            Regex regex = MarkdownHeader.Companion.getGarbageRegex$intellij_markdown_core();
            String string3 = "";
            charSequence = regex.replace(charSequence, string3);
            regex = MarkdownHeader.Companion.getAdditionalSymbolsRegex$intellij_markdown_core();
            string3 = "";
            String replaced = regex.replace(charSequence, string3);
            return StringsKt.replace$default((String)replaced, (String)" ", (String)"-", (boolean)false, (int)4, null);
        }

        private final Sequence<ASTNode> obtainLinkTextElements(ASTNode node) {
            Iterator iterator;
            Object object;
            Object v0;
            Iterator iterator2;
            ASTNode aSTNode;
            block6: {
                aSTNode = ASTUtilsKt.children(node);
                iterator2 = aSTNode.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    ASTNode it = (ASTNode)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                    v0 = e;
                    break block6;
                }
                v0 = null;
            }
            ASTNode aSTNode2 = v0;
            if (aSTNode2 == null) {
                return SequencesKt.emptySequence();
            }
            ASTNode textHolder = aSTNode2;
            ASTNode aSTNode3 = ASTUtilsKt.getFirstChild(textHolder);
            if (aSTNode3 != null) {
                ASTNode it = aSTNode = aSTNode3;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET) ? aSTNode : null;
            } else {
                object = null;
            }
            ASTNode openBracket = object;
            ASTNode aSTNode4 = ASTUtilsKt.getLastChild(textHolder);
            if (aSTNode4 != null) {
                Iterator it = iterator2 = aSTNode4;
                boolean bl = false;
                iterator = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET) ? iterator2 : null;
            } else {
                iterator = null;
            }
            Iterator closeBracket = iterator;
            return SequencesKt.filterNot(ASTUtilsKt.children(textHolder), (Function1)((Function1)new Function1<ASTNode, Boolean>(openBracket, closeBracket){
                final /* synthetic */ ASTNode $openBracket;
                final /* synthetic */ ASTNode $closeBracket;
                {
                    this.$openBracket = $openBracket;
                    this.$closeBracket = $closeBracket;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ASTNode it) {
                    return Intrinsics.areEqual((Object)it, (Object)this.$openBracket) || Intrinsics.areEqual((Object)it, (Object)this.$closeBracket);
                }
            }));
        }

        private final void processInlineLink(StringBuilder $this$processInlineLink, ASTNode node, String fileText) {
            Sequence<ASTNode> contentElements2 = this.obtainLinkTextElements(node);
            Sequence withoutWhitespaces2 = SequencesKt.filterNot(contentElements2, (Function1)processInlineLink.withoutWhitespaces.1.INSTANCE);
            SequencesKt.joinTo$default((Sequence)withoutWhitespaces2, (Appendable)$this$processInlineLink, (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<ASTNode, CharSequence>(fileText){
                final /* synthetic */ String $fileText;
                {
                    this.$fileText = $fileText;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull ASTNode it) {
                    return Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.IMAGE) ? (CharSequence)"" : ASTUtilKt.getTextInNode((ASTNode)it, (CharSequence)this.$fileText);
                }
            }), (int)60, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

