/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.registry.Registry;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.util.function.Supplier;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class PreciseVerticalScrollHelper
extends MouseAdapter {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Supplier<? extends MarkdownHtmlPanelEx> htmlPanelSupplier;
    private int lastOffset = 0;

    PreciseVerticalScrollHelper(@NotNull EditorImpl editor2, @NotNull Supplier<? extends MarkdownHtmlPanelEx> htmlPanelSupplier) {
        this.editor = editor2;
        this.htmlPanelSupplier = htmlPanelSupplier;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        int currentOffset = this.editor.getScrollingModel().getVerticalScrollOffset();
        if (this.lastOffset == currentOffset) {
            this.boundaryReached(event);
        } else {
            this.lastOffset = currentOffset;
        }
    }

    private void boundaryReached(MouseWheelEvent event) {
        MarkdownHtmlPanelEx actualPanel = this.htmlPanelSupplier.get();
        if (actualPanel == null) {
            return;
        }
        if (event.getScrollType() == 0) {
            int multiplier = Registry.intValue((String)"ide.browser.jcef.osr.wheelRotation.factor", (int)1);
            int amount = event.getScrollAmount() * event.getWheelRotation() * multiplier;
            actualPanel.scrollBy(0, amount);
        }
    }
}

