/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public class MarkdownSplitEditor
extends SplitFileEditor<TextEditor, MarkdownPreviewFileEditor>
implements TextEditor {
    private boolean myAutoScrollPreview = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isAutoScrollPreview();
    private boolean myVerticalSplit = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isVerticalSplit();

    public MarkdownSplitEditor(@NotNull TextEditor mainEditor, @NotNull MarkdownPreviewFileEditor secondEditor) {
        super(mainEditor, secondEditor);
        secondEditor.setMainEditor(mainEditor.getEditor());
        MarkdownApplicationSettings.SettingsChangedListener settingsChangedListener = new MarkdownApplicationSettings.SettingsChangedListener(){

            @Override
            public void beforeSettingsChanged(@NotNull MarkdownApplicationSettings newSettings) {
                boolean oldAutoScrollPreview = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isAutoScrollPreview();
                boolean oldVerticalSplit = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isVerticalSplit();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (oldAutoScrollPreview == MarkdownSplitEditor.this.myAutoScrollPreview) {
                        MarkdownSplitEditor.this.setAutoScrollPreview(newSettings.getMarkdownPreviewSettings().isAutoScrollPreview());
                    }
                    if (oldVerticalSplit == MarkdownSplitEditor.this.myVerticalSplit) {
                        MarkdownSplitEditor.this.setVerticalSplit(newSettings.getMarkdownPreviewSettings().isVerticalSplit());
                    }
                });
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(MarkdownApplicationSettings.SettingsChangedListener.TOPIC, (Object)settingsChangedListener);
        mainEditor.getEditor().getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new MyVisibleAreaListener());
    }

    @NotNull
    public String getName() {
        return MarkdownBundle.message("markdown.editor.name", new Object[0]);
    }

    @Nullable
    public VirtualFile getFile() {
        return ((TextEditor)this.getMainEditor()).getFile();
    }

    @NotNull
    public Editor getEditor() {
        return ((TextEditor)this.getMainEditor()).getEditor();
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        return ((TextEditor)this.getMainEditor()).canNavigateTo(navigatable);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        ((TextEditor)this.getMainEditor()).navigateTo(navigatable);
    }

    public boolean isAutoScrollPreview() {
        return this.myAutoScrollPreview;
    }

    public void setVerticalSplit(boolean verticalSplit) {
        this.myVerticalSplit = verticalSplit;
    }

    public void setAutoScrollPreview(boolean autoScrollPreview) {
        this.myAutoScrollPreview = autoScrollPreview;
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private int previousLine = 0;

        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent event) {
            if (!MarkdownSplitEditor.this.isAutoScrollPreview()) {
                return;
            }
            Editor editor2 = event.getEditor();
            int currentLine = EditorUtil.yPositionToLogicalLine((Editor)editor2, (int)editor2.getScrollingModel().getVerticalScrollOffset());
            if (currentLine == this.previousLine) {
                return;
            }
            this.previousLine = currentLine;
            ((MarkdownPreviewFileEditor)((Object)MarkdownSplitEditor.this.getSecondEditor())).scrollToSrcOffset(EditorUtil.getVisualLineEndOffset((Editor)editor2, (int)currentLine));
        }
    }
}

