/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;

public class MarkdownPreviewFileEditorProvider
extends WeighedFileEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (!MarkdownHtmlPanelProvider.hasAvailableProviders()) {
            return false;
        }
        FileType fileType2 = file.getFileType();
        return fileType2 == MarkdownFileType.INSTANCE || ScratchUtil.isScratch((VirtualFile)file) && LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file, (FileType)fileType2) == MarkdownLanguage.INSTANCE;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        return new MarkdownPreviewFileEditor(project, file);
    }

    @NotNull
    public String getEditorTypeId() {
        return "markdown-preview-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }
}

