/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.List;
import javax.swing.JComponent;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class MarkdownHtmlPanelProvider {
    public static final ExtensionPointName<MarkdownHtmlPanelProvider> EP_NAME = ExtensionPointName.create((String)"org.intellij.markdown.html.panel.provider");

    @NotNull
    public abstract MarkdownHtmlPanel createHtmlPanel();

    @ApiStatus.Experimental
    @NotNull
    public MarkdownHtmlPanel createHtmlPanel(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        return this.createHtmlPanel();
    }

    @NotNull
    public abstract AvailabilityInfo isAvailable();

    @NotNull
    public abstract ProviderInfo getProviderInfo();

    public static MarkdownHtmlPanelProvider @NotNull [] getProviders() {
        return (MarkdownHtmlPanelProvider[])EP_NAME.getExtensions();
    }

    @NotNull
    public static MarkdownHtmlPanelProvider createFromInfo(@NotNull ProviderInfo providerInfo) {
        for (MarkdownHtmlPanelProvider provider : MarkdownHtmlPanelProvider.getProviders()) {
            if (!provider.getProviderInfo().getClassName().equals(providerInfo.getClassName())) continue;
            return provider;
        }
        return MarkdownHtmlPanelProvider.getProviders()[0];
    }

    public static boolean hasAvailableProviders() {
        return ContainerUtil.exists((Object[])MarkdownHtmlPanelProvider.getProviders(), provider -> provider.isAvailable() == AvailabilityInfo.AVAILABLE);
    }

    @NotNull
    public static List<MarkdownHtmlPanelProvider> getAvailableProviders() {
        return ContainerUtil.filter((Object[])MarkdownHtmlPanelProvider.getProviders(), provider -> provider.isAvailable() == AvailabilityInfo.AVAILABLE);
    }

    public static class ProviderInfo {
        @Attribute(value="name")
        @NotNull
        private String myName;
        @Attribute(value="className")
        @NotNull
        private String className;

        private ProviderInfo() {
            this.myName = "";
            this.className = "";
        }

        public ProviderInfo(@NotNull String name, @NotNull String className) {
            this.myName = name;
            this.className = className;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProviderInfo info = (ProviderInfo)o;
            if (!this.myName.equals(info.myName)) {
                return false;
            }
            return this.className.equals(info.className);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + this.className.hashCode();
            return result2;
        }

        public String toString() {
            return this.myName;
        }
    }

    public static abstract class AvailabilityInfo {
        public static final AvailabilityInfo AVAILABLE = new AvailabilityInfo(){

            @Override
            public boolean checkAvailability(@NotNull JComponent parentComponent) {
                return true;
            }
        };
        public static final AvailabilityInfo UNAVAILABLE = new AvailabilityInfo(){

            @Override
            public boolean checkAvailability(@NotNull JComponent parentComponent) {
                return false;
            }
        };

        public abstract boolean checkAvailability(@NotNull JComponent var1);
    }
}

