/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.floating;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.ui.floating.FloatingToolbar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0017\u0018\u0000 32\u00020\u0001:\u00043456B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001e0\"H\u0002J\b\u0010$\u001a\u00020\u001eH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0014J\u0006\u0010*\u001a\u00020\u001eJ\u0006\u0010+\u001a\u00020\u001cJ\b\u0010,\u001a\u00020\u001eH\u0002J\u0006\u0010-\u001a\u00020\u001eJ\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u00020\u001eH\u0002J\u0006\u00100\u001a\u00020\u001eJ\u001c\u00101\u001a\u00020\u001e2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "actionGroupId", "", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "<set-?>", "", "buttonSize", "getButtonSize", "()I", "setButtonSize", "(I)V", "buttonSize$delegate", "Lkotlin/properties/ReadWriteProperty;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "hint", "Lcom/intellij/ui/LightweightHint;", "keyboardListener", "Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$KeyboardListener;", "lastSelection", "mouseListener", "Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseListener;", "mouseMotionListener", "Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseMotionListener;", "canBeShownAtCurrentSelection", "", "createActionToolbar", "", "targetComponent", "Ljavax/swing/JComponent;", "onUpdated", "Lkotlin/Function1;", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "dispose", "getHintPosition", "Ljava/awt/Point;", "hasIgnoredParent", "element", "Lcom/intellij/psi/PsiElement;", "hideIfShown", "isShown", "registerListeners", "showIfHidden", "showOrUpdateLocation", "unregisterListeners", "updateLocationIfShown", "updateOnProbablyChangedSelection", "onSelectionChanged", "Companion", "KeyboardListener", "MouseListener", "MouseMotionListener", "intellij.markdown.core"})
@ApiStatus.Internal
public class FloatingToolbar
implements Disposable {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Editor editor;
    @NotNull
    private final String actionGroupId;
    @NotNull
    private final MouseListener mouseListener;
    @NotNull
    private final KeyboardListener keyboardListener;
    @NotNull
    private final MouseMotionListener mouseMotionListener;
    @Nullable
    private LightweightHint hint;
    @NotNull
    private final ReadWriteProperty buttonSize$delegate;
    @Nullable
    private String lastSelection;
    @NotNull
    public static final String EDITOR_FLOATING_TOOLBAR = "MarkdownEditorFloatingToolbar";
    private static final int verticalGap = 2;
    @NotNull
    private static final List<IElementType> elementsToIgnore;

    public FloatingToolbar(@NotNull Editor editor2, @NotNull String actionGroupId) {
        this.editor = editor2;
        this.actionGroupId = actionGroupId;
        this.mouseListener = new MouseListener();
        this.keyboardListener = new KeyboardListener();
        this.mouseMotionListener = new MouseMotionListener();
        this.buttonSize$delegate = Delegates.INSTANCE.notNull();
        this.registerListeners();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    private final int getButtonSize() {
        return ((Number)this.buttonSize$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setButtonSize(int n) {
        this.buttonSize$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    public final boolean isShown() {
        return this.hint != null;
    }

    public final void hideIfShown() {
        block0: {
            LightweightHint lightweightHint = this.hint;
            if (lightweightHint == null) break block0;
            lightweightHint.hide();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void showIfHidden() {
        void $this$showIfHidden_u24lambda_u240;
        LightweightHint lightweightHint;
        if (this.hint != null || !this.canBeShownAtCurrentSelection()) {
            return;
        }
        this.createActionToolbar(this.editor.getContentComponent(), (Function1<? super ActionToolbar, Unit>)((Function1)new Function1<ActionToolbar, Unit>(this){
            final /* synthetic */ FloatingToolbar this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ActionToolbar toolbar2) {
                LightweightHint lightweightHint = FloatingToolbar.access$getHint$p(this.this$0);
                if (lightweightHint == null) {
                    return;
                }
                LightweightHint hint = lightweightHint;
                hint.getComponent().add((Component)toolbar2.getComponent(), "Center");
                FloatingToolbar.access$showOrUpdateLocation(this.this$0, hint);
                hint.addHintListener(arg_0 -> showIfHidden.1.invoke$lambda$0(this.this$0, arg_0));
            }

            private static final void invoke$lambda$0(FloatingToolbar this$0, EventObject it) {
                FloatingToolbar.access$setHint$p(this$0, null);
            }
        }));
        LightweightHint lightweightHint2 = lightweightHint = new LightweightHint((JComponent)new JPanel(new BorderLayout()));
        FloatingToolbar floatingToolbar = this;
        boolean bl = false;
        $this$showIfHidden_u24lambda_u240.setForceShowAsPopup(true);
        floatingToolbar.hint = lightweightHint;
    }

    public final void updateLocationIfShown() {
        LightweightHint lightweightHint = this.hint;
        if (lightweightHint == null) {
            return;
        }
        this.showOrUpdateLocation(lightweightHint);
    }

    public void dispose() {
        this.unregisterListeners();
        this.hideIfShown();
        this.hint = null;
    }

    private final void createActionToolbar(JComponent targetComponent, Function1<? super ActionToolbar, Unit> onUpdated) {
        AnAction anAction = CustomActionsSchema.getInstance().getCorrectedAction(this.actionGroupId);
        ActionGroup actionGroup = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
        if (actionGroup == null) {
            return;
        }
        ActionGroup group = actionGroup;
        ActionToolbar toolbar2 = Companion.createImmediatelyUpdatedToolbar$intellij_markdown_core(group, EDITOR_FLOATING_TOOLBAR, targetComponent, true, onUpdated);
        this.setButtonSize(toolbar2.getMaxButtonHeight());
    }

    private final void showOrUpdateLocation(LightweightHint hint) {
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, this.editor, this.getHintPosition(hint), 129, 0, true);
    }

    private final void registerListeners() {
        this.editor.addEditorMouseListener((EditorMouseListener)this.mouseListener);
        this.editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.mouseMotionListener);
        this.editor.getContentComponent().addKeyListener(this.keyboardListener);
    }

    private final void unregisterListeners() {
        this.editor.removeEditorMouseListener((EditorMouseListener)this.mouseListener);
        this.editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this.mouseMotionListener);
        this.editor.getContentComponent().removeKeyListener(this.keyboardListener);
    }

    private final boolean canBeShownAtCurrentSelection() {
        PsiFile file = PsiEditorUtil.getPsiFile((Editor)this.editor);
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(this.editor.getDocument());
        SelectionModel selectionModel = this.editor.getSelectionModel();
        PsiElement elementAtStart = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)selectionModel.getSelectionStart());
        PsiElement elementAtEnd = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)selectionModel.getSelectionEnd());
        return !this.hasIgnoredParent(elementAtStart) && !this.hasIgnoredParent(elementAtEnd);
    }

    protected boolean hasIgnoredParent(@NotNull PsiElement element2) {
        boolean bl;
        block2: {
            if (!(element2.getContainingFile() instanceof MarkdownFile)) {
                return true;
            }
            Sequence $this$any$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!elementsToIgnore.contains(PsiTreeUtilKt.getElementType((PsiElement)it))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final Point getHintPosition(LightweightHint hint) {
        Point hintPos = HintManagerImpl.getInstanceImpl().getHintPosition(hint, this.editor, (short)6);
        int dy = -(hint.getComponent().getPreferredSize().height + 2);
        int dx = this.getButtonSize() * -2;
        hintPos.translate(dx, dy);
        return hintPos;
    }

    private final void updateOnProbablyChangedSelection(Function1<? super String, Unit> onSelectionChanged) {
        String newSelection = this.editor.getSelectionModel().getSelectedText();
        String string = newSelection;
        if (string == null) {
            this.hideIfShown();
        } else if (!Intrinsics.areEqual((Object)string, (Object)this.lastSelection)) {
            onSelectionChanged.invoke((Object)newSelection);
        }
        this.lastSelection = newSelection;
    }

    public static final /* synthetic */ LightweightHint access$getHint$p(FloatingToolbar $this) {
        return $this.hint;
    }

    public static final /* synthetic */ void access$showOrUpdateLocation(FloatingToolbar $this, LightweightHint hint) {
        $this.showOrUpdateLocation(hint);
    }

    public static final /* synthetic */ void access$setHint$p(FloatingToolbar $this, LightweightHint lightweightHint) {
        $this.hint = lightweightHint;
    }

    static {
        Object[] objectArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FloatingToolbar.class, "buttonSize", "getButtonSize()I", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new IElementType[]{MarkdownElementTypes.CODE_FENCE, MarkdownElementTypes.CODE_BLOCK, MarkdownElementTypes.CODE_SPAN, MarkdownElementTypes.HTML_BLOCK, MarkdownElementTypes.LINK_DESTINATION};
        elementsToIgnore = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "(Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;)V", "mouseReleased", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.markdown.core"})
    private final class MouseListener
    implements EditorMouseListener {
        public void mouseReleased(@NotNull EditorMouseEvent e) {
            FloatingToolbar.this.updateOnProbablyChangedSelection((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(FloatingToolbar.this){
                final /* synthetic */ FloatingToolbar this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    if (this.this$0.isShown()) {
                        this.this$0.updateLocationIfShown();
                    } else {
                        this.this$0.showIfHidden();
                    }
                }
            }));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$KeyboardListener;", "Ljava/awt/event/KeyAdapter;", "(Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;)V", "keyReleased", "", "e", "Ljava/awt/event/KeyEvent;", "intellij.markdown.core"})
    private final class KeyboardListener
    extends KeyAdapter {
        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            super.keyReleased(e);
            if (!Intrinsics.areEqual((Object)e.getSource(), (Object)FloatingToolbar.this.getEditor().getContentComponent())) {
                return;
            }
            FloatingToolbar.this.updateOnProbablyChangedSelection((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(FloatingToolbar.this){
                final /* synthetic */ FloatingToolbar this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    this.this$0.hideIfShown();
                }
            }));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "(Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;)V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.markdown.core"})
    private final class MouseMotionListener
    implements EditorMouseMotionListener {
        public void mouseMoved(@NotNull EditorMouseEvent e) {
            boolean hoverSelected;
            block4: {
                VisualPosition visualPosition = e.getVisualPosition();
                Iterable $this$any$iv = FloatingToolbar.this.getEditor().getCaretModel().getAllCarets();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Caret it = (Caret)element$iv;
                        boolean bl = false;
                        boolean beforeSelectionEnd = it.getSelectionEndPosition().after(visualPosition);
                        boolean afterSelectionStart = visualPosition.after(it.getSelectionStartPosition());
                        if (!(beforeSelectionEnd && afterSelectionStart)) continue;
                        v0 = true;
                        break block4;
                    }
                    v0 = hoverSelected = false;
                }
            }
            if (hoverSelected) {
                FloatingToolbar.this.showIfHidden();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JC\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00160\u0015H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$Companion;", "", "()V", "EDITOR_FLOATING_TOOLBAR", "", "elementsToIgnore", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "verticalGap", "", "createImmediatelyUpdatedToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "place", "targetComponent", "Ljavax/swing/JComponent;", "horizontal", "", "onUpdated", "Lkotlin/Function1;", "", "createImmediatelyUpdatedToolbar$intellij_markdown_core", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionToolbar createImmediatelyUpdatedToolbar$intellij_markdown_core(@NotNull ActionGroup group, @NotNull String place, @NotNull JComponent targetComponent, boolean horizontal, @NotNull Function1<? super ActionToolbar, Unit> onUpdated) {
            ActionToolbarImpl toolbar2 = new ActionToolbarImpl(place, group, horizontal, onUpdated){
                final /* synthetic */ Function1<ActionToolbar, Unit> $onUpdated;
                {
                    this.$onUpdated = $onUpdated;
                    super($place, $group, $horizontal);
                }

                protected void actionsUpdated(boolean forced, @NotNull List<? extends AnAction> newVisibleActions) {
                    boolean firstTime = forced && !this.hasVisibleActions();
                    super.actionsUpdated(forced, newVisibleActions);
                    if (firstTime) {
                        UIUtil.markAsShowing((JComponent)((JComponent)((Object)this)), (boolean)false);
                        this.$onUpdated.invoke((Object)((Object)this));
                    }
                }
            };
            toolbar2.setTargetComponent(targetComponent);
            toolbar2.putClientProperty((Object)"ActionToolbarImpl.suppressFastTrack", (Object)true);
            toolbar2.setReservePlaceAutoPopupIcon(false);
            UIUtil.markAsShowing((JComponent)((JComponent)toolbar2), (boolean)true);
            toolbar2.updateActionsImmediately(true);
            return (ActionToolbar)toolbar2;
        }

        public static /* synthetic */ ActionToolbar createImmediatelyUpdatedToolbar$intellij_markdown_core$default(Companion companion, ActionGroup actionGroup, String string, JComponent jComponent, boolean bl, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.createImmediatelyUpdatedToolbar$intellij_markdown_core(actionGroup, string, jComponent, bl, (Function1<? super ActionToolbar, Unit>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

