/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.floating;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorCustomizer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.ui.floating.FloatingToolbar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/AddFloatingToolbarTextEditorCustomizer;", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorCustomizer;", "()V", "customize", "", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "shouldAcceptEditor", "", "editor", "shouldAcceptScratchFile", "intellij.markdown.core"})
public final class AddFloatingToolbarTextEditorCustomizer
implements TextEditorCustomizer {
    public void customize(@NotNull TextEditor textEditor) {
        if (this.shouldAcceptEditor(textEditor) && !AdvancedSettings.Companion.getBoolean("markdown.hide.floating.toolbar")) {
            FloatingToolbar toolbar2 = new FloatingToolbar(textEditor.getEditor(), "Markdown.Toolbar.Floating");
            Disposer.register((Disposable)((Disposable)textEditor), (Disposable)toolbar2);
        }
    }

    private final boolean shouldAcceptEditor(TextEditor editor2) {
        VirtualFile file = editor2.getFile();
        return Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE)) || this.shouldAcceptScratchFile(editor2);
    }

    private final boolean shouldAcceptScratchFile(TextEditor editor2) {
        VirtualFile file = editor2.getFile();
        Project project = editor2.getEditor().getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        return ScratchUtil.isScratch((VirtualFile)file) && Intrinsics.areEqual((Object)LanguageUtil.getLanguageForPsi((Project)project2, (VirtualFile)file, (FileType)file.getFileType()), (Object)((Object)MarkdownLanguage.INSTANCE));
    }
}

