/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Pair;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.actions.styling.SelectionUtil;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkdownHeaderAction
extends AnAction
implements DumbAware {
    @NotNull
    protected abstract Function<Integer, Integer> getLevelFunction();

    protected abstract boolean isEnabledForCaret(@NotNull PsiFile var1, int var2, int var3);

    public void update(@NotNull AnActionEvent event) {
        Editor editor2 = MarkdownActionUtil.findMarkdownEditor(event);
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (editor2 == null || psiFile == null || !psiFile.isValid()) {
            return;
        }
        Collection<SelectionUtil.CaretSnapshot> carets = SelectionUtil.obtainCaretSnapshots(this, event);
        if (carets == null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        for (SelectionUtil.CaretSnapshot caret : carets) {
            if (this.isEnabledForCaret(psiFile, caret.getSelectionStart(), caret.getSelectionEnd())) continue;
            event.getPresentation().setEnabled(false);
            return;
        }
        event.getPresentation().setEnabled(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Editor editor2 = MarkdownActionUtil.findRequiredMarkdownEditor(event);
        PsiFile psiFile = (PsiFile)event.getRequiredData(CommonDataKeys.PSI_FILE);
        String commandName = this.getTemplatePresentation().getText();
        WriteCommandAction.runWriteCommandAction((Project)psiFile.getProject(), (String)commandName, null, () -> {
            if (!psiFile.isValid()) {
                return;
            }
            for (Caret caret : ContainerUtil.reverse((List)editor2.getCaretModel().getAllCarets())) {
                PsiElement parent = Objects.requireNonNull(MarkdownHeaderAction.findParent(psiFile, caret.getSelectionStart(), caret.getSelectionEnd()));
                MarkdownHeader header = (MarkdownHeader)PsiTreeUtil.getParentOfType((PsiElement)parent, MarkdownHeader.class, (boolean)false);
                if (header != null && header.isValid()) {
                    header.replace((PsiElement)this.createNewLevelHeader(header));
                    continue;
                }
                parent.replace((PsiElement)this.createHeaderForText(parent));
            }
        }, (PsiFile[])new PsiFile[]{psiFile});
    }

    @Nullable
    protected static PsiElement findParent(@NotNull PsiFile psiFile, int selectionStart, int selectionEnd) {
        Pair<PsiElement, PsiElement> elements2 = MarkdownActionUtil.getElementsUnderCaretOrSelection(psiFile, selectionStart, selectionEnd);
        PsiElement first = (PsiElement)elements2.getFirst();
        PsiElement second = (PsiElement)elements2.getSecond();
        if (MarkdownPsiUtil.WhiteSpaces.isNewLine(first)) {
            first = PsiTreeUtil.nextVisibleLeaf((PsiElement)first);
        }
        if (MarkdownPsiUtil.WhiteSpaces.isNewLine(second)) {
            second = PsiTreeUtil.prevVisibleLeaf((PsiElement)second);
        }
        if (first == null || second == null || first.getTextOffset() > second.getTextOffset()) {
            return null;
        }
        PsiElement parent = MarkdownActionUtil.getCommonParentOfTypes(first, second, TokenSet.orSet((TokenSet[])new TokenSet[]{MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES, MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_PARENTS_TYPES}));
        if (parent == null || PsiUtilCore.getElementType((PsiElement)parent) != MarkdownElementTypes.PARAGRAPH) {
            return parent;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        assert (document != null);
        int startOffset = parent.getTextRange().getStartOffset();
        int endOffset = parent.getTextRange().getEndOffset();
        if (startOffset < 0 || endOffset > document.getTextLength()) {
            return null;
        }
        if (document.getLineNumber(startOffset) == document.getLineNumber(endOffset)) {
            return parent;
        }
        return null;
    }

    private static int sanitizeHeaderLevel(int level) {
        return Math.min(Math.max(level, 0), 6);
    }

    @NotNull
    public MarkdownPsiElement createHeaderForText(@NotNull PsiElement textElement) {
        int level = MarkdownHeaderAction.sanitizeHeaderLevel((Integer)this.getLevelFunction().fun((Object)0));
        return MarkdownPsiElementFactory.createHeader(textElement.getProject(), textElement.getText(), level);
    }

    @NotNull
    public MarkdownPsiElement createNewLevelHeader(@NotNull MarkdownHeader header) {
        int level = MarkdownHeaderAction.sanitizeHeaderLevel((Integer)this.getLevelFunction().fun((Object)Objects.requireNonNull(header).getLevel()));
        Project project = header.getProject();
        String headerName = Objects.requireNonNull(header.getName());
        MarkdownPsiElement newElement = header.getNode().getElementType() == MarkdownElementTypes.SETEXT_1 && level == 2 ? MarkdownPsiElementFactory.createSetext(project, headerName, "-", header.getLastChild().getTextLength()) : (header.getNode().getElementType() == MarkdownElementTypes.SETEXT_2 && level == 1 ? MarkdownPsiElementFactory.createSetext(project, headerName, "=", header.getLastChild().getTextLength()) : (level == 0 ? MarkdownPsiElementFactory.createTextElement(project, headerName) : MarkdownPsiElementFactory.createHeader(project, headerName, level)));
        return newElement;
    }
}

