/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.actions.styling.SelectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H$J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0015H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001aH\u0002J \u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001aH\u0016J\b\u0010'\u001a\u00020\u001aH$J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006*"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/BaseToggleStateAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "targetNodeType", "Lcom/intellij/psi/tree/IElementType;", "getTargetNodeType", "()Lcom/intellij/psi/tree/IElementType;", "addEmphasisToSelection", "", "document", "Lcom/intellij/openapi/editor/Document;", "caret", "Lcom/intellij/openapi/editor/Caret;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getBoundString", "", "text", "", "selectionStart", "", "selectionEnd", "getExistingBoundString", "startOffset", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "processCaret", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "state", "removeEmphasisFromSelection", "nodeRange", "Lcom/intellij/openapi/util/TextRange;", "setSelected", "shouldMoveToWordBounds", "update", "Companion", "intellij.markdown.core"})
public abstract class BaseToggleStateAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<IElementType> elementsToIgnore;

    @NotNull
    protected abstract String getBoundString(@NotNull CharSequence var1, int var2, int var3);

    @Nullable
    protected String getExistingBoundString(@NotNull CharSequence text, int startOffset) {
        return String.valueOf(text.charAt(startOffset));
    }

    protected abstract boolean shouldMoveToWordBounds();

    @NotNull
    protected abstract IElementType getTargetNodeType();

    public void update(@NotNull AnActionEvent event) {
        Editor editor2 = MarkdownActionUtil.findMarkdownEditor(event);
        event.getPresentation().setEnabled(editor2 != null);
        super.update(event);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        boolean hasValidParents;
        boolean hasMissingParents;
        block7: {
            boolean bl;
            boolean bl2;
            Sequence commonParents2;
            block6: {
                if (MarkdownActionUtil.findMarkdownEditor(event) == null) {
                    return false;
                }
                PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
                if (psiFile == null) {
                    return false;
                }
                PsiFile file = psiFile;
                Sequence sequence = SelectionUtil.obtainCaretSnapshots((AnAction)this, event);
                if (sequence == null || (sequence = CollectionsKt.asSequence((Iterable)((Iterable)sequence))) == null) {
                    return false;
                }
                Sequence caretSnapshots = sequence;
                Sequence selectionElements2 = SequencesKt.map((Sequence)caretSnapshots, (Function1)((Function1)new Function1<SelectionUtil.CaretSnapshot, Pair<? extends PsiElement, ? extends PsiElement>>(file){
                    final /* synthetic */ PsiFile $file;
                    {
                        this.$file = $file;
                        super(1);
                    }

                    @NotNull
                    public final Pair<PsiElement, PsiElement> invoke(@NotNull SelectionUtil.CaretSnapshot it) {
                        return MarkdownActionUtil.getElementsUnderCaretOrSelection(this.$file, it.getSelectionStart(), it.getSelectionEnd());
                    }
                }));
                Sequence $this$any$iv = commonParents2 = SequencesKt.map((Sequence)selectionElements2, (Function1)((Function1)new Function1<Pair<? extends PsiElement, ? extends PsiElement>, PsiElement>(this){
                    final /* synthetic */ BaseToggleStateAction this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final PsiElement invoke(@NotNull Pair<? extends PsiElement, ? extends PsiElement> pair) {
                        PsiElement left = (PsiElement)pair.component1();
                        PsiElement right = (PsiElement)pair.component2();
                        return MarkdownActionUtil.getCommonParentOfType(left, right, this.this$0.getTargetNodeType());
                    }
                }));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl3 = false;
                    if (!(it == null)) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
            hasMissingParents = bl2;
            Sequence $this$any$iv = commonParents2;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl4 = false;
                if (!(it != null)) continue;
                bl = true;
                break block7;
            }
            bl = hasValidParents = false;
        }
        if (hasMissingParents && hasValidParents) {
            event.getPresentation().setEnabled(false);
            return false;
        }
        event.getPresentation().setEnabled(true);
        return !hasMissingParents;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Editor editor2 = MarkdownActionUtil.findMarkdownEditor(event);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(file, this, editor3, state){
            final /* synthetic */ PsiFile $file$inlined;
            final /* synthetic */ BaseToggleStateAction this$0;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ boolean $state$inlined;
            {
                this.$file$inlined = psiFile;
                this.this$0 = baseToggleStateAction;
                this.$editor$inlined = editor2;
                this.$state$inlined = bl;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                void project$iv;
                boolean bl = false;
                Project project = this.$file$inlined.getProject();
                String name$iv = this.this$0.getTemplatePresentation().getText();
                Object groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(this.$editor$inlined, this.this$0, this.$file$inlined, this.$state$inlined){
                    final /* synthetic */ Editor $editor$inlined;
                    final /* synthetic */ BaseToggleStateAction this$0;
                    final /* synthetic */ PsiFile $file$inlined;
                    final /* synthetic */ boolean $state$inlined;
                    {
                        this.$editor$inlined = editor2;
                        this.this$0 = baseToggleStateAction;
                        this.$file$inlined = psiFile;
                        this.$state$inlined = bl;
                    }

                    public final void run() {
                        boolean bl = false;
                        EditorUtilKt.runForEachCaret(this.$editor$inlined.getCaretModel(), true, (Function1<? super Caret, Unit>)((Function1)new Function1<Caret, Unit>(this.this$0, this.$file$inlined, this.$editor$inlined, this.$state$inlined){
                            final /* synthetic */ BaseToggleStateAction this$0;
                            final /* synthetic */ PsiFile $file;
                            final /* synthetic */ Editor $editor;
                            final /* synthetic */ boolean $state;
                            {
                                this.this$0 = $receiver;
                                this.$file = $file;
                                this.$editor = $editor;
                                this.$state = $state;
                                super(1);
                            }

                            public final void invoke(@NotNull Caret caret) {
                                BaseToggleStateAction.access$processCaret(this.this$0, this.$file, this.$editor, caret, this.$state);
                            }
                        }));
                    }
                }, name$iv, groupId$iv);
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final void processCaret(PsiFile file, Editor editor2, Caret caret, boolean state) {
        Pair<PsiElement, PsiElement> pair = MarkdownActionUtil.getElementsUnderCaretOrSelection(file, caret);
        PsiElement first = (PsiElement)pair.component1();
        PsiElement second = (PsiElement)pair.component2();
        if (!state) {
            PsiElement parent = MarkdownActionUtil.getCommonParentOfType(first, second, this.getTargetNodeType());
            if (parent == null) {
                BaseToggleStateAction $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(BaseToggleStateAction.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.warn("Could not find enclosing element on its destruction");
                return;
            }
            this.removeEmphasisFromSelection(editor2.getDocument(), caret, parent.getTextRange());
            return;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)first, (PsiElement)second);
        if (!elementsToIgnore.contains(PsiTreeUtilKt.getElementType((PsiElement)parent))) {
            this.addEmphasisToSelection(editor2.getDocument(), caret);
        }
    }

    private final void removeEmphasisFromSelection(Document document, Caret caret, TextRange nodeRange) {
        CharSequence text = document.getCharsSequence();
        String boundString = this.getExistingBoundString(text, nodeRange.getStartOffset());
        if (boundString == null) {
            BaseToggleStateAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BaseToggleStateAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.warn("Could not fetch bound string from found node");
            return;
        }
        int boundLength = boundString.length();
        if (nodeRange.getStartOffset() + boundLength == caret.getSelectionStart() && nodeRange.getEndOffset() - boundLength == caret.getSelectionEnd()) {
            document.deleteString(nodeRange.getEndOffset() - boundLength, nodeRange.getEndOffset());
            document.deleteString(nodeRange.getStartOffset(), nodeRange.getStartOffset() + boundLength);
            return;
        }
        int from = caret.getSelectionStart();
        int to = caret.getSelectionEnd();
        if (this.shouldMoveToWordBounds()) {
            while (from - boundLength > nodeRange.getStartOffset() && Character.isWhitespace(text.charAt(from - 1))) {
                --from;
            }
            while (to + boundLength < nodeRange.getEndOffset() && Character.isWhitespace(text.charAt(to))) {
                ++to;
            }
        }
        if (to + boundLength == nodeRange.getEndOffset()) {
            document.deleteString(nodeRange.getEndOffset() - boundLength, nodeRange.getEndOffset());
        } else {
            document.insertString(to, (CharSequence)boundString);
        }
        if (from - boundLength == nodeRange.getStartOffset()) {
            document.deleteString(nodeRange.getStartOffset(), nodeRange.getStartOffset() + boundLength);
        } else {
            document.insertString(from, (CharSequence)boundString);
        }
    }

    private final void addEmphasisToSelection(Document document, Caret caret) {
        int from;
        int to = caret.getSelectionEnd();
        CharSequence text = document.getCharsSequence();
        if (this.shouldMoveToWordBounds()) {
            for (from = caret.getSelectionStart(); from < to && Character.isWhitespace(text.charAt(from)); ++from) {
            }
            while (to > from && Character.isWhitespace(text.charAt(to - 1))) {
                --to;
            }
            if (from == to) {
                from = caret.getSelectionStart();
                to = caret.getSelectionEnd();
            }
        }
        String boundString = this.getBoundString(text, from, to);
        document.insertString(to, (CharSequence)boundString);
        document.insertString(from, (CharSequence)boundString);
        if (caret.getSelectionStart() == caret.getSelectionEnd()) {
            caret.moveCaretRelatively(boundString.length(), 0, false, false);
        }
    }

    public static final /* synthetic */ void access$processCaret(BaseToggleStateAction $this, PsiFile file, Editor editor2, Caret caret, boolean state) {
        $this.processCaret(file, editor2, caret, state);
    }

    static {
        Object[] objectArray = new IElementType[]{MarkdownElementTypes.LINK_DESTINATION, MarkdownElementTypes.AUTOLINK, MarkdownTokenTypes.GFM_AUTOLINK};
        elementsToIgnore = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/BaseToggleStateAction$Companion;", "", "()V", "elementsToIgnore", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

