/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.structureView;

import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.intellij.plugins.markdown.util.MarkdownPsiStructureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownStructureElement
extends PsiTreeElementBase<PsiElement>
implements SortableTreeElement,
LocationPresentation,
Queryable {
    private static final ItemPresentation DUMMY_PRESENTATION = new MarkdownBasePresentation(){

        @Nullable
        public String getPresentableText() {
            return null;
        }
    };

    MarkdownStructureElement(@NotNull PsiElement element2) {
        super(element2);
    }

    public boolean canNavigate() {
        return this.getElement() instanceof NavigationItem && ((NavigationItem)this.getElement()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getElement() instanceof NavigationItem && ((NavigationItem)this.getElement()).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        if (this.getElement() instanceof NavigationItem) {
            ((NavigationItem)this.getElement()).navigate(requestFocus);
        }
    }

    @NotNull
    public String getAlphaSortKey() {
        return StringUtil.notNullize(this.getElement() instanceof NavigationItem ? ((NavigationItem)this.getElement()).getName() : null);
    }

    public boolean isSearchInLocationString() {
        return true;
    }

    @Nullable
    public String getPresentableText() {
        PsiElement tag = this.getElement();
        if (tag == null) {
            return StructureViewBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]);
        }
        return this.getPresentation().getPresentableText();
    }

    public String getLocationString() {
        return this.getPresentation().getLocationString();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresent;
        if (this.getElement() instanceof PsiFileImpl) {
            ItemPresentation filePresent = ((PsiFileImpl)this.getElement()).getPresentation();
            return filePresent != null ? filePresent : DUMMY_PRESENTATION;
        }
        if (this.getElement() instanceof NavigationItem && (itemPresent = ((NavigationItem)this.getElement()).getPresentation()) != null) {
            return itemPresent;
        }
        return DUMMY_PRESENTATION;
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        ArrayList<StructureViewTreeElement> elements2 = new ArrayList<StructureViewTreeElement>();
        MarkdownPsiStructureUtil.processContainer(this.getElement(), (Consumer<PsiElement>)((Consumer)element2 -> elements2.add((StructureViewTreeElement)new MarkdownStructureElement((PsiElement)element2))));
        return elements2;
    }

    @NotNull
    public String getLocationPrefix() {
        return " ";
    }

    @NotNull
    public String getLocationSuffix() {
        return "";
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        info.put("text", this.getPresentableText());
        if (!(this.getElement() instanceof PsiFileImpl)) {
            info.put("location", this.getLocationString());
        }
    }
}

