/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.spellchecking;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;

public class MarkdownSpellcheckingStrategy
extends SpellcheckingStrategy {
    public static final TokenSet NO_SPELLCHECKING_TYPES = TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.CODE_BLOCK, MarkdownElementTypes.CODE_FENCE, MarkdownElementTypes.CODE_SPAN, MarkdownElementTypes.LINK_DESTINATION});

    @NotNull
    public Tokenizer getTokenizer(PsiElement element2) {
        ASTNode node = element2.getNode();
        if (node == null || node.getElementType() != MarkdownTokenTypes.TEXT) {
            return EMPTY_TOKENIZER;
        }
        if (TreeUtil.findParent((ASTNode)node, (TokenSet)NO_SPELLCHECKING_TYPES) != null) {
            return EMPTY_TOKENIZER;
        }
        return TEXT_TOKENIZER;
    }
}

