/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings.pandoc;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.pandoc.PandocExecutableDetector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/settings/pandoc/PandocExecutableDetector;", "", "()V", "UNIX_EXECUTABLE", "", "UNIX_PATHS", "", "getUNIX_PATHS", "()Ljava/util/List;", "UNIX_PATHS$delegate", "Lkotlin/Lazy;", "WIN_EXECUTABLE", "WIN_PANDOC_DIR_NAME", "detect", "project", "Lcom/intellij/openapi/project/Project;", "detectForUnix", "detectForWindows", "obtainPandocVersion", "executable", "GetVersionPandocTask", "intellij.markdown.core"})
public final class PandocExecutableDetector {
    @NotNull
    public static final PandocExecutableDetector INSTANCE = new PandocExecutableDetector();
    @NotNull
    private static final String WIN_EXECUTABLE = "pandoc.exe";
    @NotNull
    private static final String WIN_PANDOC_DIR_NAME = "Pandoc";
    @NotNull
    private static final String UNIX_EXECUTABLE = "pandoc";
    @NotNull
    private static final Lazy UNIX_PATHS$delegate = LazyKt.lazy((Function0)UNIX_PATHS.2.INSTANCE);

    private PandocExecutableDetector() {
    }

    private final List<String> getUNIX_PATHS() {
        Lazy lazy = UNIX_PATHS$delegate;
        return (List)lazy.getValue();
    }

    @Nullable
    public final String obtainPandocVersion(@NotNull Project project, @NotNull String executable) {
        return (String)ProgressManager.getInstance().run((Task.WithResult)new GetVersionPandocTask(project, executable));
    }

    public static /* synthetic */ String obtainPandocVersion$default(PandocExecutableDetector pandocExecutableDetector, Project project, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = UNIX_EXECUTABLE;
        }
        return pandocExecutableDetector.obtainPandocVersion(project, string);
    }

    @Nullable
    public final String detect(@NotNull Project project) {
        String string;
        if (!TrustedProjects.isTrusted((Project)project)) {
            return null;
        }
        File executableFromPath = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? WIN_EXECUTABLE : UNIX_EXECUTABLE), (String)PathEnvironmentVariableUtil.getPathVariableValue(), null);
        File file = executableFromPath;
        if (file != null) {
            return file.getAbsolutePath();
        }
        if (SystemInfo.isWindows) {
            string = this.detectForWindows();
            if (string == null) {
                string = "";
            }
        } else {
            string = this.detectForUnix();
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    private final String detectForUnix() {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getUNIX_PATHS()), (Function1)detectForUnix.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        File file = v0;
        return file != null ? file.getPath() : null;
    }

    private final String detectForWindows() {
        String[] stringArray = new String[]{EnvironmentUtil.getValue((String)"LOCALAPPDATA"), EnvironmentUtil.getValue((String)"ProgramFiles"), EnvironmentUtil.getValue((String)"ProgramFiles(x86)"), EnvironmentUtil.getValue((String)"HOMEPATH")};
        List paths = CollectionsKt.listOf((Object[])stringArray);
        for (String basePath : paths) {
            File path = new File(basePath, WIN_PANDOC_DIR_NAME);
            File file = new File(path, WIN_EXECUTABLE);
            if (!file.exists()) continue;
            return file.getPath();
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u0004\u0018\u00010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/settings/pandoc/PandocExecutableDetector$GetVersionPandocTask;", "Lcom/intellij/openapi/progress/Task$WithResult;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "project", "Lcom/intellij/openapi/project/Project;", "executableName", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "compute", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "extractVersion", "lines", "", "intellij.markdown.core"})
    private static final class GetVersionPandocTask
    extends Task.WithResult<String, Exception> {
        @NotNull
        private final String executableName;

        public GetVersionPandocTask(@NotNull Project project, @NotNull String executableName) {
            super(project, MarkdownBundle.message("markdown.settings.pandoc.executable.version.process", new Object[0]), true);
            this.executableName = executableName;
        }

        public /* synthetic */ GetVersionPandocTask(Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = PandocExecutableDetector.UNIX_EXECUTABLE;
            }
            this(project, string);
        }

        @Nullable
        protected String compute(@NotNull ProgressIndicator indicator) {
            String[] stringArray = new String[]{this.executableName, "-v"};
            GeneralCommandLine command = new GeneralCommandLine(stringArray);
            try {
                String string;
                ProcessOutput processOutput;
                ProcessOutput it = processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)command);
                boolean bl = false;
                Object output = ((CharSequence)it.getStderr()).length() == 0 ? processOutput : null;
                Object object = output;
                if (object != null && (object = object.getStdoutLines()) != null) {
                    Object p0 = object;
                    boolean bl2 = false;
                    string = this.extractVersion((List<String>)p0);
                } else {
                    string = null;
                }
                return string;
            }
            catch (Throwable exception) {
                return null;
            }
        }

        private final String extractVersion(List<String> lines2) {
            String firstLinePrefix;
            String line = (String)CollectionsKt.first(lines2);
            if (!StringsKt.startsWith$default((String)line, (String)(firstLinePrefix = "pandoc "), (boolean)false, (int)2, null)) {
                return null;
            }
            return StringsKt.substringAfter$default((String)line, (String)firstLinePrefix, null, (int)2, null);
        }
    }
}

