/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.settings.MarkdownSettingsMigration;
import org.intellij.plugins.markdown.settings.MarkdownSettingsState;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.jcef.JCEFHtmlPanelProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="MarkdownSettings", storages={@Storage(value="markdown.xml")})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 H2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002GHB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0002H\u0016J\b\u0010A\u001a\u00020?H\u0016J\u0010\u0010B\u001a\u00020\u00022\u0006\u0010C\u001a\u00020\u0002H\u0002J\u001a\u0010D\u001a\u00020?2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020?0FR$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R(\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\n\"\u0004\b \u0010\fR$\u0010!\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\n\"\u0004\b\"\u0010\fR$\u0010#\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\n\"\u0004\b$\u0010\fRB\u0010(\u001a\u00110%\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(\u00062\u0015\u0010\u0006\u001a\u00110%\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R$\u0010/\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\n\"\u0004\b1\u0010\fR$\u00103\u001a\u0002022\u0006\u0010\u0006\u001a\u0002028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u00107R$\u00108\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010\n\"\u0004\b:\u0010\fR$\u0010;\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010\n\"\u0004\b=\u0010\f\u00a8\u0006I"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lorg/intellij/plugins/markdown/settings/MarkdownSettingsState;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "areInjectionsEnabled", "getAreInjectionsEnabled", "()Z", "setAreInjectionsEnabled", "(Z)V", "", "customStylesheetPath", "getCustomStylesheetPath", "()Ljava/lang/String;", "setCustomStylesheetPath", "(Ljava/lang/String;)V", "customStylesheetText", "getCustomStylesheetText", "setCustomStylesheetText", "fontFamily", "getFontFamily", "setFontFamily", "", "fontSize", "getFontSize", "()I", "setFontSize", "(I)V", "isAutoScrollEnabled", "setAutoScrollEnabled", "isEnhancedEditingEnabled", "setEnhancedEditingEnabled", "isVerticalSplit", "setVerticalSplit", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;", "Lkotlin/ParameterName;", "name", "previewPanelProviderInfo", "getPreviewPanelProviderInfo", "()Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;", "setPreviewPanelProviderInfo", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;)V", "getProject$intellij_markdown_core", "()Lcom/intellij/openapi/project/Project;", "showProblemsInCodeBlocks", "getShowProblemsInCodeBlocks", "setShowProblemsInCodeBlocks", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "splitLayout", "getSplitLayout", "()Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "setSplitLayout", "(Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;)V", "useCustomStylesheetPath", "getUseCustomStylesheetPath", "setUseCustomStylesheetPath", "useCustomStylesheetText", "getUseCustomStylesheetText", "setUseCustomStylesheetText", "loadState", "", "state", "noStateLoaded", "possiblyMigrateSettings", "from", "update", "block", "Lkotlin/Function1;", "ChangeListener", "Companion", "intellij.markdown.core"})
public final class MarkdownSettings
extends SimplePersistentStateComponent<MarkdownSettingsState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public MarkdownSettings(@NotNull Project project) {
        super((BaseState)new MarkdownSettingsState());
        this.project = project;
    }

    @NotNull
    public final Project getProject$intellij_markdown_core() {
        return this.project;
    }

    public final boolean getAreInjectionsEnabled() {
        return ((MarkdownSettingsState)this.getState()).getAreInjectionsEnabled();
    }

    public final void setAreInjectionsEnabled(boolean value) {
        ((MarkdownSettingsState)this.getState()).setAreInjectionsEnabled(value);
    }

    public final boolean getShowProblemsInCodeBlocks() {
        return ((MarkdownSettingsState)this.getState()).getShowProblemsInCodeBlocks();
    }

    public final void setShowProblemsInCodeBlocks(boolean value) {
        ((MarkdownSettingsState)this.getState()).setShowProblemsInCodeBlocks(value);
    }

    public final boolean isEnhancedEditingEnabled() {
        return ((MarkdownSettingsState)this.getState()).isEnhancedEditingEnabled();
    }

    public final void setEnhancedEditingEnabled(boolean value) {
        ((MarkdownSettingsState)this.getState()).setEnhancedEditingEnabled(value);
    }

    @NotNull
    public final TextEditorWithPreview.Layout getSplitLayout() {
        return ((MarkdownSettingsState)this.getState()).getSplitLayout();
    }

    public final void setSplitLayout(@NotNull TextEditorWithPreview.Layout value) {
        ((MarkdownSettingsState)this.getState()).setSplitLayout(value);
    }

    @NotNull
    public final MarkdownHtmlPanelProvider.ProviderInfo getPreviewPanelProviderInfo() {
        return ((MarkdownSettingsState)this.getState()).getPreviewPanelProviderInfo();
    }

    public final void setPreviewPanelProviderInfo(@NotNull MarkdownHtmlPanelProvider.ProviderInfo value) {
        ((MarkdownSettingsState)this.getState()).setPreviewPanelProviderInfo(value);
    }

    public final boolean isVerticalSplit() {
        return ((MarkdownSettingsState)this.getState()).isVerticalSplit();
    }

    public final void setVerticalSplit(boolean value) {
        ((MarkdownSettingsState)this.getState()).setVerticalSplit(value);
    }

    public final boolean isAutoScrollEnabled() {
        return ((MarkdownSettingsState)this.getState()).isAutoScrollEnabled();
    }

    public final void setAutoScrollEnabled(boolean value) {
        ((MarkdownSettingsState)this.getState()).setAutoScrollEnabled(value);
    }

    public final boolean getUseCustomStylesheetPath() {
        return ((MarkdownSettingsState)this.getState()).getUseCustomStylesheetPath();
    }

    public final void setUseCustomStylesheetPath(boolean value) {
        ((MarkdownSettingsState)this.getState()).setUseCustomStylesheetPath(value);
    }

    @Nullable
    public final String getCustomStylesheetPath() {
        return ((MarkdownSettingsState)this.getState()).getCustomStylesheetPath();
    }

    public final void setCustomStylesheetPath(@Nullable String value) {
        ((MarkdownSettingsState)this.getState()).setCustomStylesheetPath(value);
    }

    public final boolean getUseCustomStylesheetText() {
        return ((MarkdownSettingsState)this.getState()).getUseCustomStylesheetText();
    }

    public final void setUseCustomStylesheetText(boolean value) {
        ((MarkdownSettingsState)this.getState()).setUseCustomStylesheetText(value);
    }

    @Nullable
    public final String getCustomStylesheetText() {
        return ((MarkdownSettingsState)this.getState()).getCustomStylesheetText();
    }

    public final void setCustomStylesheetText(@Nullable String value) {
        ((MarkdownSettingsState)this.getState()).setCustomStylesheetText(value);
    }

    public final int getFontSize() {
        return ((MarkdownSettingsState)this.getState()).getFontSize();
    }

    public final void setFontSize(int value) {
        ((MarkdownSettingsState)this.getState()).setFontSize(value);
    }

    @Nullable
    public final String getFontFamily() {
        return ((MarkdownSettingsState)this.getState()).getFontFamily();
    }

    public final void setFontFamily(@Nullable String value) {
        ((MarkdownSettingsState)this.getState()).setFontFamily(value);
    }

    public void loadState(@NotNull MarkdownSettingsState state) {
        MarkdownSettingsState migrated = this.possiblyMigrateSettings(state);
        super.loadState((BaseState)migrated);
    }

    public void noStateLoaded() {
        super.noStateLoaded();
        this.loadState(new MarkdownSettingsState());
    }

    public final synchronized void update(@NotNull Function1<? super MarkdownSettings, Unit> block) {
        ChangeListener publisher = (ChangeListener)this.project.getMessageBus().syncPublisher(ChangeListener.TOPIC);
        publisher.beforeSettingsChanged(this);
        block.invoke((Object)this);
        publisher.settingsChanged(this);
    }

    private final MarkdownSettingsState possiblyMigrateSettings(MarkdownSettingsState from) {
        MarkdownSettingsState migrated;
        MarkdownApplicationSettings markdownApplicationSettings;
        MarkdownApplicationSettings it = markdownApplicationSettings = MarkdownApplicationSettings.getInstance();
        boolean bl = false;
        MarkdownApplicationSettings old = it.getState() != null ? markdownApplicationSettings : null;
        MarkdownSettingsMigration migration = MarkdownSettingsMigration.Companion.getInstance(this.project);
        if (old == null || ((MarkdownSettingsMigration.State)migration.getState()).getStateVersion() == 1) {
            return from;
        }
        logger.info("Migrating Markdown settings");
        MarkdownSettingsState $this$possiblyMigrateSettings_u24lambda_u245 = migrated = new MarkdownSettingsState();
        boolean bl2 = false;
        Object it2 = old.getMarkdownPreviewSettings();
        boolean bl3 = false;
        $this$possiblyMigrateSettings_u24lambda_u245.setPreviewPanelProviderInfo(((MarkdownPreviewSettings)it2).getHtmlPanelProviderInfo());
        $this$possiblyMigrateSettings_u24lambda_u245.setSplitLayout(((MarkdownPreviewSettings)it2).getSplitEditorLayout());
        $this$possiblyMigrateSettings_u24lambda_u245.setAutoScrollEnabled(((MarkdownPreviewSettings)it2).isAutoScrollPreview());
        $this$possiblyMigrateSettings_u24lambda_u245.setVerticalSplit(((MarkdownPreviewSettings)it2).isVerticalSplit());
        it2 = old.getMarkdownCssSettings();
        boolean bl4 = false;
        String string = ((MarkdownCssSettings)it2).getCustomStylesheetPath();
        MarkdownSettingsState markdownSettingsState = $this$possiblyMigrateSettings_u24lambda_u245;
        boolean bl5 = false;
        markdownSettingsState.setCustomStylesheetPath(Boolean.valueOf(((MarkdownCssSettings)it2).isCustomStylesheetEnabled()) != false ? string : null);
        string = ((MarkdownCssSettings)it2).getCustomStylesheetText();
        markdownSettingsState = $this$possiblyMigrateSettings_u24lambda_u245;
        boolean bl6 = false;
        markdownSettingsState.setCustomStylesheetText(Boolean.valueOf(((MarkdownCssSettings)it2).isTextEnabled()) != false ? string : null);
        $this$possiblyMigrateSettings_u24lambda_u245.setFontFamily(((MarkdownCssSettings)it2).getFontFamily());
        $this$possiblyMigrateSettings_u24lambda_u245.setFontSize(((MarkdownCssSettings)it2).getFontSize());
        $this$possiblyMigrateSettings_u24lambda_u245.setEnabledExtensions(old.getExtensionsEnabledState());
        $this$possiblyMigrateSettings_u24lambda_u245.setAreInjectionsEnabled(!old.isDisableInjections());
        $this$possiblyMigrateSettings_u24lambda_u245.setShowProblemsInCodeBlocks(!old.isHideErrors());
        $this$possiblyMigrateSettings_u24lambda_u245.setEnhancedEditingEnabled(old.isEnhancedEditingEnabled());
        $this$possiblyMigrateSettings_u24lambda_u245.resetModificationCount();
        ((MarkdownSettingsMigration.State)migration.getState()).setStateVersion(1);
        return migrated;
    }

    @NotNull
    public static final MarkdownHtmlPanelProvider.ProviderInfo getDefaultProviderInfo() {
        return Companion.getDefaultProviderInfo();
    }

    @JvmStatic
    @NotNull
    public static final MarkdownSettings getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarkdownSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        MarkdownSettings.logger = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettings$ChangeListener;", "", "beforeSettingsChanged", "", "settings", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings;", "settingsChanged", "Companion", "intellij.markdown.core"})
    public static interface ChangeListener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @JvmField
        @NotNull
        public static final Topic<ChangeListener> TOPIC = new Topic("MarkdownSettingsChanged", ChangeListener.class, Topic.BroadcastDirection.NONE);

        default public void beforeSettingsChanged(@NotNull MarkdownSettings settings) {
        }

        default public void settingsChanged(@NotNull MarkdownSettings settings) {
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettings$ChangeListener$Companion;", "", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings$ChangeListener;", "kotlin.jvm.PlatformType", "intellij.markdown.core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0006\u0010\u0018\u001a\u00020\u0015R\u001b\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettings$Companion;", "", "()V", "defaultFontFamily", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "getDefaultFontFamily", "()Ljava/lang/String;", "defaultFontSize", "", "getDefaultFontSize", "()I", "defaultProviderInfo", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;", "getDefaultProviderInfo$annotations", "getDefaultProviderInfo", "()Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceForDefaultProject", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDefaultFontSize() {
            AppEditorFontOptions.PersistentFontPreferences persistentFontPreferences = AppEditorFontOptions.getInstance().getState();
            if (persistentFontPreferences == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            return JBCefApp.normalizeScaledSize((int)((int)((double)persistentFontPreferences.FONT_SIZE + 0.5)));
        }

        @NotNull
        public final String getDefaultFontFamily() {
            AppEditorFontOptions.PersistentFontPreferences persistentFontPreferences = AppEditorFontOptions.getInstance().getState();
            if (persistentFontPreferences == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            return persistentFontPreferences.FONT_FAMILY;
        }

        @NotNull
        public final MarkdownHtmlPanelProvider.ProviderInfo getDefaultProviderInfo() {
            return JBCefApp.isSupported() ? new JCEFHtmlPanelProvider().getProviderInfo() : new MarkdownHtmlPanelProvider.ProviderInfo("Unavailable", "Unavailable");
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultProviderInfo$annotations() {
        }

        @JvmStatic
        @NotNull
        public final MarkdownSettings getInstance(@NotNull Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<MarkdownSettings> serviceClass$iv = MarkdownSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (MarkdownSettings)((Object)object);
        }

        @NotNull
        public final MarkdownSettings getInstanceForDefaultProject() {
            ComponentManager $this$service$iv = (ComponentManager)ProjectManager.getInstance().getDefaultProject();
            boolean $i$f$service = false;
            Class<MarkdownSettings> serviceClass$iv = MarkdownSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (MarkdownSettings)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

