/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.labels;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.model.Pointer;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.NavigationRequest;
import com.intellij.navigation.NavigationService;
import com.intellij.navigation.NavigationTarget;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinition;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkLabel;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownShortReferenceLink;
import org.intellij.plugins.markdown.model.psi.MarkdownSymbolWithUsages;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 42\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u000245B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003J'\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0010\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000$H\u0016J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*2\u0006\u0010+\u001a\u00020,H\u0016J\t\u0010-\u001a\u00020.H\u00d6\u0001J\n\u0010/\u001a\u0004\u0018\u000100H\u0016J\b\u00101\u001a\u000202H\u0016J\t\u00103\u001a\u00020\u000bH\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00066"}, d2={"Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol;", "Lorg/intellij/plugins/markdown/model/psi/MarkdownSymbolWithUsages;", "Lcom/intellij/find/usages/api/SearchTarget;", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/navigation/NavigationTarget;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "text", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "maximalSearchScope", "Lcom/intellij/psi/search/SearchScope;", "getMaximalSearchScope", "()Lcom/intellij/psi/search/SearchScope;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "searchText", "getSearchText", "()Ljava/lang/String;", "targetName", "getTargetName", "getText", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "component1", "component2", "component3", "copy", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "getNavigationTargets", "", "project", "Lcom/intellij/openapi/project/Project;", "hashCode", "", "navigationRequest", "Lcom/intellij/navigation/NavigationRequest;", "presentation", "Lcom/intellij/navigation/TargetPresentation;", "toString", "Companion", "LinkLabelPointer", "intellij.markdown.core"})
@ApiStatus.Internal
public final class LinkLabelSymbol
implements MarkdownSymbolWithUsages,
SearchTarget,
RenameTarget,
NavigatableSymbol,
NavigationTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange range;
    @NotNull
    private final String text;

    public LinkLabelSymbol(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String text) {
        this.file = file;
        this.range = range;
        this.text = text;
    }

    @Override
    @NotNull
    public PsiFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public TextRange getRange() {
        return this.range;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public Pointer<? extends LinkLabelSymbol> createPointer() {
        Project project = this.getFile().getProject();
        SmartPsiFileRange base2 = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(this.getFile(), this.getRange());
        return new LinkLabelPointer(base2, this.text);
    }

    @NotNull
    public String getTargetName() {
        return this.text;
    }

    @Nullable
    public SearchScope getMaximalSearchScope() {
        return (SearchScope)GlobalSearchScope.fileScope((PsiFile)this.getFile());
    }

    @NotNull
    public UsageHandler getUsageHandler() {
        return UsageHandler.createEmptyUsageHandler((String)this.text);
    }

    @Override
    @NotNull
    public String getSearchText() {
        return this.text;
    }

    @NotNull
    public TargetPresentation presentation() {
        return TargetPresentation.Companion.builder(this.text).icon(MarkdownIcons.EditorActions.Link).presentation();
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        Object object;
        block3: {
            block2: {
                VirtualFile virtualFile;
                object = this.getFile().getVirtualFile();
                if (object == null) break block2;
                VirtualFile it = virtualFile = object;
                boolean bl = false;
                object = it.isValid() ? virtualFile : null;
                if (object != null) break block3;
            }
            return null;
        }
        VirtualFile virtualFile = object;
        return NavigationService.Companion.instance().sourceNavigationRequest(virtualFile, this.getRange().getStartOffset());
    }

    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        return CollectionsKt.listOf((Object)this);
    }

    @NotNull
    public final PsiFile component1() {
        return this.getFile();
    }

    @NotNull
    public final TextRange component2() {
        return this.getRange();
    }

    @NotNull
    public final String component3() {
        return this.text;
    }

    @NotNull
    public final LinkLabelSymbol copy(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String text) {
        return new LinkLabelSymbol(file, range, text);
    }

    public static /* synthetic */ LinkLabelSymbol copy$default(LinkLabelSymbol linkLabelSymbol, PsiFile psiFile, TextRange textRange, String string, int n, Object object) {
        if ((n & 1) != 0) {
            psiFile = linkLabelSymbol.getFile();
        }
        if ((n & 2) != 0) {
            textRange = linkLabelSymbol.getRange();
        }
        if ((n & 4) != 0) {
            string = linkLabelSymbol.text;
        }
        return linkLabelSymbol.copy(psiFile, textRange, string);
    }

    @NotNull
    public String toString() {
        return "LinkLabelSymbol(file=" + this.getFile() + ", range=" + this.getRange() + ", text=" + this.text + ")";
    }

    public int hashCode() {
        int result2 = this.getFile().hashCode();
        result2 = result2 * 31 + this.getRange().hashCode();
        result2 = result2 * 31 + this.text.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LinkLabelSymbol)) {
            return false;
        }
        LinkLabelSymbol linkLabelSymbol = (LinkLabelSymbol)other;
        if (!Intrinsics.areEqual((Object)this.getFile(), (Object)linkLabelSymbol.getFile())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getRange(), (Object)linkLabelSymbol.getRange())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)linkLabelSymbol.text);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol$LinkLabelPointer;", "Lcom/intellij/model/Pointer;", "Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol;", "base", "Lcom/intellij/psi/SmartPsiFileRange;", "text", "", "(Lcom/intellij/psi/SmartPsiFileRange;Ljava/lang/String;)V", "dereference", "intellij.markdown.core"})
    private static final class LinkLabelPointer
    implements Pointer<LinkLabelSymbol> {
        @NotNull
        private final SmartPsiFileRange base;
        @NotNull
        private final String text;

        public LinkLabelPointer(@NotNull SmartPsiFileRange base2, @NotNull String text) {
            this.base = base2;
            this.text = text;
        }

        @Nullable
        public LinkLabelSymbol dereference() {
            PsiFile psiFile = this.base.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            PsiFile file = psiFile;
            Segment segment = this.base.getRange();
            if (segment == null) {
                return null;
            }
            Segment range = segment;
            return new LinkLabelSymbol(file, TextRange.create((Segment)range), this.text);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0005R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006R\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol$Companion;", "", "()V", "isDeclaration", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkLabel;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkLabel;)Z", "isShortLink", "createPointer", "Lcom/intellij/model/Pointer;", "Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol;", "label", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Pointer<LinkLabelSymbol> createPointer(@NotNull MarkdownLinkLabel label) {
            String text = label.getText();
            TextRange rangeInElement = new TextRange(0, text.length());
            TextRange absoluteRange = rangeInElement.shiftRight(UtilsKt.getStartOffset((PsiElement)((PsiElement)label)));
            String textInElement = rangeInElement.substring(text);
            PsiFile file = label.getContainingFile();
            Project project = file.getProject();
            SmartPsiFileRange base2 = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(file, absoluteRange);
            return new LinkLabelPointer(base2, textInElement);
        }

        public final boolean isDeclaration(@NotNull MarkdownLinkLabel $this$isDeclaration) {
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)$this$isDeclaration;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            return PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownLinkDefinition.class, (boolean)true) != null;
        }

        public final boolean isShortLink(@NotNull MarkdownLinkLabel $this$isShortLink) {
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)$this$isShortLink;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            return PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownShortReferenceLink.class, (boolean)true) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

