/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.headers;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.model.Pointer;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.NavigationRequest;
import com.intellij.navigation.NavigationService;
import com.intellij.navigation.NavigationTarget;
import com.intellij.navigation.TargetPresentation;
import com.intellij.navigation.TargetPresentationBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderContent;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.model.psi.MarkdownSymbolWithUsages;
import org.intellij.plugins.markdown.model.psi.headers.HeaderSymbol$Companion$createPointer$;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 72\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u000278B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\u000bH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J1\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001J\u0010\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000'H\u0016J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050-2\u0006\u0010.\u001a\u00020/H\u0016J\t\u00100\u001a\u000201H\u00d6\u0001J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u000205H\u0016J\t\u00106\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00069"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol;", "Lorg/intellij/plugins/markdown/model/psi/MarkdownSymbolWithUsages;", "Lcom/intellij/find/usages/api/SearchTarget;", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/navigation/NavigationTarget;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "text", "", "anchorText", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;Ljava/lang/String;)V", "getAnchorText", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/psi/PsiFile;", "maximalSearchScope", "Lcom/intellij/psi/search/SearchScope;", "getMaximalSearchScope", "()Lcom/intellij/psi/search/SearchScope;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "searchText", "getSearchText", "targetName", "getTargetName", "getText", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "component1", "component2", "component3", "component4", "copy", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "getNavigationTargets", "", "project", "Lcom/intellij/openapi/project/Project;", "hashCode", "", "navigationRequest", "Lcom/intellij/navigation/NavigationRequest;", "presentation", "Lcom/intellij/navigation/TargetPresentation;", "toString", "Companion", "HeaderSymbolPointer", "intellij.markdown.core"})
@ApiStatus.Internal
public final class HeaderSymbol
implements MarkdownSymbolWithUsages,
SearchTarget,
RenameTarget,
NavigatableSymbol,
NavigationTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange range;
    @NotNull
    private final String text;
    @NotNull
    private final String anchorText;

    public HeaderSymbol(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String text, @NotNull String anchorText) {
        this.file = file;
        this.range = range;
        this.text = text;
        this.anchorText = anchorText;
    }

    @Override
    @NotNull
    public PsiFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public TextRange getRange() {
        return this.range;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getAnchorText() {
        return this.anchorText;
    }

    @NotNull
    public Pointer<? extends HeaderSymbol> createPointer() {
        Project project = this.getFile().getProject();
        SmartPsiFileRange base2 = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(this.getFile(), this.getRange());
        return new HeaderSymbolPointer(base2, this.text, this.anchorText);
    }

    @NotNull
    public String getTargetName() {
        return this.text;
    }

    @Override
    @NotNull
    public String getSearchText() {
        return this.anchorText;
    }

    @NotNull
    public SearchScope getMaximalSearchScope() {
        return (SearchScope)GlobalSearchScope.allScope((Project)this.getFile().getProject());
    }

    @NotNull
    public UsageHandler getUsageHandler() {
        return UsageHandler.createEmptyUsageHandler((String)this.anchorText);
    }

    @NotNull
    public TargetPresentation presentation() {
        VirtualFile virtualFile = this.getFile().getContainingFile().getVirtualFile();
        TargetPresentationBuilder builder = TargetPresentation.Companion.builder(this.text).icon(MarkdownIcons.EditorActions.Header_level_up);
        TargetPresentationBuilder presentation = virtualFile == null ? builder : (Intrinsics.areEqual((Object)virtualFile.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE)) ? builder.locationText(virtualFile.getName(), MarkdownIcons.MarkdownPlugin) : builder.locationText(virtualFile.getName()));
        return presentation.presentation();
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        Object object;
        block3: {
            block2: {
                VirtualFile virtualFile;
                object = this.getFile().getVirtualFile();
                if (object == null) break block2;
                VirtualFile it = virtualFile = object;
                boolean bl = false;
                object = it.isValid() ? virtualFile : null;
                if (object != null) break block3;
            }
            return null;
        }
        VirtualFile virtualFile = object;
        return NavigationService.Companion.instance().sourceNavigationRequest(virtualFile, this.getRange().getStartOffset());
    }

    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        return CollectionsKt.listOf((Object)this);
    }

    @NotNull
    public final PsiFile component1() {
        return this.getFile();
    }

    @NotNull
    public final TextRange component2() {
        return this.getRange();
    }

    @NotNull
    public final String component3() {
        return this.text;
    }

    @NotNull
    public final String component4() {
        return this.anchorText;
    }

    @NotNull
    public final HeaderSymbol copy(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String text, @NotNull String anchorText) {
        return new HeaderSymbol(file, range, text, anchorText);
    }

    public static /* synthetic */ HeaderSymbol copy$default(HeaderSymbol headerSymbol, PsiFile psiFile, TextRange textRange, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            psiFile = headerSymbol.getFile();
        }
        if ((n & 2) != 0) {
            textRange = headerSymbol.getRange();
        }
        if ((n & 4) != 0) {
            string = headerSymbol.text;
        }
        if ((n & 8) != 0) {
            string2 = headerSymbol.anchorText;
        }
        return headerSymbol.copy(psiFile, textRange, string, string2);
    }

    @NotNull
    public String toString() {
        return "HeaderSymbol(file=" + this.getFile() + ", range=" + this.getRange() + ", text=" + this.text + ", anchorText=" + this.anchorText + ")";
    }

    public int hashCode() {
        int result2 = this.getFile().hashCode();
        result2 = result2 * 31 + this.getRange().hashCode();
        result2 = result2 * 31 + this.text.hashCode();
        result2 = result2 * 31 + this.anchorText.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HeaderSymbol)) {
            return false;
        }
        HeaderSymbol headerSymbol = (HeaderSymbol)other;
        if (!Intrinsics.areEqual((Object)this.getFile(), (Object)headerSymbol.getFile())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getRange(), (Object)headerSymbol.getRange())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)headerSymbol.text)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.anchorText, (Object)headerSymbol.anchorText);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol$HeaderSymbolPointer;", "Lcom/intellij/model/Pointer;", "Lorg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol;", "base", "Lcom/intellij/psi/SmartPsiFileRange;", "text", "", "anchorText", "(Lcom/intellij/psi/SmartPsiFileRange;Ljava/lang/String;Ljava/lang/String;)V", "dereference", "intellij.markdown.core"})
    private static final class HeaderSymbolPointer
    implements Pointer<HeaderSymbol> {
        @NotNull
        private final SmartPsiFileRange base;
        @NotNull
        private final String text;
        @NotNull
        private final String anchorText;

        public HeaderSymbolPointer(@NotNull SmartPsiFileRange base2, @NotNull String text, @NotNull String anchorText) {
            this.base = base2;
            this.text = text;
            this.anchorText = anchorText;
        }

        @Nullable
        public HeaderSymbol dereference() {
            PsiFile psiFile = this.base.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            PsiFile file = psiFile;
            Segment segment = this.base.getRange();
            if (segment == null) {
                return null;
            }
            Segment range = segment;
            return new HeaderSymbol(file, TextRange.create((Segment)range), this.text, this.anchorText);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol$Companion;", "", "()V", "createPointer", "Lcom/intellij/model/Pointer;", "Lorg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol;", "header", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Pointer<HeaderSymbol> createPointer(@NotNull MarkdownHeader header) {
            PsiElement $this$childrenOfType$iv = (PsiElement)header;
            boolean $i$f$childrenOfType = false;
            Sequence<PsiElement> $this$filterIsInstance$iv$iv = PsiUtilsKt.children($this$childrenOfType$iv);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv$iv, (Function1)Companion$createPointer$$inlined$childrenOfType$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            MarkdownHeaderContent markdownHeaderContent = (MarkdownHeaderContent)SequencesKt.firstOrNull((Sequence)sequence);
            if (markdownHeaderContent == null) {
                return null;
            }
            MarkdownHeaderContent headerContent = markdownHeaderContent;
            String string = header.getAnchorText();
            if (string == null) {
                return null;
            }
            String anchorText = string;
            TextRange rangeInContentHolder = headerContent.getNonWhitespaceRange();
            TextRange absoluteRange = rangeInContentHolder.shiftRight(UtilsKt.getStartOffset((PsiElement)((PsiElement)headerContent)));
            String text = rangeInContentHolder.substring(headerContent.getText());
            PsiFile file = header.getContainingFile();
            Project project = file.getProject();
            SmartPsiFileRange base2 = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(file, absoluteRange);
            return new HeaderSymbolPointer(base2, text, anchorText);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

