/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.headers;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinition;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.references.paths.FileWithoutExtensionReference;
import org.intellij.plugins.markdown.model.psi.headers.HeaderAnchorLinkDestinationReference;
import org.intellij.plugins.markdown.model.psi.headers.HeaderAnchorSymbolReferenceProvider$Companion$findExistingFileFromReferences$;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorSymbolReferenceProvider;", "Lcom/intellij/model/psi/PsiSymbolReferenceProvider;", "()V", "getReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "hints", "Lcom/intellij/model/psi/PsiSymbolReferenceHints;", "getSearchRequests", "Lcom/intellij/model/search/SearchRequest;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/model/Symbol;", "Companion", "intellij.markdown.core"})
public final class HeaderAnchorSymbolReferenceProvider
implements PsiSymbolReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Collection<PsiSymbolReference> getReferences(@NotNull PsiExternalReferenceHost element2, @NotNull PsiSymbolReferenceHints hints) {
        if (!(element2 instanceof MarkdownLinkDestination)) {
            return CollectionsKt.emptyList();
        }
        if (MarkdownLinkDefinition.Companion.isUnderCommentWrapper$intellij_markdown_core((PsiElement)element2)) {
            return CollectionsKt.emptyList();
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)element2));
        String elementText = element2.getText();
        TextRange textRange = HeaderAnchorSymbolReferenceProvider.Companion.calculateAnchorTextRange(elementText, range);
        if (textRange == null) {
            return CollectionsKt.emptyList();
        }
        TextRange anchorTextRange = textRange;
        String string = anchorTextRange.substring(elementText).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String anchor = string;
        boolean hasPrefix = anchorTextRange.getStartOffset() != range.getStartOffset();
        PsiFile referencedFile = HeaderAnchorSymbolReferenceProvider.Companion.findExistingFileFromReferences((PsiElement)element2);
        if (hasPrefix && referencedFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement = (PsiElement)element2;
        PsiFile psiFile = referencedFile;
        if (psiFile == null) {
            psiFile = ((MarkdownLinkDestination)element2).getContainingFile();
        }
        HeaderAnchorLinkDestinationReference reference = new HeaderAnchorLinkDestinationReference(psiElement, anchorTextRange, anchor, psiFile);
        return CollectionsKt.listOf((Object)reference);
    }

    @NotNull
    public Collection<SearchRequest> getSearchRequests(@NotNull Project project, @NotNull Symbol target) {
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorSymbolReferenceProvider$Companion;", "", "()V", "calculateAnchorTextRange", "Lcom/intellij/openapi/util/TextRange;", "elementText", "", "valueTextRange", "findExistingFileFromReferences", "Lcom/intellij/psi/PsiFile;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final TextRange calculateAnchorTextRange(String elementText, TextRange valueTextRange) {
            int anchorOffset = StringsKt.indexOf$default((CharSequence)elementText, (char)'#', (int)0, (boolean)false, (int)6, null);
            if (anchorOffset == -1) {
                return null;
            }
            int endOffset = valueTextRange.getEndOffset();
            int endIndex = endOffset <= anchorOffset ? anchorOffset + 1 : endOffset;
            return new TextRange(anchorOffset + 1, endIndex);
        }

        private final PsiFile findExistingFileFromReferences(PsiElement element2) {
            PsiFile psiFile;
            FileWithoutExtensionReference fileWithoutExtensionReference;
            Sequence references;
            List elementReferences = PsiReferenceService.getService().getReferences(element2, PsiReferenceService.Hints.NO_HINTS);
            Collection $this$toTypedArray$iv = elementReferences;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PsiReference[] psiReferenceArray = thisCollection$iv.toArray(new PsiReference[0]);
            PsiFile file = FileReferenceUtil.findFile((PsiReference[])Arrays.copyOf(psiReferenceArray, psiReferenceArray.length));
            if (file != null) {
                return file;
            }
            Sequence $this$filterIsInstance$iv = references = CollectionsKt.asSequence((Iterable)elementReferences);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$findExistingFileFromReferences$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            FileWithoutExtensionReference fileWithoutExtensionReference2 = fileWithoutExtensionReference = (FileWithoutExtensionReference)((Object)SequencesKt.firstOrNull((Sequence)sequence));
            if (fileWithoutExtensionReference2 != null) {
                FileWithoutExtensionReference it = fileWithoutExtensionReference2;
                boolean bl = false;
                PsiElement psiElement = it.resolve();
                psiFile = psiElement instanceof PsiFile ? (PsiFile)psiElement : null;
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

