/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references.paths;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b \u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\nH$J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/FileWithoutExtensionReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "element", "fileReference", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "soft", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;Z)V", "containingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContainingFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "getPath", "()Ljava/lang/String;", "findReferencedFile", "handleElementRename", "newElementName", "resolve", "Companion", "intellij.markdown.core"})
public abstract class FileWithoutExtensionReference
extends PsiReferenceBase<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileReference fileReference;

    public FileWithoutExtensionReference(@NotNull PsiElement element2, @NotNull FileReference fileReference, boolean soft) {
        super(element2, fileReference.getRangeInElement(), soft);
        this.fileReference = fileReference;
    }

    @NotNull
    protected final String getPath() {
        return this.fileReference.getFileReferenceSet().getPathString() + "." + MarkdownFileType.INSTANCE.getDefaultExtension();
    }

    @Nullable
    protected final VirtualFile getContainingFile() {
        PsiFile psiFile = this.getElement().getContainingFile();
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    @Nullable
    public PsiElement resolve() {
        VirtualFile virtualFile = this.findReferencedFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile referencedFile = virtualFile;
        if (referencedFile.getParent().findChild(referencedFile.getNameWithoutExtension()) == null) {
            return (PsiElement)PsiUtilCore.getPsiFile((Project)this.getElement().getProject(), (VirtualFile)referencedFile);
        }
        return null;
    }

    @Nullable
    protected abstract VirtualFile findReferencedFile();

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        String newText = FileWithoutExtensionReference.Companion.hasMarkdownExtensions(newElementName) ? FileUtilRt.getNameWithoutExtension((String)newElementName) : newElementName;
        return super.handleElementRename(newText);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/FileWithoutExtensionReference$Companion;", "", "()V", "hasMarkdownExtensions", "", "name", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasMarkdownExtensions(String name) {
            return FileUtilRt.extensionEquals((String)name, (String)MarkdownFileType.INSTANCE.getDefaultExtension());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

