/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import javax.swing.Icon;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.util.MarkdownPsiStructureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownList
extends MarkdownCompositePsiElementBase {
    private static final String ORDERED_LIST_TEXT = "Ordered list";
    private static final String UNORDERED_LIST_TEXT = "Unordered list";

    public MarkdownList(@NotNull ASTNode node) {
        super(node);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor2).visitList(this);
            return;
        }
        super.accept(visitor2);
    }

    @Override
    public String getPresentableTagName() {
        return this.getNode().getElementType() == MarkdownElementTypes.ORDERED_LIST ? "ol" : "ul";
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                ItemPresentation nestedPresentation = MarkdownList.getSimpleNestedPresentation(MarkdownList.this);
                if (nestedPresentation != null) {
                    return nestedPresentation.getPresentableText();
                }
                return MarkdownList.this.getNode().getElementType() == MarkdownElementTypes.ORDERED_LIST ? MarkdownList.ORDERED_LIST_TEXT : MarkdownList.UNORDERED_LIST_TEXT;
            }

            public String getLocationString() {
                ItemPresentation nestedPresentation = MarkdownList.getSimpleNestedPresentation(MarkdownList.this);
                if (nestedPresentation != null) {
                    return nestedPresentation.getLocationString();
                }
                return null;
            }

            public Icon getIcon(boolean open) {
                return MarkdownPsiStructureUtil.isSimpleNestedList(MarkdownList.this.getParent().getChildren()) ? null : AllIcons.Actions.ListFiles;
            }
        };
    }

    @Nullable
    private static ItemPresentation getSimpleNestedPresentation(@NotNull MarkdownList element2) {
        PsiElement parent = element2.getParent();
        if (MarkdownPsiStructureUtil.isSimpleNestedList(parent.getChildren()) && parent instanceof MarkdownListItem) {
            return ((MarkdownListItem)parent).getPresentation();
        }
        return null;
    }
}

